/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.util;

import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class VanillaCopies {
    public static void renderBillboard(PoseStack poseStack, MultiBufferSource buffer, int i, EntityRenderDispatcher dispatcher, RenderType type, Quaternionf rotation) {
        poseStack.pushPose();
        poseStack.mulPose(dispatcher.cameraOrientation());
        poseStack.mulPose(new Quaternionf().rotateY((float)Math.toRadians(180.0)));
        poseStack.mulPose(rotation);
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix4f = pose.pose();
        VertexConsumer vertexConsumer = buffer.getBuffer(type);
        VanillaCopies.produceVertex(vertexConsumer, matrix4f, pose, i, 0.0f, 0, 0, 1);
        VanillaCopies.produceVertex(vertexConsumer, matrix4f, pose, i, 1.0f, 0, 1, 1);
        VanillaCopies.produceVertex(vertexConsumer, matrix4f, pose, i, 1.0f, 1, 1, 0);
        VanillaCopies.produceVertex(vertexConsumer, matrix4f, pose, i, 0.0f, 1, 0, 0);
        poseStack.popPose();
    }

    public static void produceVertex(VertexConsumer vertexConsumer, Matrix4f modelMatrix, PoseStack.Pose normalMatrix, int light, float x, int y, int textureU, int textureV) {
        vertexConsumer.addVertex(modelMatrix, x - 0.5f, (float)y - 0.25f, 0.0f).setColor(255, 255, 255, 255).setUv((float)textureU, (float)textureV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(normalMatrix, 0.0f, 1.0f, 0.0f);
    }

    public static void renderBeam(LivingEntity actor, Vec3 target, Vec3 prevTarget, float partialTicks, Vec3 color, PoseStack poseStack, MultiBufferSource buffer, RenderType renderType) {
        float j = (float)actor.level().getGameTime() + partialTicks;
        float k = j % 1.0f;
        float l = actor.getEyeHeight() - 1.7f;
        poseStack.pushPose();
        poseStack.translate(0.0, (double)l, 0.0);
        Vec3 vec3 = MathUtils.lerpVec((float)partialTicks, (Vec3)prevTarget, (Vec3)target);
        Vec3 vec32 = VanillaCopies.fromLerpedPosition(actor, l, partialTicks);
        Vec3 vec33 = vec3.subtract(vec32);
        float m = (float)vec33.length();
        vec33 = vec33.normalize();
        float n = (float)Math.acos(vec33.y);
        float o = (float)Math.atan2(vec33.z, vec33.x);
        poseStack.mulPose(Axis.YP.rotationDegrees((1.5707964f - o) * 57.295776f));
        poseStack.mulPose(Axis.XP.rotationDegrees(n * 57.295776f));
        float q = j * 0.05f * -1.5f;
        int red = (int)(color.x() * 255.0);
        int green = (int)(color.y() * 255.0);
        int blue = (int)(color.z() * 255.0);
        float x = Mth.cos((float)(q + 2.3561945f)) * 0.282f;
        float y = Mth.sin((float)(q + 2.3561945f)) * 0.282f;
        float z = Mth.cos((float)(q + 0.7853982f)) * 0.282f;
        float aa = Mth.sin((float)(q + 0.7853982f)) * 0.282f;
        float ab = Mth.cos((float)(q + 3.926991f)) * 0.282f;
        float ac = Mth.sin((float)(q + 3.926991f)) * 0.282f;
        float ad = Mth.cos((float)(q + 5.4977875f)) * 0.282f;
        float ae = Mth.sin((float)(q + 5.4977875f)) * 0.282f;
        float af = Mth.cos((float)(q + (float)Math.PI)) * 0.2f;
        float ag = Mth.sin((float)(q + (float)Math.PI)) * 0.2f;
        float ah = Mth.cos((float)(q + 0.0f)) * 0.2f;
        float ai = Mth.sin((float)(q + 0.0f)) * 0.2f;
        float aj = Mth.cos((float)(q + 1.5707964f)) * 0.2f;
        float ak = Mth.sin((float)(q + 1.5707964f)) * 0.2f;
        float al = Mth.cos((float)(q + 4.712389f)) * 0.2f;
        float am = Mth.sin((float)(q + 4.712389f)) * 0.2f;
        float aq = -1.0f - k;
        float ar = m * 2.5f + aq;
        VertexConsumer vertexConsumer = buffer.getBuffer(renderType);
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix4f = pose.pose();
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, af, m, ag, red, green, blue, 0.4999f, ar);
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, af, 0.0f, ag, red, green, blue, 0.4999f, aq);
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, ah, 0.0f, ai, red, green, blue, 0.0f, aq);
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, ah, m, ai, red, green, blue, 0.0f, ar);
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, aj, m, ak, red, green, blue, 0.4999f, ar);
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, aj, 0.0f, ak, red, green, blue, 0.4999f, aq);
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, al, 0.0f, am, red, green, blue, 0.0f, aq);
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, al, m, am, red, green, blue, 0.0f, ar);
        float as = 0.0f;
        if (actor.tickCount % 2 == 0) {
            as = 0.5f;
        }
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, x, m, y, red, green, blue, 0.5f, as + 0.5f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, z, m, aa, red, green, blue, 1.0f, as + 0.5f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, ad, m, ae, red, green, blue, 1.0f, as);
        VanillaCopies.vertex(vertexConsumer, matrix4f, pose, ab, m, ac, red, green, blue, 0.5f, as);
        poseStack.popPose();
    }

    public static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, PoseStack.Pose pose, float f, float g, float h, int i, int j, int k, float l, float m) {
        vertexConsumer.addVertex(matrix4f, f, g, h).setColor(i, j, k, 255).setUv(l, m).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000A0).setNormal(pose, 0.0f, 0.0f, -1.0f);
    }

    public static Vec3 fromLerpedPosition(LivingEntity entity, double yOffset, float delta) {
        double d = Mth.lerp((double)delta, (double)entity.xOld, (double)entity.getX());
        double e = Mth.lerp((double)delta, (double)entity.yOld, (double)entity.getY()) + yOffset;
        double f = Mth.lerp((double)delta, (double)entity.zOld, (double)entity.getZ());
        return new Vec3(d, e, f);
    }
}

