/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.ai.valid_direction;

import com.cerbon.bosses_of_mass_destruction.entity.ai.valid_direction.IValidDirection;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CanMoveThrough
implements IValidDirection {
    private final Entity entity;
    private final double reactionDistance;

    public CanMoveThrough(Entity entity, double reactionDistance) {
        this.entity = entity;
        this.reactionDistance = reactionDistance;
    }

    @Override
    public boolean isValidDirection(Vec3 normedDirection) {
        Vec3 reactionDirection = normedDirection.scale(this.reactionDistance).add(this.entity.getDeltaMovement());
        Vec3 target = this.entity.position().add(reactionDirection);
        boolean noBlockCollisions = MathUtils.willAABBFit((AABB)this.entity.getBoundingBox(), (Vec3)reactionDirection, box -> !this.entity.level().noCollision(this.entity, box));
        ClipContext context = new ClipContext(this.entity.position().add(normedDirection.scale(1.0)), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, this.entity);
        BlockHitResult blockCollision = this.entity.level().clip(context);
        boolean noFluidCollisions = blockCollision.getType() == HitResult.Type.MISS;
        return noFluidCollisions && noBlockCollisions;
    }
}

