/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.village;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.util.DataComponentUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerTrade
implements VillagerTrades.ItemListing {
    private final Type type;
    private final int emeraldAmount;
    private final int itemAmount;
    private final int maxUses;
    private final int xp;
    private final ItemLike item;
    private final ItemStack itemStack;

    private VillagerTrade(@NotNull Type type, int emeraldAmount, int itemAmount, int maxUses, int xp, ItemLike item, ItemStack itemStack) {
        this.type = type;
        this.emeraldAmount = emeraldAmount;
        this.itemAmount = itemAmount;
        this.maxUses = maxUses;
        this.xp = xp;
        this.item = item;
        this.itemStack = itemStack;
    }

    @Nullable
    public MerchantOffer getOffer(@NotNull Entity trader, @NotNull RandomSource rand) {
        if (this.type == Type.EMERALD_FOR_ITEM) {
            if (this.itemStack != null) {
                return new MerchantOffer(new ItemCost((ItemLike)this.itemStack.getItem()), new ItemStack((ItemLike)Items.EMERALD, this.emeraldAmount), this.maxUses, this.xp, 1.0f);
            }
            if (this.item != null) {
                return new MerchantOffer(new ItemCost((ItemLike)new ItemStack(this.item, this.itemAmount).getItem()), new ItemStack((ItemLike)Items.EMERALD, this.emeraldAmount), this.maxUses, this.xp, 1.0f);
            }
        }
        if (this.type == Type.ITEM_FOR_EMERALD) {
            if (this.itemStack != null) {
                return new MerchantOffer(new ItemCost((ItemLike)new ItemStack((ItemLike)Items.EMERALD, this.emeraldAmount).getItem()), this.itemStack, this.maxUses, this.xp, 1.0f);
            }
            if (this.item != null) {
                return new MerchantOffer(new ItemCost((ItemLike)new ItemStack((ItemLike)Items.EMERALD, this.emeraldAmount).getItem()), new ItemStack(this.item, this.itemAmount), this.maxUses, this.xp, 1.0f);
            }
        }
        return null;
    }

    public static enum Type {
        ITEM_FOR_EMERALD,
        EMERALD_FOR_ITEM;

    }

    public static class TradeBuilder {
        private VillagerTradesEvent villagerEvent;
        private WandererTradesEvent wandererEvent;
        private final int professionLevel;
        private final Type type;
        private final int emeraldAmount;
        private int itemAmount = 1;
        private int maxUses = 10;
        private int xp = 2;
        private ItemLike item;
        private ItemStack itemStack;

        private TradeBuilder(VillagerTradesEvent event, Type type, int emeraldAmount, int professionLevel) {
            this.villagerEvent = event;
            this.type = type;
            this.emeraldAmount = emeraldAmount;
            this.professionLevel = professionLevel;
        }

        private TradeBuilder(WandererTradesEvent event, Type type, int emeraldAmount, int professionLevel) {
            this.wandererEvent = event;
            this.type = type;
            this.emeraldAmount = emeraldAmount;
            this.professionLevel = professionLevel;
        }

        public static TradeBuilder createTrade(VillagerTradesEvent event, ItemLike itemLike, Type type, int emeraldAmount, int professionLevel) {
            return new TradeBuilder(event, type, emeraldAmount, professionLevel).withItem(itemLike);
        }

        public static TradeBuilder createTrade(VillagerTradesEvent event, Type type, int emeraldAmount, int professionLevel) {
            return new TradeBuilder(event, type, emeraldAmount, professionLevel);
        }

        public static TradeBuilder createTrade(WandererTradesEvent event, ItemLike itemLike, Type type, int emeraldAmount, int professionLevel) {
            return new TradeBuilder(event, type, emeraldAmount, professionLevel).withItem(itemLike);
        }

        public static TradeBuilder createTrade(WandererTradesEvent event, Type type, int emeraldAmount, int professionLevel) {
            return new TradeBuilder(event, type, emeraldAmount, professionLevel);
        }

        public TradeBuilder withItem(ItemLike item) {
            this.item = item;
            return this;
        }

        public TradeBuilder withItemStack(ItemStack itemStack) {
            this.itemStack = itemStack;
            return this;
        }

        public TradeBuilder withPocketUpgrade(boolean advanced, ResourceLocation id) {
            RegistryAccess access = this.wandererEvent != null ? this.wandererEvent.getRegistryAccess() : this.villagerEvent.getRegistryAccess();
            Holder.Reference pocketUpgrade = access.registryOrThrow(IPocketUpgrade.REGISTRY).getHolder(id).orElse(null);
            if (pocketUpgrade == null) {
                AdvancedPeripherals.debug("Pocket upgrade " + String.valueOf(id) + " does not exist or was removed by a datapack, skipping villager trade");
                return this;
            }
            ItemStack pocketStack = DataComponentUtil.createStack((ItemLike)(advanced ? (ItemLike)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get() : (ItemLike)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()), (DataComponentType)((DataComponentType)ModRegistry.DataComponents.POCKET_UPGRADE.get()), (Object)UpgradeData.ofDefault((Holder.Reference)pocketUpgrade));
            return this.withItemStack(pocketStack);
        }

        public TradeBuilder withTurtleUpgrade(boolean advanced, ResourceLocation id) {
            RegistryAccess access = this.wandererEvent != null ? this.wandererEvent.getRegistryAccess() : this.villagerEvent.getRegistryAccess();
            Holder.Reference turtleUpgrade = access.registryOrThrow(ITurtleUpgrade.REGISTRY).getHolder(id).orElse(null);
            if (turtleUpgrade == null) {
                AdvancedPeripherals.debug("Pocket upgrade " + String.valueOf(id) + " does not exist or was removed by a datapack, skipping villager trade");
                return this;
            }
            ItemStack turtleStack = DataComponentUtil.createStack((ItemLike)(advanced ? (ItemLike)ModRegistry.Items.TURTLE_ADVANCED.get() : (ItemLike)ModRegistry.Items.TURTLE_NORMAL.get()), (DataComponentType)((DataComponentType)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get()), (Object)UpgradeData.ofDefault((Holder.Reference)turtleUpgrade));
            return this.withItemStack(turtleStack);
        }

        public TradeBuilder setItemAmount(int itemAmount) {
            this.itemAmount = itemAmount;
            return this;
        }

        public TradeBuilder setMaxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public TradeBuilder setXp(int xp) {
            this.xp = xp;
            return this;
        }

        public void build() {
            VillagerTrade trade = new VillagerTrade(this.type, this.emeraldAmount, this.itemAmount, this.maxUses, this.xp, this.item, this.itemStack);
            if (this.wandererEvent != null) {
                if (this.professionLevel == 1) {
                    this.wandererEvent.getGenericTrades().add(trade);
                }
                if (this.professionLevel == 2) {
                    this.wandererEvent.getRareTrades().add(trade);
                }
                return;
            }
            ((List)this.villagerEvent.getTrades().get(this.professionLevel)).add(trade);
        }
    }
}

