/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.owner;

import dan200.computercraft.api.pocket.IPocketAccess;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BasePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.InfinitePocketFuelAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.DataStorageUtil;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PocketPeripheralOwner
extends BasePeripheralOwner {
    private final IPocketAccess pocket;

    public PocketPeripheralOwner(IPocketAccess pocket) {
        this.pocket = pocket;
        if (((Boolean)APConfig.PERIPHERALS_CONFIG.disablePocketFuelConsumption.get()).booleanValue()) {
            this.attachAbility(PeripheralOwnerAbility.FUEL, new InfinitePocketFuelAbility(this));
        }
    }

    @Override
    @Nullable
    public String getCustomName() {
        return null;
    }

    @Override
    @Nullable
    public Level getLevel() {
        return this.pocket.getLevel();
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        Vec3 position = this.pocket.getPosition();
        return new BlockPos((int)position.x, (int)position.y, (int)position.z);
    }

    @Override
    @NotNull
    public Direction getFacing() {
        Entity owner = this.pocket.getEntity();
        if (owner == null) {
            return Direction.NORTH;
        }
        return owner.getDirection();
    }

    @Override
    @NotNull
    public FrontAndTop getOrientation() {
        return FrontAndTop.NORTH_UP;
    }

    @Override
    @Nullable
    public Player getOwner() {
        Entity owner = this.pocket.getEntity();
        if (owner instanceof Player) {
            Player player = (Player)owner;
            return player;
        }
        return null;
    }

    @Override
    public DataComponentPatch getDataStorage() {
        return DataStorageUtil.getDataStorage(this.pocket);
    }

    @Override
    public CompoundTag getNbtStorage() {
        AdvancedPeripherals.debug("Pocket peripheral at " + String.valueOf(this.getPos()) + " tried to use nbt storage but it should instead use data component storage, report to github!", org.apache.logging.log4j.Level.WARN);
        return null;
    }

    @Override
    public void putDataStorage(DataComponentPatch dataStorage) {
        DataStorageUtil.putDataStorage(this.pocket, dataStorage);
    }

    @Override
    public void markDataStorageDirty() {
    }

    @Override
    public <T> T withPlayer(Function<APFakePlayer, T> function) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public ItemStack getToolInMainHand() {
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack storeItem(ItemStack stored) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public void destroyUpgrade() {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public boolean isMovementPossible(@NotNull Level level, @NotNull BlockPos pos) {
        return false;
    }

    @Override
    public boolean move(@NotNull Level level, @NotNull BlockPos pos) {
        return false;
    }
}

