/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.tileentities;

import chanceCubes.blocks.CCubesBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileGiantCube
extends BlockEntity {
    private boolean hasMaster;
    private boolean isMaster;
    private BlockPos masterPos = new BlockPos(0, 0, 0);

    public TileGiantCube(BlockPos pos, BlockState state) {
        super((BlockEntityType)CCubesBlocks.TILE_CHANCE_GIANT.get(), pos, state);
    }

    public void reset() {
        this.masterPos = new BlockPos(0, 0, 0);
        this.hasMaster = false;
        this.isMaster = false;
    }

    public boolean checkForMaster() {
        BlockEntity tile = this.level.getBlockEntity(this.worldPosition.offset((Vec3i)this.masterPos));
        return tile instanceof TileGiantCube;
    }

    protected void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        data.putInt("masterX", this.masterPos.getX());
        data.putInt("masterY", this.masterPos.getY());
        data.putInt("masterZ", this.masterPos.getZ());
        data.putBoolean("hasMaster", this.hasMaster);
        data.putBoolean("isMaster", this.isMaster);
    }

    public void loadAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.loadAdditional(data, registries);
        int masterX = data.getInt("masterX");
        int masterY = data.getInt("masterY");
        int masterZ = data.getInt("masterZ");
        this.masterPos = new BlockPos(masterX, masterY, masterZ);
        this.hasMaster = data.getBoolean("hasMaster");
        this.isMaster = data.getBoolean("isMaster");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, registries);
        return nbt;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        this.loadAdditional(pkt.getTag(), registries);
    }

    public boolean hasMaster() {
        return this.hasMaster;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public BlockPos getMasterPostion() {
        return this.worldPosition.offset((Vec3i)this.masterPos);
    }

    public BlockPos getMasterOffset() {
        return this.masterPos;
    }

    public void setHasMaster(boolean bool) {
        this.hasMaster = bool;
    }

    public void setIsMaster(boolean bool) {
        this.isMaster = bool;
    }

    public void setMasterCoords(int x, int y, int z) {
        this.setMasterCoords(new BlockPos(x, y, z));
    }

    public void setMasterCoords(BlockPos pos) {
        this.masterPos = pos.subtract((Vec3i)this.worldPosition);
    }
}

