/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.ServerChatEvent;

public class CoinFlipReward
extends BaseCustomReward {
    private final Map<Player, Task> inFlip = new HashMap<Player, Task>();

    public CoinFlipReward() {
        super("chancecubes:heads_or_tails", 0);
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
        if (this.inFlip.containsKey(player)) {
            return;
        }
        RewardsUtil.sendMessageToPlayer(player, "Heads or Tails?");
        Task task = new Task("Heads_Or_Tails", 600){

            @Override
            public void callback() {
                CoinFlipReward.this.timeUp(player);
            }
        };
        this.inFlip.put(player, task);
        Scheduler.scheduleTask(task);
    }

    private void timeUp(Player player) {
        if (!this.inFlip.containsKey(player) || !RewardsUtil.isPlayerOnline(player)) {
            return;
        }
        RewardsUtil.sendMessageToPlayer(player, "Seem's that you didn't pick heads or tails.");
        RewardsUtil.sendMessageToPlayer(player, "You must be real fun at parties....");
        this.inFlip.remove(player);
    }

    @SubscribeEvent
    public void onMessage(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        String message = event.getRawText();
        if (!message.equalsIgnoreCase("Heads") && !message.equalsIgnoreCase("Tails")) {
            return;
        }
        if (this.inFlip.containsKey(player)) {
            int flip = RewardsUtil.rand.nextInt(6000);
            if (flip == 1738) {
                RewardsUtil.sendMessageToPlayer((Player)player, "The coin landed on it's side.....");
                RewardsUtil.sendMessageToPlayer((Player)player, "Well this is awkward");
            } else if (flip < 3000) {
                if (message.equalsIgnoreCase("Heads")) {
                    RewardsUtil.sendMessageToPlayer((Player)player, "It was heads! You're correct!");
                    player.level().addFreshEntity((Entity)new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)RewardsUtil.getRandomItem(), 1)));
                } else {
                    RewardsUtil.sendMessageToPlayer((Player)player, "It was heads! You're incorrect!");
                    for (int i = 0; i < 5; ++i) {
                        player.level().addFreshEntity((Entity)new PrimedTnt(player.level(), player.getX(), player.getY() + 1.0, player.getZ(), (LivingEntity)player));
                        player.level().playSound((Player)player, player.getX(), player.getY(), player.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            } else if (message.equalsIgnoreCase("Tails")) {
                RewardsUtil.sendMessageToPlayer((Player)player, "It was tails! You're correct!");
                player.level().addFreshEntity((Entity)new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)RewardsUtil.getRandomItem(), 1)));
            } else {
                RewardsUtil.sendMessageToPlayer((Player)player, "It was tails! You're incorrect!");
                for (int i = 0; i < 5; ++i) {
                    player.level().addFreshEntity((Entity)new PrimedTnt(player.level(), player.getX(), player.getY() + 1.0, player.getZ(), (LivingEntity)player));
                    player.level().playSound((Player)player, player.getX(), player.getY(), player.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            Scheduler.removeTask(this.inFlip.remove(player));
            event.setCanceled(true);
        }
    }
}

