/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.rewards.biodomeGen.BioDomeGen;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.GuiTextLocation;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;

public abstract class BossBaseReward
extends BaseCustomReward {
    private final String bossName;

    public BossBaseReward(String bossName) {
        super("chancecubes:boss_" + bossName, -35);
        this.bossName = bossName.replace("_", " ");
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, final Player player, final JsonObject settings) {
        final BattleWrapper battleWrapper = new BattleWrapper();
        battleWrapper.rewardCenterPos = pos;
        battleWrapper.domeGen = new BioDomeGen(player);
        battleWrapper.domeGen.genRandomDome(pos.offset(0, -1, 0), level, 15, false);
        MutableComponent message = ComponentWrapper.string("BOSS FIGHT!");
        message.setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED)));
        RewardsUtil.setNearPlayersTitle((Level)level, pos, 50, GuiTextLocation.TITLE, (Component)message, 10, 500, 0);
        Scheduler.scheduleTask(new Task("boss_fight_subtitle_1", 120){

            @Override
            public void callback() {
                MutableComponent message = ComponentWrapper.string(player.getScoreboardName() + " VS " + " ".repeat(BossBaseReward.this.bossName.length()));
                message.setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED)));
                RewardsUtil.setNearPlayersTitle((Level)level, pos, 50, GuiTextLocation.SUBTITLE, (Component)message, 0, 500, 0);
            }
        });
        Scheduler.scheduleTask(new Task("boss_fight_subtitle_2", 160){

            @Override
            public void callback() {
                MutableComponent message = ComponentWrapper.string(player.getScoreboardName() + " VS " + BossBaseReward.this.bossName);
                message.setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED)));
                RewardsUtil.setNearPlayersTitle((Level)level, pos, 50, GuiTextLocation.SUBTITLE, (Component)message, 0, 100, 10);
            }
        });
        Scheduler.scheduleTask(new Task("boss_fight_start", 200){

            @Override
            public void callback() {
                BossBaseReward.this.startBossFight(level, pos, player, settings, battleWrapper);
            }
        });
    }

    public void startBossFight(final ServerLevel level, final BlockPos pos, final Player player, JsonObject settings, final BattleWrapper battleWrapper) {
        LivingEntity ent = this.initBoss(level, pos, player, settings, battleWrapper);
        ent.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        ent.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.getBossHealthDynamic(player, settings));
        ent.setHealth(ent.getMaxHealth());
        level.addFreshEntity((Entity)ent);
        this.trackEntities(battleWrapper, new Entity[]{ent});
        this.trackPlayers(battleWrapper, player);
        Scheduler.scheduleTask(new Task("boss_fight_tracker", -1, 5){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                Entity ent;
                int i;
                for (i = battleWrapper.trackedEntities.size() - 1; i >= 0; --i) {
                    ent = battleWrapper.trackedEntities.get(i);
                    if (ent.isAlive() || ent.tickCount <= 0 && !level.getDifficulty().equals((Object)Difficulty.PEACEFUL)) continue;
                    battleWrapper.trackedEntities.remove(i);
                    if (!battleWrapper.trackedEntities.isEmpty()) continue;
                    BossBaseReward.this.endBossfight(true, level, pos, player, battleWrapper);
                    Scheduler.removeTask(this);
                }
                for (i = battleWrapper.trackedPlayers.size() - 1; i >= 0; --i) {
                    ent = (Entity)battleWrapper.trackedPlayers.get(i);
                    if (ent.getOnPos().distToCenterSqr((double)battleWrapper.rewardCenterPos.getX(), (double)battleWrapper.rewardCenterPos.getY(), (double)battleWrapper.rewardCenterPos.getZ()) > 225.0 || ent.getY() < (double)(battleWrapper.rewardCenterPos.getY() - 1)) {
                        ent.moveTo((double)battleWrapper.rewardCenterPos.getX(), (double)(battleWrapper.rewardCenterPos.getY() + 1), (double)battleWrapper.rewardCenterPos.getZ());
                    }
                    if (ent.isAlive() || ent.tickCount <= 0 && !level.getDifficulty().equals((Object)Difficulty.PEACEFUL)) continue;
                    for (Entity entity : battleWrapper.trackedEntities) {
                        entity.remove(Entity.RemovalReason.DISCARDED);
                    }
                    battleWrapper.trackedEntities.clear();
                    BossBaseReward.this.endBossfight(false, level, pos, player, battleWrapper);
                    Scheduler.removeTask(this);
                    return;
                }
            }
        });
    }

    public void endBossfight(boolean resetPlayer, ServerLevel level, BlockPos pos, Player player, BattleWrapper battleWrapper) {
        for (Entity ent : battleWrapper.trackedSubEntities) {
            if (!ent.isAlive()) continue;
            ent.remove(Entity.RemovalReason.DISCARDED);
        }
        battleWrapper.trackedSubEntities.clear();
        this.onBossFightEnd(level, pos, player);
        battleWrapper.domeGen.removeDome(resetPlayer);
    }

    protected void trackEntities(BattleWrapper battleWrapper, Entity ... ents) {
        battleWrapper.trackedEntities.addAll(Arrays.asList(ents));
    }

    protected void trackSubEntities(BattleWrapper battleWrapper, Entity ... ents) {
        battleWrapper.trackedSubEntities.addAll(Arrays.asList(ents));
    }

    protected void trackPlayers(BattleWrapper battleWrapper, Player ... player) {
        battleWrapper.trackedPlayers.addAll(Arrays.asList(player));
    }

    public abstract LivingEntity initBoss(ServerLevel var1, BlockPos var2, Player var3, JsonObject var4, BattleWrapper var5);

    public abstract void onBossFightEnd(ServerLevel var1, BlockPos var2, Player var3);

    public double getBossHealthDynamic(Player player, JsonObject settings) {
        double maxDamage = 3.0;
        for (ItemStack stack : player.getInventory().items) {
            ItemAttributeModifiers attributeModifiers = stack.getAttributeModifiers();
            for (ItemAttributeModifiers.Entry entry : attributeModifiers.modifiers()) {
                AttributeModifier modifier;
                if (entry.attribute() != Attributes.ATTACK_DAMAGE || !(maxDamage < (modifier = entry.modifier()).amount())) continue;
                maxDamage = Math.max(maxDamage, modifier.amount());
            }
        }
        double prePofileHealth = maxDamage * 15.0;
        double profileMult = super.getSettingAsDouble(settings, "bossHealthMultiplier", 1.0, 0.0, 10.0);
        return prePofileHealth * profileMult;
    }

    public ItemStack getHighestDamageItem(Player player) {
        double maxDamage = -1.0;
        ItemStack maxItem = ItemStack.EMPTY;
        for (ItemStack stack : player.getInventory().items) {
            ItemAttributeModifiers attributeModifiers = stack.getAttributeModifiers();
            for (ItemAttributeModifiers.Entry entry : attributeModifiers.modifiers()) {
                AttributeModifier modifier;
                if (entry.attribute() != Attributes.ATTACK_DAMAGE || !(maxDamage < (modifier = entry.modifier()).amount())) continue;
                maxDamage = modifier.amount();
                maxItem = stack;
            }
        }
        return maxItem;
    }

    protected static class BattleWrapper {
        public final List<Entity> trackedEntities = new ArrayList<Entity>();
        public final List<Entity> trackedSubEntities = new ArrayList<Entity>();
        public final List<Player> trackedPlayers = new ArrayList<Player>();
        public BlockPos rewardCenterPos;
        public BioDomeGen domeGen;

        protected BattleWrapper() {
        }
    }
}

