/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.mcwrapper.BlockWrapper;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.mcwrapper.EntityWrapper;
import chanceCubes.parsers.RewardParser;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.rewards.defaultRewards.AnvilRain;
import chanceCubes.rewards.defaultRewards.ArmorStandArmorReward;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.defaultRewards.BookOfMemesReward;
import chanceCubes.rewards.defaultRewards.BossBlazeReward;
import chanceCubes.rewards.defaultRewards.BossMimicReward;
import chanceCubes.rewards.defaultRewards.BossRavagerReward;
import chanceCubes.rewards.defaultRewards.BossWitchReward;
import chanceCubes.rewards.defaultRewards.CakeIsALieReward;
import chanceCubes.rewards.defaultRewards.ChanceCubeRenameReward;
import chanceCubes.rewards.defaultRewards.ClearInventoryReward;
import chanceCubes.rewards.defaultRewards.CoinFlipReward;
import chanceCubes.rewards.defaultRewards.Connect4Reward;
import chanceCubes.rewards.defaultRewards.CountDownReward;
import chanceCubes.rewards.defaultRewards.CreeperSurroundedReward;
import chanceCubes.rewards.defaultRewards.CursedHeadReward;
import chanceCubes.rewards.defaultRewards.DidYouKnowReward;
import chanceCubes.rewards.defaultRewards.DigBuildReward;
import chanceCubes.rewards.defaultRewards.DoubleRainbow;
import chanceCubes.rewards.defaultRewards.HerobrineReward;
import chanceCubes.rewards.defaultRewards.ItemChestReward;
import chanceCubes.rewards.defaultRewards.ItemOfDestinyReward;
import chanceCubes.rewards.defaultRewards.ItemRenamer;
import chanceCubes.rewards.defaultRewards.JarGuessReward;
import chanceCubes.rewards.defaultRewards.JukeBoxReward;
import chanceCubes.rewards.defaultRewards.LootBoxReward;
import chanceCubes.rewards.defaultRewards.MagicFeetReward;
import chanceCubes.rewards.defaultRewards.MatchingReward;
import chanceCubes.rewards.defaultRewards.MathReward;
import chanceCubes.rewards.defaultRewards.MazeReward;
import chanceCubes.rewards.defaultRewards.MobTowerReward;
import chanceCubes.rewards.defaultRewards.MontyHallReward;
import chanceCubes.rewards.defaultRewards.OneIsLuckyReward;
import chanceCubes.rewards.defaultRewards.QuestionsReward;
import chanceCubes.rewards.defaultRewards.RainingCatsAndCogsReward;
import chanceCubes.rewards.defaultRewards.SkyblockReward;
import chanceCubes.rewards.defaultRewards.SurroundedReward;
import chanceCubes.rewards.defaultRewards.TableFlipReward;
import chanceCubes.rewards.defaultRewards.TicTacToeReward;
import chanceCubes.rewards.defaultRewards.TrollTNTReward;
import chanceCubes.rewards.defaultRewards.WaitForItReward;
import chanceCubes.rewards.defaultRewards.WheelSpinReward;
import chanceCubes.rewards.defaultRewards.WitherReward;
import chanceCubes.rewards.defaultRewards.WolvesToCreepersReward;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.OffsetTileEntity;
import chanceCubes.rewards.rewardparts.SchematicPart;
import chanceCubes.rewards.rewardparts.SoundPart;
import chanceCubes.rewards.rewardtype.BlockRewardType;
import chanceCubes.rewards.rewardtype.CommandRewardType;
import chanceCubes.rewards.rewardtype.EntityRewardType;
import chanceCubes.rewards.rewardtype.ItemRewardType;
import chanceCubes.rewards.rewardtype.MessageRewardType;
import chanceCubes.rewards.rewardtype.SchematicRewardType;
import chanceCubes.rewards.rewardtype.SoundRewardType;
import chanceCubes.rewards.variableTypes.BoolVar;
import chanceCubes.rewards.variableTypes.FloatVar;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.NeoForge;

public class DefaultRewards {
    public static void loadDefaultRewards(HolderLookup.Provider provider) {
        RewardsUtil.initData();
        if (!((Boolean)CCubesSettings.enableHardCodedRewards.get()).booleanValue()) {
            return;
        }
        for (String fileName : RewardsUtil.getHardcodedRewards()) {
            JsonObject json = RewardsUtil.getRewardJson(fileName);
            for (Map.Entry reward : json.entrySet()) {
                boolean defaultEnable;
                CustomEntry<BasicReward, Boolean> parsedReward = RewardParser.parseReward(reward, provider);
                BasicReward basicReward = parsedReward.getKey();
                if (basicReward == null) {
                    CCubesCore.logger.error("A hard coded reward failed to parse! Please report this to the mod dev! " + (String)reward.getKey() + " for the file " + fileName);
                    continue;
                }
                boolean bl = defaultEnable = !basicReward.getName().equalsIgnoreCase("chancecubes:giant_chance_cube");
                if (parsedReward.getValue().booleanValue()) {
                    GlobalCCRewardRegistry.GIANT.registerReward(basicReward);
                    continue;
                }
                GlobalCCRewardRegistry.DEFAULT.registerReward(basicReward, defaultEnable);
            }
        }
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:lava_ring", -40, new BlockRewardType(new OffsetBlock(1, -1, 0, Blocks.LAVA, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, 1, Blocks.LAVA, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, 1, Blocks.LAVA, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 1, Blocks.LAVA, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 0, Blocks.LAVA, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, -1, Blocks.LAVA, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, -1, Blocks.LAVA, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, -1, Blocks.LAVA, false).setRelativeToPlayer(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:rain", -5, new CommandRewardType("/weather thunder 20000")));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:silverfish_surround", -20, new BlockRewardType(new OffsetBlock(1, 0, 0, Blocks.INFESTED_COBBLESTONE, false).setRelativeToPlayer(true), new OffsetBlock(1, 1, 0, Blocks.INFESTED_COBBLESTONE, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, 1, Blocks.INFESTED_COBBLESTONE, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, 1, Blocks.INFESTED_COBBLESTONE, false).setRelativeToPlayer(true), new OffsetBlock(-1, 0, 0, Blocks.INFESTED_COBBLESTONE, false).setRelativeToPlayer(true), new OffsetBlock(-1, 1, 0, Blocks.INFESTED_COBBLESTONE, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, -1, Blocks.INFESTED_COBBLESTONE, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, -1, Blocks.INFESTED_COBBLESTONE, false).setRelativeToPlayer(true), new OffsetBlock(0, 2, 0, Blocks.INFESTED_COBBLESTONE, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, 0, Blocks.INFESTED_COBBLESTONE, false).setRelativeToPlayer(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:fish_dog", 20, new ItemRewardType(new ItemPart(new ItemStack((ItemLike)Items.COD, 5), provider), new ItemPart(new ItemStack((ItemLike)Items.WOLF_SPAWN_EGG), provider))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:bone_cat", 20, new ItemRewardType(new ItemPart(new ItemStack((ItemLike)Items.BONE, 5), provider), new ItemPart(new ItemStack((ItemLike)Items.OCELOT_SPAWN_EGG), provider))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:tnt_cat", -25, new CommandRewardType("/summon ocelot ~ ~1 ~ {CatType:0,Sitting:0,Passengers:[{id:\"tnt\",Fuse:80}]}")));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:diamond_block", 85, new BlockRewardType(new OffsetBlock(0, 0, 0, Blocks.DIAMOND_BLOCK, true, 200))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:tnt_diamond", -35, new BlockRewardType(new OffsetBlock(0, 1, 0, Blocks.DIAMOND_BLOCK, false), new OffsetBlock(0, -1, 0, Blocks.DIAMOND_BLOCK, false), new OffsetBlock(1, 0, 0, Blocks.DIAMOND_BLOCK, false), new OffsetBlock(-1, 0, 0, Blocks.DIAMOND_BLOCK, false), new OffsetBlock(0, 0, 1, Blocks.DIAMOND_BLOCK, false), new OffsetBlock(0, 0, -1, Blocks.DIAMOND_BLOCK, false)), new CommandRewardType(RewardsUtil.executeXCommands("/summon tnt %x %y %z {Fuse:40}", 3, 5))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:fake_tnt", 0, new SoundRewardType(new SoundPart(SoundEvents.TNT_PRIMED), new SoundPart(SoundEvents.TNT_PRIMED), new SoundPart(SoundEvents.TNT_PRIMED), new SoundPart((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 120).setAtPlayersLocation(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:invisible_ghasts", 0, new SoundRewardType(new SoundPart(SoundEvents.GHAST_SCREAM).setServerWide(true), new SoundPart(SoundEvents.GHAST_WARN).setServerWide(true), new SoundPart(SoundEvents.GHAST_WARN).setServerWide(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:no", 0, new BlockRewardType(new OffsetBlock(0, 0, 0, (Block)CCubesBlocks.CHANCE_CUBE.get(), false)), new MessageRewardType("No")));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:coal_to_diamonds", 10, new BlockRewardType(new OffsetBlock(0, 1, 0, Blocks.COAL_BLOCK, false), new OffsetBlock(0, -1, 0, Blocks.COAL_BLOCK, false), new OffsetBlock(1, 0, 0, Blocks.COAL_BLOCK, false), new OffsetBlock(-1, 0, 0, Blocks.COAL_BLOCK, false), new OffsetBlock(0, 0, 1, Blocks.COAL_BLOCK, false), new OffsetBlock(0, 0, -1, Blocks.COAL_BLOCK, false)), new CommandRewardType(RewardsUtil.executeXCommands("/summon tnt %x %y %z {Fuse:40}", 3, 5)), new ItemRewardType(new ItemPart(new ItemStack((ItemLike)Items.DIAMOND, 5), 50, provider))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:one_man_army", -10, new EntityRewardType("zombified_piglin"), new CommandRewardType(RewardsUtil.executeXCommands("/summon zombified_piglin ~ ~ ~ {Silent:1,ActiveEffects:[{Id:14,Amplifier:0,Duration:19980,ShowParticles:1b}]}", 9)), new MessageRewardType(new MessagePart("One man army").setRange(32))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:arrow_trap", -25, new SchematicRewardType(new SchematicPart("/data/chancecubes/schematics/arrow_trap.ccs", true, new IntVar(1), new IntVar(-1), new IntVar(1), new FloatVar(0.0f), new BoolVar(false), new BoolVar(true), new BoolVar(true), new BoolVar(true), new IntVar(0)))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:trampoline", 15, new MessageRewardType("Time to bounce!"), new SchematicRewardType(new SchematicPart("/data/chancecubes/schematics/trampoline.ccs", true, new IntVar(1), new IntVar(-3), new IntVar(1), new FloatVar(0.0f), new BoolVar(false), new BoolVar(true), new BoolVar(true), new BoolVar(true), new IntVar(0))), new BlockRewardType(new OffsetBlock(2, -2, -2, Blocks.REDSTONE_BLOCK, false, 3).setRelativeToPlayer(true).setCausesBlockUpdate(true), new OffsetBlock(2, -2, -2, Blocks.REDSTONE_WIRE, false, 5).setRelativeToPlayer(true).setCausesBlockUpdate(true))));
        SignBlockEntity sign = BlockWrapper.createSign(new BlockPos(0, 0, 0), new String[]{"The broken path", "to succeed"});
        CompoundTag nbt = sign.saveWithFullMetadata(provider);
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:path_to_succeed", 0, new BlockRewardType(new OffsetBlock[]{new OffsetTileEntity(0, 0, -5, Blocks.OAK_SIGN, nbt, true, 20), new OffsetBlock(0, -1, 0, Blocks.COBBLESTONE, true, 0), new OffsetBlock(0, -1, -1, Blocks.COBBLESTONE, true, 4), new OffsetBlock(0, -1, -2, Blocks.COBBLESTONE, true, 8), new OffsetBlock(0, -1, -3, Blocks.COBBLESTONE, true, 12), new OffsetBlock(0, -1, -4, Blocks.COBBLESTONE, true, 16), new OffsetBlock(0, -1, -5, Blocks.COBBLESTONE, true, 20)})));
        OffsetBlock[] blocks = new OffsetBlock[35];
        int i = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    if (y == 1 && (x == 0 || x == 4 || z == 0 || z == 4)) continue;
                    blocks[i] = new OffsetBlock(x - 2, y, z - 2, Blocks.IRON_BLOCK, true, i * 5);
                    ++i;
                }
            }
        }
        blocks[i] = new OffsetBlock(0, 2, 0, Blocks.BEACON, true, 200);
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:beacon_build", 100, new BlockRewardType(blocks)));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:half_heart", -30){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                player.setHealth(1.0f);
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:no_exp", -40){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                player.experienceLevel = 0;
                player.totalExperience = 0;
                player.experienceProgress = 0.0f;
                RewardsUtil.sendMessageToPlayer(player, "Rip EXP");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:smite", -10){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                EntityWrapper.spawnLightning((Level)level, player.getOnPos());
                RewardsUtil.sendMessageToPlayer(player, "Thou has been smitten!");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:cookie-splosion", 35){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (double xx = 1.0; xx > -1.0; xx -= 0.25) {
                    for (double zz = 1.0; zz > -1.0; zz -= 0.25) {
                        ItemEntity cookie = new ItemEntity((Level)level, (double)pos.getX(), (double)pos.getY() + 1.0, (double)pos.getZ(), new ItemStack((ItemLike)Items.COOKIE));
                        level.addFreshEntity((Entity)cookie);
                        cookie.setDeltaMovement(xx, Math.random(), zz);
                    }
                }
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:random_status_effect", 0){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
                RewardsUtil.sendMessageToPlayer(player, "Selecting random potion effect to apply...");
                Scheduler.scheduleTask(new Task(this, "Cookie Monster", 30){

                    @Override
                    public void callback() {
                        MobEffectInstance effect = RewardsUtil.getRandomPotionEffectInstance();
                        RewardsUtil.sendMessageToPlayer(player, "You have been given: ");
                        RewardsUtil.sendMessageToPlayer(player, (Component)ComponentWrapper.translatable(effect.getDescriptionId(), new Object[0]));
                        RewardsUtil.sendMessageToPlayer(player, "for " + effect.getDuration() / 20 + " seconds!");
                        player.addEffect(effect);
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:arrow_spray", -15){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (double xx = 1.0; xx > -1.0; xx -= 0.25) {
                    for (double zz = 1.0; zz > -1.0; zz -= 0.25) {
                        Arrow arrow = new Arrow((Level)level, (LivingEntity)player, new ItemStack((ItemLike)Items.ARROW), null);
                        arrow.moveTo((double)pos.getX(), (double)((float)pos.getY() + 0.5f), (double)pos.getZ(), 0.0f, 0.0f);
                        arrow.setDeltaMovement(xx, 0.3, zz);
                        level.addFreshEntity((Entity)arrow);
                    }
                }
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:lingering_potions_ring", -10){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (double rad = -Math.PI; rad <= Math.PI; rad += 0.3141592653589793) {
                    ThrownPotion pot = new ThrownPotion((Level)level, (LivingEntity)player);
                    ItemStack stack = new ItemStack((ItemLike)Items.LINGERING_POTION);
                    stack.set(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY.withEffectAdded(RewardsUtil.getRandomPotionEffectInstance()));
                    pot.setItem(stack);
                    pot.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                    pot.setDeltaMovement(Math.cos(rad) * 0.25, 1.0, Math.sin(rad) * 0.25);
                    level.addFreshEntity((Entity)pot);
                }
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:charged_creeper", -40){

            @Override
            public void trigger(final ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                if (level.isClientSide()) {
                    return;
                }
                RewardsUtil.placeBlock(Blocks.AIR.defaultBlockState(), (Level)level, pos.offset(0, 1, 0));
                final Creeper ent = (Creeper)EntityType.CREEPER.create((Level)level);
                ent.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                ent.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300, 99, true, false));
                ent.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 300, 99, true, false));
                level.addFreshEntity((Entity)ent);
                Scheduler.scheduleTask(new Task(this, "Charged Creeper Reward", 2){

                    @Override
                    public void callback() {
                        EntityWrapper.spawnLightning((Level)level, ent.getOnPos());
                        ent.clearFire();
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:disco", 40){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (int xx = -4; xx < 5; ++xx) {
                    for (int zz = -4; zz < 5; ++zz) {
                        RewardsUtil.placeBlock(RewardsUtil.getRandomWool(), (Level)level, pos.offset(xx, -1, zz));
                    }
                }
                for (int i = 0; i < 10; ++i) {
                    EntityWrapper.spawnNamedEntityAt(EntityType.SHEEP, (Level)level, "jeb_", pos.getX(), pos.getY() + 1, pos.getZ());
                }
                RewardsUtil.placeBlock(((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_ICOSAHEDRON.get())).defaultBlockState(), (Level)level, pos.offset(0, 3, 0));
                RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 32, "Disco Party!!!!");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:ender_crystal_timer", -90){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (int i = 30; i > 0; --i) {
                    RewardsUtil.placeBlock(Blocks.AIR.defaultBlockState(), (Level)level, pos.offset(0, i, 0));
                }
                EntityWrapper.spawnEntityAt(EntityType.END_CRYSTAL, (Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                Arrow arrow = new Arrow((Level)level, (double)pos.getX() + 0.5, (double)(pos.getY() + 29), (double)pos.getZ() + 0.5, new ItemStack((ItemLike)Items.ARROW), null);
                arrow.setDeltaMovement(0.0, -0.25, 0.0);
                level.addFreshEntity((Entity)arrow);
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:5_prongs", -10){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (int xx = pos.getX() - 3; xx <= pos.getX() + 3; ++xx) {
                    for (int zz = pos.getZ() - 3; zz <= pos.getZ() + 3; ++zz) {
                        for (int yy = pos.getY(); yy <= pos.getY() + 4; ++yy) {
                            RewardsUtil.placeBlock(Blocks.AIR.defaultBlockState(), (Level)level, new BlockPos(xx, yy, zz));
                        }
                    }
                }
                RewardsUtil.placeBlock(Blocks.QUARTZ_BLOCK.defaultBlockState(), (Level)level, pos);
                RewardsUtil.placeBlock(Blocks.QUARTZ_BLOCK.defaultBlockState(), (Level)level, pos.offset(0, 1, 0));
                RewardsUtil.placeBlock(((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_ICOSAHEDRON.get())).defaultBlockState(), (Level)level, pos.offset(0, 2, 0));
                RewardsUtil.placeBlock(Blocks.QUARTZ_BLOCK.defaultBlockState(), (Level)level, pos.offset(-3, 0, -3));
                RewardsUtil.placeBlock(((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_CUBE.get())).defaultBlockState(), (Level)level, pos.offset(-3, 1, -3));
                RewardsUtil.placeBlock(Blocks.QUARTZ_BLOCK.defaultBlockState(), (Level)level, pos.offset(-3, 0, 3));
                RewardsUtil.placeBlock(((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_CUBE.get())).defaultBlockState(), (Level)level, pos.offset(-3, 1, 3));
                RewardsUtil.placeBlock(Blocks.QUARTZ_BLOCK.defaultBlockState(), (Level)level, pos.offset(3, 0, -3));
                RewardsUtil.placeBlock(((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_CUBE.get())).defaultBlockState(), (Level)level, pos.offset(3, 1, -3));
                RewardsUtil.placeBlock(Blocks.QUARTZ_BLOCK.defaultBlockState(), (Level)level, pos.offset(3, 0, 3));
                RewardsUtil.placeBlock(((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_CUBE.get())).defaultBlockState(), (Level)level, pos.offset(3, 1, 3));
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:inventory_bomb", -55){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                player.getInventory().dropAll();
                player.getInventory().items.replaceAll(ignored -> new ItemStack((ItemLike)Blocks.DEAD_BUSH, 64));
                for (int i = 0; i < player.getInventory().armor.size(); ++i) {
                    ItemStack stack = new ItemStack((ItemLike)Blocks.DEAD_BUSH, 64);
                    if (i == 0) {
                        stack.set(DataComponents.CUSTOM_NAME, (Object)ComponentWrapper.string("Button").setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.DARK_PURPLE))));
                        stack.setCount(13);
                    } else if (i == 1) {
                        stack.set(DataComponents.CUSTOM_NAME, (Object)ComponentWrapper.string("TheBlackswordsman"));
                        stack.setCount(13);
                    }
                    player.getInventory().armor.set(i, (Object)stack);
                }
                RewardsUtil.sendMessageToPlayer(player, "Inventory Bomb!!!!");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:nuke", -75){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 32, "May death rain upon them");
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() - 6), (double)(pos.getY() + 65), (double)(pos.getZ() - 6), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() - 2), (double)(pos.getY() + 65), (double)(pos.getZ() - 6), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() + 2), (double)(pos.getY() + 65), (double)(pos.getZ() - 6), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() + 6), (double)(pos.getY() + 65), (double)(pos.getZ() - 6), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() - 6), (double)(pos.getY() + 65), (double)(pos.getZ() - 2), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() - 2), (double)(pos.getY() + 65), (double)(pos.getZ() - 2), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() + 2), (double)(pos.getY() + 65), (double)(pos.getZ() - 2), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() + 6), (double)(pos.getY() + 65), (double)(pos.getZ() - 2), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() - 6), (double)(pos.getY() + 65), (double)(pos.getZ() + 2), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() - 2), (double)(pos.getY() + 65), (double)(pos.getZ() + 2), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() + 2), (double)(pos.getY() + 65), (double)(pos.getZ() + 2), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() + 6), (double)(pos.getY() + 65), (double)(pos.getZ() + 2), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() - 6), (double)(pos.getY() + 65), (double)(pos.getZ() + 6), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() - 2), (double)(pos.getY() + 65), (double)(pos.getZ() + 6), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() + 2), (double)(pos.getY() + 65), (double)(pos.getZ() + 6), (LivingEntity)player));
                level.addFreshEntity((Entity)new PrimedTnt((Level)level, (double)(pos.getX() + 6), (double)(pos.getY() + 65), (double)(pos.getZ() + 6), (LivingEntity)player));
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:random_teleport", -15){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                int xChange = level.random.nextInt(50) + 20 + pos.getX() - 35;
                int zChange = level.random.nextInt(50) + 20 + pos.getZ() - 35;
                int yChange = -1;
                for (int yy = 0; yy <= level.getHeight(); ++yy) {
                    if (!level.getBlockState(new BlockPos(xChange, yy, zChange)).isAir() || !level.getBlockState(new BlockPos(xChange, yy + 1, zChange)).isAir()) continue;
                    yChange = yy;
                    break;
                }
                if (yChange == -1) {
                    return;
                }
                player.moveTo((double)xChange, (double)yChange, (double)zChange);
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:rotten_food", -30){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (int i = 0; i < player.getInventory().items.size(); ++i) {
                    ItemStack stack = (ItemStack)player.getInventory().items.get(i);
                    if (stack.isEmpty() || !stack.has(DataComponents.FOOD)) continue;
                    player.getInventory().items.set(i, (Object)new ItemStack((ItemLike)Items.ROTTEN_FLESH, stack.getCount()));
                }
                RewardsUtil.sendMessageToPlayer(player, "Ewwww it's all rotten");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:thrown_in_air", -35){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
                int px = (int)Math.floor(player.getX());
                int py = (int)Math.floor(player.getY()) + 1;
                int pz = (int)Math.floor(player.getZ());
                for (int y = 0; y < 40; ++y) {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            RewardsUtil.placeBlock(Blocks.AIR.defaultBlockState(), (Level)level, pos.offset(px + x, py + y, pz + z));
                        }
                    }
                }
                Scheduler.scheduleTask(new Task(this, "Thrown_In_Air_Reward", 5){

                    @Override
                    public void callback() {
                        player.setJumping(true);
                        player.setOnGround(false);
                        player.setDeltaMovement(0.0, 20.0, 0.0);
                        ((ServerPlayer)player).connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:torches_to_creepers", -40){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                int xRadius = super.getSettingAsInt(settings, "xRadius", 64, 0, 100) / 2;
                int yRadius = super.getSettingAsInt(settings, "yRadius", 64, 0, 100) / 2;
                int zRadius = super.getSettingAsInt(settings, "zRadius", 64, 0, 100) / 2;
                int maxCreepers = super.getSettingAsInt(settings, "maxCreepers", 50, -1, Integer.MAX_VALUE) / 2;
                int spawned = 0;
                for (int yy = -yRadius; yy <= yRadius; ++yy) {
                    for (int xx = -xRadius; xx <= xRadius; ++xx) {
                        for (int zz = -zRadius; zz <= zRadius; ++zz) {
                            BlockState b = level.getBlockState(pos.offset(xx, yy, zz));
                            if (b.getLightEmission((BlockGetter)level, pos) <= 0 || b.getBlock() == Blocks.LAVA || b.hasBlockEntity()) continue;
                            RewardsUtil.placeBlock(Blocks.AIR.defaultBlockState(), (Level)level, pos.offset(xx, yy, zz));
                            EntityWrapper.spawnEntityAt(EntityType.CREEPER, (Level)level, (double)(pos.getX() + xx) + 0.5, pos.getY() + yy, (double)(pos.getZ() + zz) + 0.5);
                            if (++spawned < maxCreepers || maxCreepers == -1) continue;
                            return;
                        }
                    }
                }
                RewardsUtil.sendMessageToPlayer(player, "Those lights seem a little weird.... O.o");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:traveller", 15){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                int x = RewardsUtil.rand.nextInt(1000) + 200;
                int z = RewardsUtil.rand.nextInt(1000) + 200;
                BlockPos newPos = pos.offset(x, 0, z);
                RewardsUtil.placeBlock((BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.WEST), (Level)level, newPos);
                ChestBlockEntity chest = (ChestBlockEntity)level.getBlockEntity(newPos);
                for (int i = 0; i < 10; ++i) {
                    chest.setItem(i, new ItemStack((ItemLike)RewardsUtil.getRandomItem()));
                }
                RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 25, newPos.getX() + ", " + newPos.getY() + ", " + newPos.getZ());
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:troll_hole", -20){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
                BlockPos worldPos = BlockPos.containing((double)Math.floor(player.getX()), (double)(Math.floor(player.getY()) - 1.0), (double)Math.floor(player.getZ()));
                final RewardBlockCache cache = new RewardBlockCache((Level)level, worldPos, BlockPos.containing((double)worldPos.getX(), (double)(worldPos.getY() + 1), (double)worldPos.getZ()));
                for (int y = 0; y > -75; --y) {
                    for (int x = -2; x < 3; ++x) {
                        for (int z = -2; z < 3; ++z) {
                            cache.cacheBlock(BlockPos.containing((double)x, (double)y, (double)z), Blocks.AIR.defaultBlockState());
                        }
                    }
                }
                Scheduler.scheduleTask(new Task(this, "TrollHole", 35){

                    @Override
                    public void callback() {
                        cache.restoreBlocks((Entity)player);
                        player.fallDistance = 0.0f;
                        player.setDeltaMovement(0.0, 0.0, 0.0);
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:saw_nothing_diamond", 0){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
                final ItemEntity itemEnt = new ItemEntity((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)Items.DIAMOND, 1));
                itemEnt.setNeverPickUp();
                level.addFreshEntity((Entity)itemEnt);
                Scheduler.scheduleTask(new Task(this, "Saw_Nothing_Diamond", 100){

                    @Override
                    public void callback() {
                        itemEnt.remove(Entity.RemovalReason.DISCARDED);
                        RewardsUtil.sendMessageToPlayer(player, "You didn't see anything......");
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:hand_enchant", 20){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                ItemStack toEnchant;
                if (!player.getMainHandItem().isEmpty()) {
                    toEnchant = player.getMainHandItem();
                } else {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (ItemStack stack : player.getInventory().items) {
                        if (stack.isEmpty()) continue;
                        stacks.add(stack);
                    }
                    for (ItemStack stack : player.getInventory().armor) {
                        if (stack.isEmpty()) continue;
                        stacks.add(stack);
                    }
                    if (stacks.size() == 0) {
                        ItemStack dirt = new ItemStack((ItemLike)Blocks.DIRT);
                        dirt.set(DataComponents.CUSTOM_NAME, (Object)ComponentWrapper.string("A lonley piece of dirt"));
                        player.getInventory().add(dirt);
                        RewardsUtil.executeCommand(level, player, (Vec3i)player.getOnPos(), "/advancement grant @p only chancecubes:lonely_dirt");
                        return;
                    }
                    toEnchant = (ItemStack)stacks.get(RewardsUtil.rand.nextInt(stacks.size()));
                }
                CustomEntry<Holder<Enchantment>, Integer> enchantment = RewardsUtil.getRandomEnchantmentAndLevel((HolderLookup.Provider)level.registryAccess());
                toEnchant.enchant(enchantment.getKey(), enchantment.getValue().intValue());
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new AnvilRain());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new HerobrineReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new SurroundedReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CreeperSurroundedReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new WitherReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new TrollTNTReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new WaitForItReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ClearInventoryReward(), false);
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ItemOfDestinyReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new JukeBoxReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BookOfMemesReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new TableFlipReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MazeReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new OneIsLuckyReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new SkyblockReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CakeIsALieReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ItemRenamer());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new DoubleRainbow());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new WolvesToCreepersReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new DidYouKnowReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ArmorStandArmorReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new RainingCatsAndCogsReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ItemChestReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MagicFeetReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new DigBuildReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ChanceCubeRenameReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CountDownReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MobTowerReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MontyHallReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MatchingReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new TicTacToeReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossMimicReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossWitchReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossBlazeReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossRavagerReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CursedHeadReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new WheelSpinReward(provider));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new Connect4Reward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new LootBoxReward());
        MathReward math = new MathReward();
        NeoForge.EVENT_BUS.register((Object)math);
        GlobalCCRewardRegistry.DEFAULT.registerReward(math);
        QuestionsReward question = new QuestionsReward();
        NeoForge.EVENT_BUS.register((Object)question);
        GlobalCCRewardRegistry.DEFAULT.registerReward(question);
        CoinFlipReward coinFlip = new CoinFlipReward();
        NeoForge.EVENT_BUS.register((Object)coinFlip);
        GlobalCCRewardRegistry.DEFAULT.registerReward(coinFlip);
        JarGuessReward jarGuess = new JarGuessReward();
        NeoForge.EVENT_BUS.register((Object)jarGuess);
        GlobalCCRewardRegistry.DEFAULT.registerReward(jarGuess);
    }
}

