/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.renderer;

import chanceCubes.tileentities.TileChanceD20;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TileChanceD20Renderer
implements BlockEntityRenderer<TileChanceD20> {
    private static final Random random = new Random();
    private static final float HOVER_SPEED = 6000.0f;
    private static final float ROTATION_SPEED = 100.0f;
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private static BakedModel bakedIcoModel;
    private final BlockRenderDispatcher blockRenderDispatcher;
    private final ModelBlockRenderer modelRenderer;
    private final BlockColors blockColors;

    public TileChanceD20Renderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderDispatcher = context.getBlockRenderDispatcher();
        this.blockColors = Minecraft.getInstance().getBlockColors();
        this.modelRenderer = this.blockRenderDispatcher.getModelRenderer();
    }

    public void render(@NotNull TileChanceD20 d20, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        random.setSeed(432L);
        Level level = d20.getLevel();
        int stage = d20.getStage();
        int maxStage = 200;
        long gameTime = level != null ? level.getGameTime() : 0L;
        float wave = stage == 0 ? (float)(Math.sin(((float)gameTime % 6000.0f + partialTicks) / 6000.0f * 360.0f) * (double)0.3f) : ((float)stage + partialTicks) / 70.0f;
        d20.wave = wave;
        float rotation = ((float)gameTime + partialTicks) / (100.0f / ((float)(stage / 20) + 1.0f));
        float scale = Math.max(1.0f - (float)stage / (float)maxStage, 0.1f);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5 + (double)wave, 0.5);
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation * 360.0f));
        BlockState blockState = d20.getBlockState();
        if (bakedIcoModel == null) {
            bakedIcoModel = this.blockRenderDispatcher.getBlockModel(blockState);
        }
        int i = this.blockColors.getColor(blockState, null, null, 0);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        this.modelRenderer.renderModel(poseStack.last(), bufferIn.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)blockState, (boolean)false)), blockState, bakedIcoModel, f, f1, f2, combinedLightIn, combinedOverlayIn);
        poseStack.popPose();
        TileChanceD20Renderer.renderBeams(poseStack, bufferIn, rotation, wave, gameTime);
    }

    private static void renderBeams(PoseStack poseStack, MultiBufferSource bufferIn, float rotation, float wave, long gameTime) {
        poseStack.pushPose();
        VertexConsumer vertexConsumer = bufferIn.getBuffer(RenderType.lightning());
        float f7 = Math.min(rotation > 0.8f ? (rotation - 0.8f) / 0.2f : 0.0f, 1.0f);
        float color = (float)(gameTime % 75L) / 75.0f;
        Color tmpClr = new Color(Color.HSBtoRGB(color, 1.0f, 1.0f));
        int r = tmpClr.getRed();
        int g = tmpClr.getGreen();
        int b = tmpClr.getBlue();
        poseStack.translate(0.5, 0.5 + (double)wave, 0.5);
        int i = 0;
        while ((float)i < 5.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f + rotation * 90.0f));
            float beamScale = 0.15f;
            float f3 = (random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f) * beamScale;
            float f4 = (random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f) * beamScale;
            Matrix4f matrix4f = poseStack.last().pose();
            int alpha = 200;
            TileChanceD20Renderer.vertex01(vertexConsumer, matrix4f, r, g, b, alpha);
            TileChanceD20Renderer.vertex2(vertexConsumer, matrix4f, f3, f4, r, g, b, alpha);
            TileChanceD20Renderer.vertex3(vertexConsumer, matrix4f, f3, f4, r, g, b, alpha);
            TileChanceD20Renderer.vertex01(vertexConsumer, matrix4f, r, g, b, alpha);
            TileChanceD20Renderer.vertex3(vertexConsumer, matrix4f, f3, f4, r, g, b, alpha);
            TileChanceD20Renderer.vertex4(vertexConsumer, matrix4f, f3, f4, r, g, b, alpha);
            TileChanceD20Renderer.vertex01(vertexConsumer, matrix4f, r, g, b, alpha);
            TileChanceD20Renderer.vertex4(vertexConsumer, matrix4f, f3, f4, r, g, b, alpha);
            TileChanceD20Renderer.vertex2(vertexConsumer, matrix4f, f3, f4, r, g, b, alpha);
            ++i;
        }
        poseStack.popPose();
    }

    private static void vertex01(VertexConsumer vc, Matrix4f p_114221_, int r, int g, int b, int alpha) {
        vc.addVertex(p_114221_, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha);
    }

    private static void vertex2(VertexConsumer vc, Matrix4f p_114216_, float p_114217_, float p_114218_, int r, int g, int b, int alpha) {
        vc.addVertex(p_114216_, -HALF_SQRT_3 * p_114218_, p_114217_, -0.5f * p_114218_).setColor(r, g, b, 0);
    }

    private static void vertex3(VertexConsumer vc, Matrix4f p_114225_, float p_114226_, float p_114227_, int r, int g, int b, int alpha) {
        vc.addVertex(p_114225_, HALF_SQRT_3 * p_114227_, p_114226_, -0.5f * p_114227_).setColor(r, g, b, 0);
    }

    private static void vertex4(VertexConsumer vc, Matrix4f p_114230_, float p_114231_, float p_114232_, int r, int g, int b, int alpha) {
        vc.addVertex(p_114230_, 0.0f, p_114231_, p_114232_).setColor(r, g, b, 0);
    }
}

