/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.listeners;

import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.worldgen.CCSurfaceFeature;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.registries.DeferredRegister;

public class WorldGen {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"chancecubes");
    private static final ResourceLocation CC_SURFACE_ID = ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)"chance_cube_worldgen");
    private static final ResourceLocation CC_ORE_ID = ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)"chance_cube_oregen");
    private static final Supplier<Feature<NoneFeatureConfiguration>> CC_SURFACE_FEATURE = FEATURES.register("chance_cube_worldgen", CCSurfaceFeature::new);
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_CC_SURFACE = WorldGen.createConfiguredKey(CC_SURFACE_ID);
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_CC_ORE = WorldGen.createConfiguredKey(CC_ORE_ID);
    public static ResourceKey<PlacedFeature> CC_SURFACE = WorldGen.createPlacedKey(CC_SURFACE_ID);
    public static ResourceKey<PlacedFeature> CC_ORE = WorldGen.createPlacedKey(CC_ORE_ID);

    public static ResourceKey<ConfiguredFeature<?, ?>> createConfiguredKey(ResourceLocation id) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)id);
    }

    public static void configuredBootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        FeatureUtils.register(context, CONFIGURED_CC_SURFACE, CC_SURFACE_FEATURE.get());
        TagMatchTest ruletest = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest ruletest2 = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> ccOreTarget = List.of(OreConfiguration.target((RuleTest)ruletest, (BlockState)((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_CUBE.get())).defaultBlockState()), OreConfiguration.target((RuleTest)ruletest2, (BlockState)((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_CUBE.get())).defaultBlockState()));
        FeatureUtils.register(context, CONFIGURED_CC_ORE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ccOreTarget, 4));
    }

    public static ResourceKey<PlacedFeature> createPlacedKey(ResourceLocation id) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)id);
    }

    public static void placedBootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter holdergetter = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, CC_SURFACE, (Holder)holdergetter.getOrThrow(CONFIGURED_CC_SURFACE), (PlacementModifier[])new PlacementModifier[0]);
        PlacementUtils.register(context, CC_ORE, (Holder)holdergetter.getOrThrow(CONFIGURED_CC_ORE), WorldGen.commonOrePlacement(16, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)192))));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier modifier, PlacementModifier modifier1) {
        return List.of(modifier, InSquarePlacement.spread(), modifier1, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
        return WorldGen.orePlacement((PlacementModifier)CountPlacement.of((int)count), modifier);
    }
}

