/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.datagen;

import chanceCubes.datagen.CCubesBiomeModifiers;
import chanceCubes.datagen.CCubesBlockTagProvider;
import chanceCubes.datagen.CCubesDamageTypeProvider;
import chanceCubes.datagen.CCubesDamageTypeTagProvider;
import chanceCubes.datagen.CCubesItemTagProvider;
import chanceCubes.datagen.CCubesRecipeProvider;
import chanceCubes.listeners.WorldGen;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CCubesDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(() -> CCubesDatagen.getProvider().full());
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new CCubesRecipeProvider(packOutput, lookupProvider));
        CCubesBlockTagProvider blockTagsProvider = new CCubesBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new CCubesItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)blockTagsProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(CCubesDatagen::getProvider), Set.of("chancecubes")));
        generator.addProvider(event.includeServer(), (DataProvider)new CCubesDamageTypeTagProvider(packOutput, lookupProvider, existingFileHelper));
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.DAMAGE_TYPE, CCubesDamageTypeProvider::bootstrap);
        registryBuilder.add(Registries.CONFIGURED_FEATURE, WorldGen::configuredBootstrap);
        registryBuilder.add(Registries.PLACED_FEATURE, WorldGen::placedBootstrap);
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, CCubesBiomeModifiers::bootstrap);
        registryBuilder.add(Registries.BIOME, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }
}

