/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.commands;

import chanceCubes.CCubesCore;
import chanceCubes.commands.InfoAction;
import chanceCubes.commands.RewardArgument;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.mcwrapper.ItemWrapper;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.registry.player.PlayerRewardInfo;
import chanceCubes.rewards.DefaultGiantRewards;
import chanceCubes.rewards.DefaultRewards;
import chanceCubes.rewards.IChanceCubeReward;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.util.GiantCubeUtil;
import chanceCubes.util.NonreplaceableBlockOverride;
import chanceCubes.util.RewardsUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforge.server.command.EnumArgument;

public class CCubesServerCommands {
    public CCubesServerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chancecubes").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"reload").executes(this::executeReload))).then(Commands.literal((String)"version").executes(this::executeVersion))).then(Commands.literal((String)"handNBT").executes(this::executeHandNBT))).then(Commands.literal((String)"handJSON").executes(this::executeHandJSON))).then(Commands.literal((String)"handID").executes(this::executeHandID))).then(Commands.literal((String)"disableReward").then(Commands.argument((String)"rewardName", (ArgumentType)new RewardArgument()).executes(ctx -> this.executeDisableReward((CommandContext<CommandSourceStack>)ctx, RewardArgument.getReward((CommandContext<CommandSourceStack>)ctx, "rewardName")))))).then(Commands.literal((String)"enableReward").then(Commands.argument((String)"rewardName", (ArgumentType)RewardArgument.rewardArgument()).executes(ctx -> this.executeEnableReward((CommandContext<CommandSourceStack>)ctx, RewardArgument.getReward((CommandContext<CommandSourceStack>)ctx, "rewardName")))))).then(Commands.literal((String)"rewardsInfo").then(Commands.argument((String)"action", (ArgumentType)EnumArgument.enumArgument(InfoAction.class)).executes(ctx -> this.executeRewardInfo((CommandContext<CommandSourceStack>)ctx, (InfoAction)((Object)((Object)ctx.getArgument("action", InfoAction.class)))))))).then(Commands.literal((String)"test").executes(this::executeTest))).then(Commands.literal((String)"testRewards").executes(this::executeTestRewards))).then(Commands.literal((String)"testCustomRewards").executes(this::executeTestCustomRewards))).then(Commands.literal((String)"spawnGiantCube").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> this.executeSpawnGiantCube((CommandContext<CommandSourceStack>)ctx, BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos")))))).then(Commands.literal((String)"spawnReward").then(Commands.argument((String)"rewardName", (ArgumentType)RewardArgument.rewardArgument()).suggests((cs, builder) -> SharedSuggestionProvider.suggest(GlobalCCRewardRegistry.DEFAULT.getRewardNames(), (SuggestionsBuilder)builder)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(ctx -> this.executeSpawnReward((CommandContext<CommandSourceStack>)ctx, RewardArgument.getReward((CommandContext<CommandSourceStack>)ctx, "rewardName"), EntityArgument.getPlayers((CommandContext)ctx, (String)"target")))))));
    }

    public ServerPlayer getPlayer(CommandSourceStack source) {
        try {
            return source.getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            CCubesCore.logger.error("You should never see this. If you do you broke everything. Report to Turkey");
            return null;
        }
    }

    public int executeReload(CommandContext<CommandSourceStack> ctx) {
        new Thread(() -> {
            RegistryAccess provider = ((CommandSourceStack)ctx.getSource()).registryAccess();
            GlobalCCRewardRegistry.DEFAULT.ClearRewards();
            GlobalCCRewardRegistry.GIANT.ClearRewards();
            ConfigLoader.reload();
            DefaultRewards.loadDefaultRewards((HolderLookup.Provider)provider);
            DefaultGiantRewards.loadDefaultRewards((HolderLookup.Provider)provider);
            CustomRewardsLoader.instance.loadCustomRewards((HolderLookup.Provider)provider);
            GlobalCCRewardRegistry.loadCustomUserRewards(ServerLifecycleHooks.getCurrentServer());
            NonreplaceableBlockOverride.loadOverrides();
            RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Rewards Reloaded");
        }).start();
        return 0;
    }

    public int executeVersion(CommandContext<CommandSourceStack> ctx) {
        String ver = ((ModContainer)ModList.get().getModContainerById("chancecubes").get()).getModInfo().getVersion().toString();
        RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Chance Cubes Version " + ver);
        return 0;
    }

    public int executeHandNBT(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = this.getPlayer((CommandSourceStack)ctx.getSource());
        Tag nbt = player.getInventory().getSelected().saveOptional((HolderLookup.Provider)player.registryAccess());
        RewardsUtil.sendMessageToPlayer((Player)player, nbt.toString());
        return 0;
    }

    public int executeHandJSON(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = this.getPlayer((CommandSourceStack)ctx.getSource());
        ItemStack stack = player.getInventory().getSelected();
        if (!stack.isEmpty()) {
            JsonElement json = (JsonElement)ItemStack.CODEC.encodeStart((DynamicOps)((CommandSourceStack)ctx.getSource()).registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)stack).getOrThrow(string -> new IllegalStateException("Failed to encode item stack: " + string));
            RewardsUtil.sendMessageToPlayer((Player)player, json.toString());
        }
        return 0;
    }

    public int executeHandID(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = this.getPlayer((CommandSourceStack)ctx.getSource());
        ItemStack stack = player.getInventory().getSelected();
        if (!stack.isEmpty()) {
            ResourceLocation res = ItemWrapper.getItemId(stack);
            RewardsUtil.sendMessageToPlayer((Player)player, res.getNamespace() + ":" + res.getPath());
            RewardsUtil.sendMessageToPlayer((Player)player, "meta: " + stack.getDamageValue());
        }
        return 0;
    }

    public int executeDisableReward(CommandContext<CommandSourceStack> ctx, String reward) {
        ServerPlayer player = this.getPlayer((CommandSourceStack)ctx.getSource());
        if (GlobalCCRewardRegistry.DEFAULT.disableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " Has been disabled.");
        } else if (GlobalCCRewardRegistry.GIANT.disableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " Has been disabled.");
        } else {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " is either not currently enabled or is not a valid reward name.");
        }
        return 0;
    }

    public int executeEnableReward(CommandContext<CommandSourceStack> ctx, String reward) {
        ServerPlayer player = this.getPlayer((CommandSourceStack)ctx.getSource());
        if (GlobalCCRewardRegistry.DEFAULT.enableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " Has been enabled.");
        } else if (GlobalCCRewardRegistry.GIANT.enableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " Has been enabled.");
        } else {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " is either not currently disabled or is not a valid reward name.");
        }
        return 0;
    }

    public int executeRewardInfo(CommandContext<CommandSourceStack> ctx, InfoAction action) {
        ServerPlayer player = this.getPlayer((CommandSourceStack)ctx.getSource());
        List<PlayerRewardInfo> defaultrewards = GlobalCCRewardRegistry.DEFAULT.getPlayerRewardRegistry(player.getStringUUID()).getPlayersRewards();
        List<PlayerRewardInfo> giantrewards = GlobalCCRewardRegistry.GIANT.getPlayerRewardRegistry(player.getStringUUID()).getPlayersRewards();
        int defaultEnabled = defaultrewards.size();
        int giantEnabled = giantrewards.size();
        ArrayList<String> playerRewards = new ArrayList<String>();
        switch (action) {
            case DEFAULT: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===DEFAULT REWARDS===");
                for (PlayerRewardInfo playerRewardInfo : defaultrewards) {
                    RewardsUtil.sendMessageToPlayer((Player)player, playerRewardInfo.reward.getName());
                }
                break;
            }
            case GIANT: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===GIANT REWARDS===");
                for (PlayerRewardInfo playerRewardInfo : giantrewards) {
                    RewardsUtil.sendMessageToPlayer((Player)player, playerRewardInfo.reward.getName());
                }
                break;
            }
            case DEFAULT_ALL: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===DEFAULT REWARDS===");
                for (String string : GlobalCCRewardRegistry.DEFAULT.getRewardNames()) {
                    RewardsUtil.sendMessageToPlayer((Player)player, string);
                }
                break;
            }
            case GIANT_ALL: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===GIANT REWARDS===");
                for (String string : GlobalCCRewardRegistry.GIANT.getRewardNames()) {
                    RewardsUtil.sendMessageToPlayer((Player)player, string);
                }
                break;
            }
            case DEFAULT_DISABLED: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===DEFAULT REWARDS DISABLED===");
                for (PlayerRewardInfo playerRewardInfo : defaultrewards) {
                    playerRewards.add(playerRewardInfo.reward.getName());
                }
                for (String string : GlobalCCRewardRegistry.DEFAULT.getRewardNames()) {
                    if (playerRewards.contains(string)) continue;
                    RewardsUtil.sendMessageToPlayer((Player)player, string);
                }
                break;
            }
            case GIANT_DISABLED: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===GIANT REWARDS DISABLED===");
                for (PlayerRewardInfo playerRewardInfo : giantrewards) {
                    playerRewards.add(playerRewardInfo.reward.getName());
                }
                for (String string : GlobalCCRewardRegistry.GIANT.getRewardNames()) {
                    if (playerRewards.contains(string)) continue;
                    RewardsUtil.sendMessageToPlayer((Player)player, string);
                }
                break;
            }
        }
        RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "There are currently " + GlobalCCRewardRegistry.DEFAULT.getNumberOfLoadedRewards() + " regular rewards loaded and you have " + defaultEnabled + " rewards enabled");
        RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "There are currently " + GlobalCCRewardRegistry.GIANT.getNumberOfLoadedRewards() + " giant rewards loaded and you have " + giantEnabled + " rewards enabled");
        return 0;
    }

    public int executeTestRewards(CommandContext<CommandSourceStack> ctx) {
        CCubesSettings.testRewards = !CCubesSettings.testRewards;
        CCubesSettings.testingRewardIndex = 0;
        if (CCubesSettings.testRewards) {
            RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Reward testing is now enabled for all rewards!");
        } else {
            RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Reward testing is now disabled and normal randomness is back.");
        }
        return 0;
    }

    public int executeTestCustomRewards(CommandContext<CommandSourceStack> ctx) {
        CCubesSettings.testCustomRewards = !CCubesSettings.testCustomRewards;
        CCubesSettings.testingRewardIndex = 0;
        if (CCubesSettings.testCustomRewards) {
            RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Reward testing is now enabled for custom rewards!");
        } else {
            RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Reward testing is now disabled and normal randomness is back.");
        }
        return 0;
    }

    public int executeTest(CommandContext<CommandSourceStack> ctx) {
        return 0;
    }

    public int executeSpawnGiantCube(CommandContext<CommandSourceStack> ctx, BlockPos pos) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        if (RewardsUtil.isBlockUnbreakable((Level)level, pos.offset(0, 0, 0)) && CCubesSettings.nonReplaceableBlocks.contains(level.getBlockState(pos.offset(0, 0, 0)))) {
            return 0;
        }
        GiantCubeUtil.setupStructure(pos.offset(-1, -1, -1), (Level)level, true);
        level.playSound(null, pos, (SoundEvent)CCubesSounds.GIANT_CUBE_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return 0;
    }

    public int executeSpawnReward(CommandContext<CommandSourceStack> ctx, String rewardName, Collection<ServerPlayer> targets) {
        IChanceCubeReward reward = GlobalCCRewardRegistry.DEFAULT.getRewardByName(rewardName);
        if (reward == null) {
            reward = GlobalCCRewardRegistry.GIANT.getRewardByName(rewardName);
        }
        if (reward == null) {
            CCubesCore.logger.error(rewardName + " is not a valid reward in the spawnReward command!");
            return 0;
        }
        CCubesCore.logger.info("spawnReward command is spawning " + rewardName);
        for (ServerPlayer target : targets) {
            reward.trigger(((CommandSourceStack)ctx.getSource()).getLevel(), target.getOnPos(), (Player)target, new JsonObject());
        }
        return 0;
    }
}

