/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.client.ContainerSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrashSlotSaveState {
    private static final Logger logger = LogManager.getLogger();
    private static final String SETTINGS_FILE = "TrashSlotSaveState.json";
    private static final String DEFAULT_SETTINGS_FILE = "TrashSlotSaveState.default.json";
    private static final Gson gson = new Gson();
    private static TrashSlotSaveState instance;
    private final Set<String> hintsSeen = new HashSet<String>();
    private final Map<String, ContainerSettings> cachedSettings = new HashMap<String, ContainerSettings>();

    public static ContainerSettings getSettings(AbstractContainerScreen<?> gui, IGuiContainerLayout layout) {
        String containerId = layout.getContainerId(gui);
        TrashSlotSaveState saveState = TrashSlotSaveState.getInstance();
        return saveState.cachedSettings.computeIfAbsent(containerId, it -> new ContainerSettings(layout.getDefaultSlotX(gui), layout.getDefaultSlotY(gui), 0.5f, 0.5f, layout.isEnabledByDefault()));
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(new File(Minecraft.getInstance().gameDirectory, SETTINGS_FILE));){
            gson.toJson((Object)instance, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasSeenHint(String hint) {
        return this.hintsSeen.contains(hint);
    }

    public void markHintAsSeen(String hint) {
        this.hintsSeen.add(hint);
    }

    public static TrashSlotSaveState getInstance() {
        if (instance == null) {
            File saveStateFile = new File(Minecraft.getInstance().gameDirectory, SETTINGS_FILE);
            File defaultSaveStateFile = new File(Minecraft.getInstance().gameDirectory, DEFAULT_SETTINGS_FILE);
            if (!saveStateFile.exists() && defaultSaveStateFile.exists()) {
                try {
                    Files.copy(defaultSaveStateFile.toPath(), saveStateFile.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    logger.error("Failed to load TrashSlot default save state, will ignore defaults", (Throwable)e);
                }
            }
            if (saveStateFile.exists()) {
                try (FileReader reader = new FileReader(saveStateFile);){
                    instance = (TrashSlotSaveState)gson.fromJson((Reader)reader, TrashSlotSaveState.class);
                }
                catch (Throwable e) {
                    logger.error("Failed to load TrashSlot save state, resetting to default", e);
                }
            }
        }
        if (instance == null) {
            instance = new TrashSlotSaveState();
        }
        return instance;
    }
}

