/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.StringUtilsWrapper;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptPack;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;

public class ScriptFile
implements Comparable<ScriptFile> {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("^(\\w+)\\s*[:=]?\\s*(-?\\w+)$");
    public final ScriptPack pack;
    public final ScriptFileInfo info;
    private final Map<String, List<String>> properties;
    private int priority;
    private boolean ignored;
    private String packMode;
    private final Set<String> requiredMods;
    private boolean requiredClient;
    public String[] lines;
    public long lastModified;

    public ScriptFile(ScriptPack pack, ScriptFileInfo info) throws Exception {
        this.pack = pack;
        this.info = info;
        this.properties = new HashMap<String, List<String>>();
        this.priority = 0;
        this.ignored = false;
        this.packMode = "";
        this.requiredMods = new HashSet<String>(0);
        this.requiredClient = false;
        this.lines = Files.readAllLines(info.path).toArray(StringUtilsWrapper.EMPTY_STRING_ARRAY);
        try {
            this.lastModified = Files.getLastModifiedTime(this.info.path, new LinkOption[0]).toMillis();
        }
        catch (Exception ex) {
            this.lastModified = 0L;
        }
        for (int i = 0; i < this.lines.length; ++i) {
            String tline = this.lines[i].trim();
            if (tline.isEmpty() || tline.startsWith("import ")) {
                this.lines[i] = "";
                continue;
            }
            if (!tline.startsWith("//")) continue;
            Matcher matcher = PROPERTY_PATTERN.matcher(tline.substring(2).trim());
            if (matcher.find()) {
                this.properties.computeIfAbsent(matcher.group(1).trim(), k -> new ArrayList()).add(matcher.group(2).trim());
            }
            this.lines[i] = "";
        }
        this.priority = Integer.parseInt(this.getProperty("priority", "0"));
        this.ignored = this.getProperty("ignored", "false").equals("true") || this.getProperty("ignore", "false").equals("true");
        this.packMode = this.getProperty("packmode", "");
        this.requiredMods.addAll(this.getProperties("requires"));
        this.requiredClient = this.requiredMods.remove("client");
    }

    public void load(KubeJSContext cx) throws Throwable {
        cx.evaluateString(cx.topLevelScope, String.join((CharSequence)"\n", this.lines), this.info.location, 1, null);
        this.lines = StringUtilsWrapper.EMPTY_STRING_ARRAY;
    }

    public List<String> getProperties(String s) {
        return this.properties.getOrDefault(s, List.of());
    }

    public String getProperty(String s, String def) {
        List<String> l = this.getProperties(s);
        return l.isEmpty() ? def : l.getLast();
    }

    public int getPriority() {
        return this.priority;
    }

    public String skipLoading() {
        if (this.ignored) {
            return "Ignored";
        }
        if (this.requiredClient && !FMLLoader.getDist().isClient()) {
            return "Client only";
        }
        if (!this.packMode.isEmpty() && !this.packMode.equals(CommonProperties.get().packMode)) {
            return "Pack mode mismatch";
        }
        if (!this.requiredMods.isEmpty()) {
            for (String mod : this.requiredMods) {
                if (ModList.get().isLoaded(mod)) continue;
                return "Mod " + mod + " is not loaded";
            }
        }
        return "";
    }

    @Override
    public int compareTo(ScriptFile o) {
        int i = Integer.compare(o.priority, this.priority);
        return i == 0 ? this.info.locationPath.compareToIgnoreCase(o.info.locationPath) : i;
    }
}

