/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.viewer.server;

import dev.latvian.mods.kubejs.plugin.builtin.event.RecipeViewerEvents;
import dev.latvian.mods.kubejs.recipe.viewer.RecipeViewerEntryType;
import dev.latvian.mods.kubejs.recipe.viewer.server.ServerAddItemEntriesKubeEvent;
import dev.latvian.mods.kubejs.recipe.viewer.server.ServerAddItemInformationKubeEvent;
import dev.latvian.mods.kubejs.recipe.viewer.server.ServerGroupItemEntriesKubeEvent;
import dev.latvian.mods.kubejs.recipe.viewer.server.ServerRegisterItemSubtypesKubeEvent;
import dev.latvian.mods.kubejs.recipe.viewer.server.ServerRemoveItemEntriesKubeEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record ItemData(List<ItemStack> addedEntries, List<Ingredient> removedEntries, List<Ingredient> completelyRemovedEntries, List<Group> groupedEntries, List<Info> info, List<DataComponentSubtypes> dataComponentSubtypes) {
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemData::addedEntries, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), ItemData::removedEntries, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), ItemData::completelyRemovedEntries, (StreamCodec)Group.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemData::groupedEntries, (StreamCodec)Info.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemData::info, (StreamCodec)DataComponentSubtypes.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemData::dataComponentSubtypes, ItemData::new);

    public static ItemData collect() {
        ArrayList<ItemStack> addedEntries = new ArrayList<ItemStack>();
        ArrayList<Ingredient> removedEntries = new ArrayList<Ingredient>();
        ArrayList<Ingredient> completelyRemovedEntries = new ArrayList<Ingredient>();
        ArrayList<Group> groupedEntries = new ArrayList<Group>();
        ArrayList<Info> info = new ArrayList<Info>();
        ArrayList<DataComponentSubtypes> dataComponentSubtypes = new ArrayList<DataComponentSubtypes>();
        if (RecipeViewerEvents.ADD_ENTRIES.hasListeners(RecipeViewerEntryType.ITEM)) {
            RecipeViewerEvents.ADD_ENTRIES.post(ScriptType.SERVER, RecipeViewerEntryType.ITEM, new ServerAddItemEntriesKubeEvent(addedEntries));
        }
        if (RecipeViewerEvents.REMOVE_ENTRIES.hasListeners(RecipeViewerEntryType.ITEM)) {
            RecipeViewerEvents.REMOVE_ENTRIES.post(ScriptType.SERVER, RecipeViewerEntryType.ITEM, new ServerRemoveItemEntriesKubeEvent(removedEntries));
        }
        if (RecipeViewerEvents.REMOVE_ENTRIES_COMPLETELY.hasListeners(RecipeViewerEntryType.ITEM)) {
            RecipeViewerEvents.REMOVE_ENTRIES_COMPLETELY.post(ScriptType.SERVER, RecipeViewerEntryType.ITEM, new ServerRemoveItemEntriesKubeEvent(completelyRemovedEntries));
        }
        if (RecipeViewerEvents.GROUP_ENTRIES.hasListeners(RecipeViewerEntryType.ITEM)) {
            RecipeViewerEvents.GROUP_ENTRIES.post(ScriptType.SERVER, RecipeViewerEntryType.ITEM, new ServerGroupItemEntriesKubeEvent(groupedEntries));
        }
        if (RecipeViewerEvents.ADD_INFORMATION.hasListeners(RecipeViewerEntryType.ITEM)) {
            RecipeViewerEvents.ADD_INFORMATION.post(ScriptType.SERVER, RecipeViewerEntryType.ITEM, new ServerAddItemInformationKubeEvent(info));
        }
        if (RecipeViewerEvents.REGISTER_SUBTYPES.hasListeners(RecipeViewerEntryType.ITEM)) {
            RecipeViewerEvents.REGISTER_SUBTYPES.post(ScriptType.SERVER, RecipeViewerEntryType.ITEM, new ServerRegisterItemSubtypesKubeEvent(dataComponentSubtypes));
        }
        return new ItemData(List.copyOf(addedEntries), List.copyOf(removedEntries), List.copyOf(completelyRemovedEntries), List.copyOf(groupedEntries), List.copyOf(info), List.copyOf(dataComponentSubtypes));
    }

    public boolean isEmpty() {
        return this.addedEntries.isEmpty() && this.removedEntries.isEmpty() && this.completelyRemovedEntries.isEmpty() && this.groupedEntries.isEmpty() && this.info.isEmpty() && this.dataComponentSubtypes.isEmpty();
    }

    public record Group(Ingredient filter, ResourceLocation groupId, Component description) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Group> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, Group::filter, (StreamCodec)ResourceLocation.STREAM_CODEC, Group::groupId, (StreamCodec)ComponentSerialization.STREAM_CODEC, Group::description, Group::new);
    }

    public record Info(Ingredient filter, List<Component> info) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Info> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, Info::filter, (StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list()), Info::info, Info::new);
    }

    public record DataComponentSubtypes(Ingredient filter, List<DataComponentType<?>> components) {
        public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentSubtypes> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, DataComponentSubtypes::filter, (StreamCodec)DataComponentType.STREAM_CODEC.apply(ByteBufCodecs.list()), DataComponentSubtypes::components, DataComponentSubtypes::new);
    }
}

