/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.BlockWrapper;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.util.OpsContainer;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public record BlockComponent(boolean allowEmpty) implements RecipeComponent<Block>
{
    private static final Codec<Block> CODEC = BuiltInRegistries.BLOCK.byNameCodec();
    public static final RecipeComponentType<Block> BLOCK = RecipeComponentType.unit(KubeJS.id("block"), new BlockComponent(false));
    public static final RecipeComponentType<Block> OPTIONAL_BLOCK = RecipeComponentType.unit(KubeJS.id("optional_block"), new BlockComponent(true));

    @Override
    public RecipeComponentType<?> type() {
        return this.allowEmpty ? OPTIONAL_BLOCK : BLOCK;
    }

    @Override
    public Codec<Block> codec() {
        return CODEC;
    }

    @Override
    public TypeInfo typeInfo() {
        return TypeInfo.of(Block.class);
    }

    @Override
    public Block wrap(RecipeScriptContext cx, Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Block.class, BlockState.class, JsonPrimitive.class}, (Object)object, n)) {
            case 0 -> {
                Block b;
                yield b = (Block)object;
            }
            case 1 -> {
                BlockState s = (BlockState)object;
                yield s.getBlock();
            }
            case 2 -> {
                JsonPrimitive json = (JsonPrimitive)object;
                yield BlockWrapper.parseBlockState(cx.registries(), json.getAsString()).getBlock();
            }
            default -> BlockWrapper.parseBlockState(cx.registries(), String.valueOf(from)).getBlock();
        };
    }

    @Override
    public boolean matches(RecipeMatchContext cx, Block value, ReplacementMatchInfo match) {
        BlockStatePredicate m2;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof BlockStatePredicate && (m2 = (BlockStatePredicate)replacementMatch).testBlock(value);
    }

    @Override
    public boolean isEmpty(Block value) {
        return value == Blocks.AIR;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, Block value) {
        builder.append(value.kjs$getIdLocation());
    }

    @Override
    public String toString() {
        return this.allowEmpty ? "optional_block" : "block";
    }

    @Override
    public String toString(OpsContainer ops, Block value) {
        return value.kjs$getId();
    }
}

