/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.latvian.mods.kubejs.core.WithPersistentData;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;

public class PersistentDataCommands {
    public static ArgumentBuilder<CommandSourceStack, ?> addPersistentDataCommands(ArgumentBuilder<CommandSourceStack, ?> cmd, PersistentDataFactory factory) {
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"get").then(Commands.literal((String)"*").executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            for (WithPersistentData withPersistentData : objects) {
                Component dataStr = NbtUtils.toPrettyComponent((Tag)withPersistentData.kjs$getPersistentData());
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"").append((Component)Component.literal((String)"").withStyle(ChatFormatting.YELLOW).append(o.kjs$getDisplayName())).append(": ").append(dataStr), false);
            }
            return objects.size();
        }))).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            for (WithPersistentData withPersistentData : objects) {
                CompoundTag data = key.equals("*") ? withPersistentData.kjs$getPersistentData() : withPersistentData.kjs$getPersistentData().get(key);
                Component dataStr = data == null ? Component.literal((String)"null").withStyle(ChatFormatting.RED) : NbtUtils.toPrettyComponent((Tag)data);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"").append((Component)Component.literal((String)"").withStyle(ChatFormatting.YELLOW).append(o.kjs$getDisplayName())).append(": ").append(dataStr), false);
            }
            return objects.size();
        })));
        cmd.then(Commands.literal((String)"merge").then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            CompoundTag tag = CompoundTagArgument.getCompoundTag((CommandContext)ctx, (String)"nbt");
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().merge(tag);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"").append((Component)Component.literal((String)"").withStyle(ChatFormatting.YELLOW).append(o.kjs$getDisplayName())).append(" updated"), false);
            }
            return objects.size();
        })));
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"remove").then(Commands.literal((String)"*").executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().getAllKeys().removeIf(UtilsJS.ALWAYS_TRUE);
            }
            return objects.size();
        }))).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().remove(key);
            }
            return objects.size();
        })));
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"scoreboard").then(Commands.literal((String)"import").then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"target", (ArgumentType)ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument((String)"objective", (ArgumentType)ObjectiveArgument.objective()).executes(ctx -> {
            Objective objective;
            ServerScoreboard scoreboard = ((CommandSourceStack)ctx.getSource()).getServer().getScoreboard();
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            ScoreHolder target = ScoreHolderArgument.getName((CommandContext)ctx, (String)"target");
            ReadOnlyScoreInfo info = scoreboard.getPlayerScoreInfo(target, objective = ObjectiveArgument.getObjective((CommandContext)ctx, (String)"objective"));
            int score = info != null ? info.value() : 0;
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().putInt(key, score);
            }
            return objects.size();
        })))))).then(Commands.literal((String)"export").then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"targets", (ArgumentType)ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument((String)"objective", (ArgumentType)ObjectiveArgument.objective()).executes(ctx -> {
            ServerScoreboard scoreboard = ((CommandSourceStack)ctx.getSource()).getServer().getScoreboard();
            WithPersistentData object = factory.getOne((CommandContext<CommandSourceStack>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            Collection targets = ScoreHolderArgument.getNames((CommandContext)ctx, (String)"targets");
            Objective objective = ObjectiveArgument.getObjective((CommandContext)ctx, (String)"objective");
            int score = object.kjs$getPersistentData().getInt(key);
            for (ScoreHolder target : targets) {
                scoreboard.getOrCreatePlayerScore(target, objective).set(score);
            }
            return 1;
        }))))));
        return cmd;
    }

    @FunctionalInterface
    public static interface PersistentDataFactory {
        public static final SimpleCommandExceptionType EMPTY_LIST = new SimpleCommandExceptionType((Message)Component.literal((String)"Expected at least one target"));

        public Collection<? extends WithPersistentData> apply(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        default public Collection<? extends WithPersistentData> getAll(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
            Collection<? extends WithPersistentData> list = this.apply(ctx);
            if (list.isEmpty()) {
                throw EMPTY_LIST.create();
            }
            return list;
        }

        default public WithPersistentData getOne(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
            Collection<? extends WithPersistentData> list = this.apply(ctx);
            if (list.isEmpty()) {
                throw EMPTY_LIST.create();
            }
            return list.iterator().next();
        }
    }
}

