/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.latvian.mods.kubejs.level.KubeLevelEvent;
import dev.latvian.mods.kubejs.level.LevelBlock;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

@Info(value="Invoked when a detector block registered in KubeJS receives a block update.\n\n`Powered`/`Unpowered` event will be fired when the detector block is powered/unpowered.\n")
public class DetectorBlockKubeEvent
implements KubeLevelEvent {
    private final String detectorId;
    private final Level level;
    private final boolean powered;
    private final LevelBlock block;

    public DetectorBlockKubeEvent(String i, Level l, BlockPos p, boolean pow) {
        this.detectorId = i;
        this.level = l;
        this.powered = pow;
        this.block = this.level.kjs$getBlock(p);
    }

    @Info(value="The id of the detector block when it was registered.")
    public String getDetectorId() {
        return this.detectorId;
    }

    @Override
    @Info(value="The level where the detector block is located.")
    public Level getLevel() {
        return this.level;
    }

    @Info(value="If the detector block is powered.")
    public boolean isPowered() {
        return this.powered;
    }

    @Info(value="The detector block.")
    public LevelBlock getBlock() {
        return this.block;
    }
}

