/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu;

import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.menu.BalmMenuFactory;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.cookingforblockheads.block.entity.CounterBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.FruitBasketBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.SpiceRackBlockEntity;
import net.blay09.mods.cookingforblockheads.crafting.KitchenImpl;
import net.blay09.mods.cookingforblockheads.menu.CounterMenu;
import net.blay09.mods.cookingforblockheads.menu.CuttingBoardMenu;
import net.blay09.mods.cookingforblockheads.menu.FridgeMenu;
import net.blay09.mods.cookingforblockheads.menu.FruitBasketMenu;
import net.blay09.mods.cookingforblockheads.menu.KitchenMenu;
import net.blay09.mods.cookingforblockheads.menu.OvenMenu;
import net.blay09.mods.cookingforblockheads.menu.SpiceRackMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ModMenus {
    private static BalmMenus menus = Balm.getMenus();
    public static DeferredObject<MenuType<CounterMenu>> counter = menus.registerMenu(ModMenus.id("counter"), (BalmMenuFactory)new BalmMenuFactory<CounterMenu, BlockPos>(){

        public CounterMenu create(int windowId, Inventory inventory, BlockPos pos) {
            BlockEntity tileEntity = inventory.player.level().getBlockEntity(pos);
            return new CounterMenu(windowId, inventory, (CounterBlockEntity)Objects.requireNonNull(tileEntity));
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getStreamCodec() {
            return BlockPos.STREAM_CODEC.cast();
        }
    });
    public static DeferredObject<MenuType<FridgeMenu>> fridge = menus.registerMenu(ModMenus.id("fridge"), (BalmMenuFactory)new BalmMenuFactory<FridgeMenu, BlockPos>(){

        public FridgeMenu create(int windowId, Inventory inventory, BlockPos pos) {
            BlockEntity tileEntity = inventory.player.level().getBlockEntity(pos);
            return new FridgeMenu(windowId, inventory, (FridgeBlockEntity)Objects.requireNonNull(tileEntity));
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getStreamCodec() {
            return BlockPos.STREAM_CODEC.cast();
        }
    });
    public static DeferredObject<MenuType<FruitBasketMenu>> fruitBasket = menus.registerMenu(ModMenus.id("fruit_basket"), (BalmMenuFactory)new BalmMenuFactory<FruitBasketMenu, BlockPos>(){

        public FruitBasketMenu create(int windowId, Inventory inventory, BlockPos pos) {
            BlockEntity tileEntity = inventory.player.level().getBlockEntity(pos);
            return new FruitBasketMenu(windowId, inventory, (FruitBasketBlockEntity)Objects.requireNonNull(tileEntity));
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getStreamCodec() {
            return BlockPos.STREAM_CODEC.cast();
        }
    });
    public static DeferredObject<MenuType<OvenMenu>> oven = menus.registerMenu(ModMenus.id("oven"), (BalmMenuFactory)new BalmMenuFactory<OvenMenu, BlockPos>(){

        public OvenMenu create(int windowId, Inventory inventory, BlockPos pos) {
            BlockEntity tileEntity = inventory.player.level().getBlockEntity(pos);
            return new OvenMenu(windowId, inventory, (OvenBlockEntity)Objects.requireNonNull(tileEntity));
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getStreamCodec() {
            return BlockPos.STREAM_CODEC.cast();
        }
    });
    public static DeferredObject<MenuType<SpiceRackMenu>> spiceRack = menus.registerMenu(ModMenus.id("spice_rack"), (BalmMenuFactory)new BalmMenuFactory<SpiceRackMenu, BlockPos>(){

        public SpiceRackMenu create(int windowId, Inventory inventory, BlockPos pos) {
            BlockEntity tileEntity = inventory.player.level().getBlockEntity(pos);
            return new SpiceRackMenu(windowId, inventory, (SpiceRackBlockEntity)Objects.requireNonNull(tileEntity));
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getStreamCodec() {
            return BlockPos.STREAM_CODEC.cast();
        }
    });
    public static DeferredObject<MenuType<KitchenMenu>> recipeBook = menus.registerMenu(ModMenus.id("recipe_book"), (BalmMenuFactory)new BalmMenuFactory<KitchenMenu, ItemStack>(){

        public KitchenMenu create(int windowId, Inventory inventory, ItemStack itemStack) {
            KitchenImpl kitchen = new KitchenImpl(itemStack);
            return new KitchenMenu((MenuType<KitchenMenu>)((MenuType)recipeBook.get()), windowId, inventory.player, kitchen);
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemStack> getStreamCodec() {
            return ItemStack.STREAM_CODEC.cast();
        }
    });
    public static DeferredObject<MenuType<KitchenMenu>> cookingTable = menus.registerMenu(ModMenus.id("cooking_table"), (BalmMenuFactory)new BalmMenuFactory<KitchenMenu, BlockPos>(){

        public KitchenMenu create(int windowId, Inventory inventory, BlockPos pos) {
            Level level = inventory.player.level();
            KitchenImpl kitchen = new KitchenImpl(level, pos);
            return new KitchenMenu((MenuType<KitchenMenu>)((MenuType)cookingTable.get()), windowId, inventory.player, kitchen);
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getStreamCodec() {
            return BlockPos.STREAM_CODEC.cast();
        }
    });
    public static DeferredObject<MenuType<KitchenMenu>> noFilterBook = menus.registerMenu(ModMenus.id("no_filter_book"), (BalmMenuFactory)new BalmMenuFactory<KitchenMenu, ItemStack>(){

        public KitchenMenu create(int windowId, Inventory inventory, ItemStack itemStack) {
            KitchenImpl kitchen = new KitchenImpl(itemStack);
            return new KitchenMenu((MenuType<KitchenMenu>)((MenuType)noFilterBook.get()), windowId, inventory.player, kitchen);
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemStack> getStreamCodec() {
            return ItemStack.STREAM_CODEC.cast();
        }
    });
    public static DeferredObject<MenuType<KitchenMenu>> craftingBook = menus.registerMenu(ModMenus.id("crafting_book"), (BalmMenuFactory)new BalmMenuFactory<KitchenMenu, ItemStack>(){

        public KitchenMenu create(int windowId, Inventory inventory, ItemStack itemStack) {
            KitchenImpl kitchen = new KitchenImpl(itemStack);
            return new KitchenMenu((MenuType<KitchenMenu>)((MenuType)craftingBook.get()), windowId, inventory.player, kitchen);
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemStack> getStreamCodec() {
            return ItemStack.STREAM_CODEC.cast();
        }
    });
    public static DeferredObject<MenuType<CuttingBoardMenu>> cuttingBoard = menus.registerMenu(ModMenus.id("cutting_board"), (BalmMenuFactory)new BalmMenuFactory<CuttingBoardMenu, BlockPos>(){

        public CuttingBoardMenu create(int windowId, Inventory inventory, BlockPos pos) {
            return new CuttingBoardMenu(windowId, inventory, ContainerLevelAccess.create((Level)inventory.player.level(), (BlockPos)pos));
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getStreamCodec() {
            return BlockPos.STREAM_CODEC.cast();
        }
    });

    public static void initialize() {
    }

    @NotNull
    private static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)name);
    }
}

