/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.integration.extradelight.mechanicalArm;

import com.lance5057.extradelight.workstations.dryingrack.DryingRackBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class DryingRackArmInteractionPoint
extends ArmInteractionPoint {
    public DryingRackArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    public ItemStack extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof DryingRackBlockEntity) {
            DryingRackBlockEntity interaction = (DryingRackBlockEntity)blockEntity;
            IItemHandlerModifiable inv = interaction.getItemHandler();
            for (int i = 0; i < inv.getSlots(); ++i) {
                Optional r;
                ItemStack result = interaction.getItemHandler().extractItem(i, amount, true);
                if (result.isEmpty() || !(r = interaction.matchRecipe(result)).isEmpty()) continue;
                return interaction.getItemHandler().extractItem(i, amount, simulate);
            }
        }
        return ItemStack.EMPTY;
    }

    public ItemStack insert(ArmBlockEntity armBlockEntity, ItemStack stack, boolean simulate) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof DryingRackBlockEntity) {
            DryingRackBlockEntity interaction = (DryingRackBlockEntity)blockEntity;
            IItemHandlerModifiable inv = interaction.getItemHandler();
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (ItemStack.matches((ItemStack)inv.insertItem(i, stack, true), (ItemStack)stack)) continue;
                return inv.insertItem(i, stack, simulate);
            }
        }
        return stack;
    }

    protected Vec3 getInteractionPositionVector() {
        return Vec3.upFromBottomCenterOf((Vec3i)this.pos, (double)0.9375);
    }

    public static class Type
    extends ArmInteractionPointType {
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return level.getBlockEntity(pos) instanceof DryingRackBlockEntity;
        }

        @Nullable
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new DryingRackArmInteractionPoint(this, level, pos, state);
        }
    }
}

