/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.lexer;

import java.util.LinkedList;
import java.util.Stack;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.Token;
import org.openzen.zenscript.lexer.TokenStream;
import org.openzen.zenscript.lexer.TokenType;
import org.openzen.zenscript.lexer.WhitespaceFilteringParser;
import org.openzen.zenscript.lexer.ZSTokenType;

public class LLParserTokenStream<TT extends TokenType, T extends Token<TT>>
extends WhitespaceFilteringParser<TT, T> {
    private final LinkedList<PositionedToken> tokenMemory = new LinkedList();
    private final Stack<Integer> marks = new Stack();
    private int tokenMemoryOffset = 0;
    private int tokenMemoryCurrent = 0;

    public LLParserTokenStream(TokenStream<TT, T> stream) throws ParseException {
        super(stream);
    }

    public void pushMark() {
        this.marks.push(this.tokenMemoryCurrent);
    }

    public void popMark() {
        this.marks.pop();
        if (this.marks.isEmpty()) {
            this.tokenMemoryOffset = this.tokenMemoryCurrent;
            this.tokenMemory.clear();
        }
    }

    public void reset() {
        this.tokenMemoryCurrent = this.marks.pop();
    }

    @Override
    public T peek() {
        if (this.tokenMemoryCurrent < this.tokenMemoryOffset + this.tokenMemory.size()) {
            return this.tokenMemory.get((int)(this.tokenMemoryCurrent - this.tokenMemoryOffset)).token;
        }
        return super.peek();
    }

    @Override
    public T next() throws ParseException {
        if (this.tokenMemoryCurrent < this.tokenMemoryOffset + this.tokenMemory.size()) {
            return this.tokenMemory.get((int)(this.tokenMemoryCurrent++ - this.tokenMemoryOffset)).token;
        }
        Object result = super.next();
        if (this.marks.isEmpty()) {
            ++this.tokenMemoryOffset;
        } else {
            this.tokenMemory.add(new PositionedToken(this, this.getPosition(), this.getPositionBeforeWhitespace(), result));
        }
        ++this.tokenMemoryCurrent;
        return result;
    }

    @Override
    public CodePosition getPosition() {
        if (this.tokenMemoryCurrent < this.tokenMemoryOffset + this.tokenMemory.size()) {
            return this.tokenMemory.get((int)(this.tokenMemoryCurrent - this.tokenMemoryOffset)).position;
        }
        return super.getPosition();
    }

    @Override
    public CodePosition getPositionBeforeWhitespace() {
        if (this.tokenMemoryCurrent < this.tokenMemoryOffset + this.tokenMemory.size()) {
            return this.tokenMemory.get((int)(this.tokenMemoryCurrent - this.tokenMemoryOffset)).positionBeforeWhitespace;
        }
        return super.getPositionBeforeWhitespace();
    }

    public boolean isNext(TT type) {
        return this.peek().getType() == type;
    }

    public T optional(TT type) throws ParseException {
        if (this.peek().getType() == type) {
            return this.next();
        }
        return null;
    }

    public T required(TT type, String error) throws ParseException {
        T t = this.peek();
        if (t.getType() == type) {
            return this.next();
        }
        throw new ParseException(this.getPosition().withLength(t.getContent().length()), error);
    }

    public boolean hasNext() {
        return this.peek().getType() != this.getEOF();
    }

    public void recoverUntilTokenOrNewline(ZSTokenType type) throws ParseException {
        CodePosition last = this.getPosition();
        while (this.peek().getType() != type && this.getPosition().fromLine > last.fromLine) {
            this.next();
        }
    }

    public void recoverUntilBeforeToken(ZSTokenType type) throws ParseException {
        while (this.peek().getType() != type && this.peek().getType() != this.getEOF()) {
            this.next();
        }
    }

    public void recoverUntilOnToken(ZSTokenType type) throws ParseException {
        this.recoverUntilBeforeToken(type);
        this.next();
    }

    private class PositionedToken {
        public final CodePosition position;
        public final CodePosition positionBeforeWhitespace;
        public final T token;

        /*
         * WARNING - Possible parameter corruption
         */
        public PositionedToken(CodePosition position, CodePosition positionBeforeWhitespace, T token) {
            this.position = position;
            this.positionBeforeWhitespace = positionBeforeWhitespace;
            this.token = token;
        }
    }
}

