/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.command.argument.IItemStackArgument;
import com.blamejared.crafttweaker.api.command.argument.RecipeTypeArgument;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionAnyDamagedSerializer;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionCustomSerializer;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionDamagedAtMostSerializer;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.ConditionDamagedSerializer;
import com.blamejared.crafttweaker.api.ingredient.transformer.serializer.TransformCustomSerializer;
import com.blamejared.crafttweaker.api.ingredient.transformer.serializer.TransformDamageSerializer;
import com.blamejared.crafttweaker.api.ingredient.transformer.serializer.TransformReplaceSerializer;
import com.blamejared.crafttweaker.api.ingredient.transformer.serializer.TransformReuseSerializer;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientAny;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientList;
import com.blamejared.crafttweaker.api.ingredient.vanilla.CraftTweakerIngredients;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.serializer.CTShapedRecipeSerializer;
import com.blamejared.crafttweaker.api.recipe.serializer.CTShapelessRecipeSerializer;
import com.blamejared.crafttweaker.impl.loot.condition.LootTableIdRegexCondition;
import com.blamejared.crafttweaker.impl.script.ScriptRecipeType;
import com.blamejared.crafttweaker.impl.script.ScriptSerializer;
import com.blamejared.crafttweaker.platform.services.IRegistryHelper;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class NeoForgeRegistryHelper
implements IRegistryHelper {
    public static void init(IEventBus modBus) {
        modBus.addListener(newRegistry -> CraftTweakerRegistries.init());
        modBus.addListener(event -> {
            if (Registries.BLOCK.equals(event.getRegistryKey())) {
                Registry.register((Registry)BuiltInRegistries.LOOT_CONDITION_TYPE, (ResourceLocation)CraftTweakerConstants.rl("loot_table_id_regex"), (Object)LootTableIdRegexCondition.LOOT_TABLE_ID_REGEX);
            } else if (Registries.RECIPE_SERIALIZER.equals(event.getRegistryKey())) {
                event.register(Registries.RECIPE_SERIALIZER, helper -> {
                    helper.register(CraftTweakerConstants.rl("shapeless"), (Object)CTShapelessRecipeSerializer.INSTANCE);
                    helper.register(CraftTweakerConstants.rl("shaped"), (Object)CTShapedRecipeSerializer.INSTANCE);
                    helper.register(CraftTweakerConstants.rl("script"), (Object)ScriptSerializer.INSTANCE);
                });
            } else if (Registries.RECIPE_TYPE.equals(event.getRegistryKey())) {
                event.register(Registries.RECIPE_TYPE, helper -> helper.register(ScriptRecipeType.INSTANCE.id(), (Object)ScriptRecipeType.INSTANCE));
            } else if (Registries.COMMAND_ARGUMENT_TYPE.equals(event.getRegistryKey())) {
                event.register(Registries.COMMAND_ARGUMENT_TYPE, helper -> {
                    helper.register(RecipeTypeArgument.ID, (Object)ArgumentTypeInfos.registerByClass(RecipeTypeArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(RecipeTypeArgument::get)));
                    helper.register(IItemStackArgument.ID, (Object)ArgumentTypeInfos.registerByClass(IItemStackArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(IItemStackArgument::get)));
                });
            } else if (NeoForgeRegistries.Keys.INGREDIENT_TYPES.equals(event.getRegistryKey())) {
                event.register(NeoForgeRegistries.Keys.INGREDIENT_TYPES, helper -> {
                    helper.register(IIngredientAny.ID, CraftTweakerIngredients.Types.ANY);
                    helper.register(IIngredientList.ID, CraftTweakerIngredients.Types.LIST);
                    helper.register(IIngredient.INGREDIENT_ID, CraftTweakerIngredients.Types.CRAFTTWEAKER);
                    helper.register(IItemStack.INGREDIENT_ID, CraftTweakerIngredients.Types.IITEMSTACK);
                });
            } else if (CraftTweakerRegistries.Keys.TRANSFORMER_SERIALIZER.equals((Object)event.getRegistryKey())) {
                event.register(CraftTweakerRegistries.Keys.TRANSFORMER_SERIALIZER, helper -> {
                    helper.register(TransformReplaceSerializer.INSTANCE.getType(), (Object)TransformReplaceSerializer.INSTANCE);
                    helper.register(TransformDamageSerializer.INSTANCE.getType(), (Object)TransformDamageSerializer.INSTANCE);
                    helper.register(TransformCustomSerializer.INSTANCE.getType(), (Object)TransformCustomSerializer.INSTANCE);
                    helper.register(TransformReuseSerializer.INSTANCE.getType(), (Object)TransformReuseSerializer.INSTANCE);
                });
            } else if (CraftTweakerRegistries.Keys.CONDITIONER_SERIALIZER.equals((Object)event.getRegistryKey())) {
                event.register(CraftTweakerRegistries.Keys.CONDITIONER_SERIALIZER, helper -> {
                    helper.register(ConditionDamagedSerializer.INSTANCE.getType(), (Object)ConditionDamagedSerializer.INSTANCE);
                    helper.register(ConditionAnyDamagedSerializer.INSTANCE.getType(), (Object)ConditionAnyDamagedSerializer.INSTANCE);
                    helper.register(ConditionCustomSerializer.INSTANCE.getType(), (Object)ConditionCustomSerializer.INSTANCE);
                    helper.register(ConditionDamagedAtMostSerializer.INSTANCE.getType(), (Object)ConditionDamagedAtMostSerializer.INSTANCE);
                });
            }
        });
    }

    @Override
    public <T> Registry<T> makeRegistry(ResourceKey<Registry<T>> resourceKey) {
        return new RegistryBuilder(resourceKey).sync(true).create();
    }
}

