/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.component.ComponentAccess;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.ingredient.condition.IIngredientCondition;
import com.blamejared.crafttweaker.api.ingredient.condition.IngredientConditions;
import com.blamejared.crafttweaker.api.ingredient.transformer.IIngredientTransformer;
import com.blamejared.crafttweaker.api.ingredient.transformer.IngredientTransformers;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientIItemStack;
import com.blamejared.crafttweaker.api.item.IItemStackConstants;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.IItemStack")
@Document(value="vanilla/api/item/IItemStack")
public interface IItemStack
extends IIngredient,
IIngredientWithAmount,
DataComponentHolder,
ComponentAccess<IItemStack> {
    public static final ResourceLocation INGREDIENT_ID;
    public static final Codec<IItemStack> CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, IItemStack> STREAM_CODEC;
    @ZenCodeType.Field
    public static final String CRAFTTWEAKER_DATA_KEY = "CraftTweakerData";
    @ZenCodeType.Field
    public static final ResourceLocation BASE_ATTACK_DAMAGE_ID;
    @ZenCodeType.Field
    public static final ResourceLocation BASE_ATTACK_SPEED_ID;

    public static IItemStack empty() {
        return IItemStackConstants.EMPTY_STACK.get();
    }

    public static IItemStack of(ItemLike item) {
        return IItemStack.of(new ItemStack(item));
    }

    public static IItemStack of(ItemStack stack) {
        return Services.PLATFORM.createItemStack(stack, IngredientConditions.EMPTY, IngredientTransformers.EMPTY);
    }

    public static IItemStack of(ItemStack stack, IngredientConditions conditions, IngredientTransformers transformers) {
        return Services.PLATFORM.createItemStack(stack, conditions, transformers);
    }

    public static IItemStack of(ItemStack stack, boolean mutable) {
        return mutable ? IItemStack.ofMutable(stack) : IItemStack.of(stack);
    }

    public static IItemStack ofMutable(ItemStack stack) {
        return Services.PLATFORM.createItemStackMutable(stack, IngredientConditions.EMPTY, IngredientTransformers.EMPTY);
    }

    public static IItemStack ofMutable(ItemStack stack, IngredientConditions conditions, IngredientTransformers transformers) {
        return Services.PLATFORM.createItemStackMutable(stack, conditions, transformers);
    }

    public static IItemStack of(ItemStack stack, boolean mutable, IngredientConditions conditions, IngredientTransformers transformers) {
        return mutable ? IItemStack.ofMutable(stack, conditions, transformers) : IItemStack.of(stack, conditions, transformers);
    }

    @ZenCodeType.Method
    public IItemStack copy();

    @ZenCodeType.Getter(value="registryName")
    default public ResourceLocation getRegistryName() {
        return BuiltInRegistries.ITEM.getKey((Object)this.getInternal().getItem());
    }

    @ZenCodeType.Getter(value="owner")
    default public String getOwner() {
        return this.getRegistryName().getNamespace();
    }

    @Override
    default public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @ZenCodeType.Getter(value="prototype")
    default public DataComponentMap getPrototype() {
        return this.getInternal().getPrototype();
    }

    @ZenCodeType.Getter(value="componentsPatch")
    default public DataComponentPatch getComponentsPatch() {
        return this.getInternal().getComponentsPatch();
    }

    @ZenCodeType.Method
    default public <T> IItemStack with(DataComponentType<T> type, @ZenCodeType.Nullable T value) {
        return this.modify(itemStack -> itemStack.set(type, value));
    }

    @ZenCodeType.Method
    default public <T> IItemStack without(DataComponentType<T> type) {
        return this.remove(type);
    }

    @ZenCodeType.Method
    default public IItemStack withoutComponents() {
        return this.modify(itemStack -> {
            for (TypedDataComponent component : itemStack.getComponents()) {
                itemStack.remove(component.type());
            }
        });
    }

    @ZenCodeType.Method
    default public IItemStack withJsonComponent(DataComponentType type, @ZenCodeType.Nullable IData value) {
        return this.modify(itemStack -> {
            if (value == null) {
                itemStack.remove(type);
            } else {
                Codec codec = type.codecOrThrow();
                DataResult decode = codec.decode(IDataOps.INSTANCE.withTagAddingRegistryAccess(), (Object)value);
                itemStack.set(type, ((Pair)decode.getOrThrow()).getFirst());
            }
        });
    }

    @ZenCodeType.Method
    default public IItemStack withJsonComponents(IData value) {
        return this.modify(itemStack -> {
            DataResult decoded = DataComponentPatch.CODEC.decode(IDataOps.INSTANCE.withTagAddingRegistryAccess(), (Object)value);
            Pair pair = (Pair)decoded.getOrThrow();
            itemStack.applyComponents((DataComponentPatch)pair.getFirst());
        });
    }

    @ZenCodeType.Method
    default public <T, U> IItemStack update(DataComponentType<T> type, T defaultValue, U data, BiFunction<T, U, T> operator) {
        return this.modify(itemStack -> itemStack.update(type, defaultValue, data, operator));
    }

    @ZenCodeType.Method
    default public <T> IItemStack update(DataComponentType<T> type, T defaultValue, UnaryOperator<T> operator) {
        return this.modify(itemStack -> itemStack.update(type, defaultValue, operator));
    }

    @ZenCodeType.Method
    default public <T> IItemStack remove(DataComponentType<T> type) {
        return this.modify(itemStack -> itemStack.remove(type));
    }

    @ZenCodeType.Method
    default public IItemStack applyComponents(DataComponentMap map) {
        return this.modify(itemStack -> itemStack.applyComponents(map));
    }

    @ZenCodeType.Method
    default public IItemStack applyComponents(DataComponentPatch patch) {
        return this.modify(itemStack -> itemStack.applyComponents(patch));
    }

    @ZenCodeType.Method
    default public IItemStack applyComponentsAndValidate(DataComponentPatch patch) {
        return this.modify(itemStack -> itemStack.applyComponentsAndValidate(patch));
    }

    @ZenCodeType.Getter(value="displayName")
    default public Component getDisplayName() {
        return this.getInternal().getDisplayName();
    }

    @ZenCodeType.Getter(value="hoverName")
    default public Component getHoverName() {
        return this.getInternal().getHoverName();
    }

    @ZenCodeType.Getter(value="hasFoil")
    default public boolean hasFoil() {
        return this.getInternal().hasFoil();
    }

    @ZenCodeType.Getter(value="isEnchantable")
    default public boolean isEnchantable() {
        return this.getInternal().isEnchantable();
    }

    @Override
    @ZenCodeType.Getter(value="amount")
    default public int amount() {
        return this.getInternal().getCount();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    default public IItemStack withAmount(int amount) {
        return this.modify(itemStack -> itemStack.setCount(amount));
    }

    @ZenCodeType.Method
    default public IItemStack grow(@ZenCodeType.OptionalInt(value=1) int amount) {
        return this.withAmount(this.amount() + amount);
    }

    @ZenCodeType.Method
    default public IItemStack shrink(@ZenCodeType.OptionalInt(value=1) int amount) {
        return this.withAmount(this.amount() - amount);
    }

    @ZenCodeType.Getter(value="stackable")
    default public boolean isStackable() {
        return this.getInternal().isStackable();
    }

    @ZenCodeType.Method
    default public Map<Attribute, List<AttributeModifier>> getAttributes(EquipmentSlot slotType) {
        HashMap<Attribute, List<AttributeModifier>> ret = new HashMap<Attribute, List<AttributeModifier>>();
        this.getInternal().forEachModifier(slotType, (attributeHolder, attributeModifier) -> ret.computeIfAbsent((Attribute)attributeHolder.value(), attribute -> new ArrayList()).add(attributeModifier));
        return ret;
    }

    @ZenCodeType.Getter(value="damageableItem")
    default public boolean isDamageableItem() {
        return this.getInternal().isDamageableItem();
    }

    @ZenCodeType.Getter(value="damaged")
    default public boolean isDamaged() {
        return this.getInternal().isDamaged();
    }

    @Override
    @ZenCodeType.Getter(value="maxDamage")
    default public int getMaxDamage() {
        return this.getInternal().getMaxDamage();
    }

    @ZenCodeType.Getter(value="descriptionId")
    default public String getDescriptionId() {
        return this.getInternal().getDescriptionId();
    }

    @Override
    default public boolean matches(IItemStack stack) {
        return ItemStackUtil.areStacksTheSame(this.getInternal(), stack.getInternal(), this.conditions()) && this.conditions().test(stack);
    }

    @Override
    default public String getCommandString() {
        return ItemStackUtil.getCommandString(this.getInternal(), this.isMutable());
    }

    @ZenCodeType.Method
    default public int getUseDuration(LivingEntity entity) {
        return this.getInternal().getUseDuration(entity);
    }

    @ZenCodeType.Getter(value="useOnRelease")
    default public boolean useOnRelease() {
        return this.getInternal().useOnRelease();
    }

    @ZenCodeType.Getter(value="burnTime")
    default public int getBurnTime() {
        return Services.EVENT.getBurnTime(this);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="potPatternId")
    default public @ZenCodeType.Nullable ResourceKey<DecoratedPotPattern> getPotPatternId() {
        return DecoratedPotPatterns.getPatternFromItem((Item)this.getInternal().getItem());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="potPattern")
    default public @ZenCodeType.Nullable DecoratedPotPattern getPotPattern() {
        return (DecoratedPotPattern)BuiltInRegistries.DECORATED_POT_PATTERN.get(this.getPotPatternId());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MOD)
    default public Percentaged<IItemStack> percent(double percentage) {
        return new Percentaged<IItemStack>(this, percentage / 100.0, iItemStack -> iItemStack.getCommandString() + " % " + percentage);
    }

    @ZenCodeType.Caster(implicit=true)
    default public Percentaged<IItemStack> asWeightedItemStack() {
        return this.percent(100.0);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="definition")
    @ZenCodeType.Caster(implicit=true)
    default public Item getDefinition() {
        return this.getInternal().getItem();
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public ItemLike asItemLike() {
        return this.getInternal().getItem();
    }

    @ZenCodeType.Method
    public IItemStack asMutable();

    @ZenCodeType.Method
    public IItemStack asImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isImmutable")
    public boolean isImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isMutable")
    default public boolean isMutable() {
        return !this.isImmutable();
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public ItemStack getInternal();

    @Override
    default public Ingredient asVanillaIngredient() {
        if (this.getInternal().isEmpty()) {
            return Ingredient.EMPTY;
        }
        return IngredientIItemStack.ingredient(this);
    }

    @ZenCodeType.Method
    default public ItemStack getImmutableInternal() {
        return this.getInternal().copy();
    }

    @Override
    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public IIngredientWithAmount asIIngredientWithAmount() {
        return this;
    }

    @Override
    default public IItemStack ingredient() {
        return this;
    }

    @Override
    default public IData asIData() {
        IData data = IIngredient.super.asIData();
        if (!1.$assertionsDisabled && !(data instanceof MapData)) {
            throw new AssertionError();
        }
        data.put("count", new IntData(this.amount()));
        return data;
    }

    @Override
    default public IIngredient transform(IIngredientTransformer transformer) {
        return this.modifyThis(iItemStack -> iItemStack.transformers().add(transformer));
    }

    @Override
    default public IIngredient condition(IIngredientCondition condition) {
        return this.modifyThis(iItemStack -> iItemStack.conditions().add(condition));
    }

    public IItemStack modify(Consumer<ItemStack> var1);

    public IItemStack modifyThis(Consumer<IItemStack> var1);

    @NotNull
    default public DataComponentMap getComponents() {
        return this.getInternal().getComponents();
    }

    default public <T> T get(@NotNull DataComponentType<? extends T> type) {
        return (T)this.getInternal().get(type);
    }

    @NotNull
    default public <T> T getOrDefault(@NotNull DataComponentType<? extends T> type, @NotNull T value) {
        return (T)this.getInternal().getOrDefault(type, value);
    }

    default public boolean has(@NotNull DataComponentType<?> type) {
        return this.getInternal().has(type);
    }

    @Override
    default public <U> IItemStack _without(DataComponentType<U> componentType) {
        return this.without(componentType);
    }

    @Override
    default public <U> IItemStack _with(DataComponentType<U> componentType, @Nullable U value) {
        return this.with(componentType, value);
    }

    @Override
    default public <U> U _get(DataComponentType<? extends U> componentType) {
        return this.get(componentType);
    }

    @Override
    default public <U> boolean _has(DataComponentType<U> componentType) {
        return this.has(componentType);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        INGREDIENT_ID = CraftTweakerConstants.rl("iitemstack");
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(IItemStack::getInternal), (App)Codec.BOOL.fieldOf("mutable").forGetter(IItemStack::isMutable), (App)IngredientConditions.CODEC.optionalFieldOf("conditions", (Object)IngredientConditions.EMPTY).forGetter(IIngredient::conditions), (App)IngredientTransformers.CODEC.optionalFieldOf("transformers", (Object)IngredientTransformers.EMPTY).forGetter(IIngredient::transformers)).apply((Applicative)instance, IItemStack::of));
        STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, IItemStack::getInternal, (StreamCodec)ByteBufCodecs.BOOL, IItemStack::isMutable, IngredientConditions.STREAM_CODEC, IIngredient::conditions, IngredientTransformers.STREAM_CODEC, IIngredient::transformers, IItemStack::of);
        BASE_ATTACK_DAMAGE_ID = Item.BASE_ATTACK_DAMAGE_ID;
        BASE_ATTACK_SPEED_ID = Item.BASE_ATTACK_SPEED_ID;
    }
}

