/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.component.ComponentAccess;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.data.visitor.DataToStringVisitor;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.FluidStackConstants;
import com.blamejared.crafttweaker.natives.component.ExpandDataComponentType;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.fluid.IFluidStack")
@Document(value="vanilla/api/fluid/IFluidStack")
public interface IFluidStack
extends CommandStringDisplayable,
DataComponentHolder,
ComponentAccess<IFluidStack> {
    @ZenCodeType.Method
    public static IFluidStack empty() {
        return FluidStackConstants.EMPTY.get();
    }

    public static <T> IFluidStack of(T convertable) {
        return Services.PLATFORM.createFluidStack(convertable);
    }

    public static IFluidStack of(Fluid fluid, long amount) {
        return Services.PLATFORM.createFluidStack(fluid, amount, DataComponentPatch.EMPTY);
    }

    public static IFluidStack of(Fluid fluid, long amount, DataComponentPatch components) {
        return Services.PLATFORM.createFluidStack(fluid, amount, components);
    }

    public static <T> IFluidStack of(T convertable, boolean mutable) {
        return mutable ? IFluidStack.ofMutable(convertable) : IFluidStack.of(convertable);
    }

    public static IFluidStack of(Fluid fluid, long amount, boolean mutable) {
        return mutable ? IFluidStack.ofMutable(fluid, amount, DataComponentPatch.EMPTY) : IFluidStack.of(fluid, amount, DataComponentPatch.EMPTY);
    }

    public static IFluidStack of(Fluid fluid, long amount, DataComponentPatch components, boolean mutable) {
        return mutable ? IFluidStack.ofMutable(fluid, amount, components) : IFluidStack.of(fluid, amount, components);
    }

    public static <T> IFluidStack ofMutable(T convertable) {
        return Services.PLATFORM.createFluidStackMutable(convertable);
    }

    public static IFluidStack ofMutable(Fluid fluid, long amount) {
        return Services.PLATFORM.createFluidStackMutable(fluid, amount, DataComponentPatch.EMPTY);
    }

    public static IFluidStack ofMutable(Fluid fluid, long amount, DataComponentPatch components) {
        return Services.PLATFORM.createFluidStackMutable(fluid, amount, components);
    }

    @ZenCodeType.Getter(value="registryName")
    default public ResourceLocation getRegistryName() {
        return BuiltInRegistries.FLUID.getKey((Object)this.getFluid());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean matches(IFluidStack other) {
        return this.getAmount() >= other.getAmount() && this.isFluidEqual(other);
    }

    default public boolean isFluidEqual(IFluidStack other) {
        return this.getFluid() == other.getFluid() && FluidStackConstants.TAG_EQUALS.test(this, other);
    }

    @ZenCodeType.Getter(value="empty")
    public boolean isEmpty();

    @ZenCodeType.Getter(value="amount")
    public long getAmount();

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    public IFluidStack setAmount(int var1);

    @ZenCodeType.Method
    default public IFluidStack asMutable() {
        if (!this.isImmutable()) {
            return this;
        }
        return IFluidStack.of(this.getInternal());
    }

    @ZenCodeType.Method
    default public IFluidStack asImmutable() {
        if (this.isImmutable()) {
            return this;
        }
        return IFluidStack.of(this.getImmutableInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isImmutable")
    public boolean isImmutable();

    @ZenCodeType.Method
    default public IFluidStack copy() {
        if (this.isImmutable()) {
            return IFluidStack.of(this.getImmutableInternal());
        }
        return IFluidStack.ofMutable(this.getImmutableInternal());
    }

    @ZenCodeType.Getter(value="fluid")
    @ZenCodeType.Caster(implicit=true)
    public Fluid getFluid();

    @ZenCodeType.Caster(implicit=true)
    default public CTFluidIngredient asFluidIngredient() {
        return new CTFluidIngredient.FluidStackIngredient(this);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    default public CTFluidIngredient asList(CTFluidIngredient other) {
        ArrayList<CTFluidIngredient> elements = new ArrayList<CTFluidIngredient>();
        elements.add(this.asFluidIngredient());
        elements.add(other);
        return new CTFluidIngredient.CompoundFluidIngredient(elements);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public IData asIData() {
        return (IData)this.codec().encodeStart(IDataOps.INSTANCE.withRegistryAccess(), (Object)this).getOrThrow(s -> new IllegalStateException("Error while encoding IFluidStack as IData: " + s));
    }

    public Codec<IFluidStack> codec();

    @Override
    default public String getCommandString() {
        Fluid fluid = this.getFluid();
        StringBuilder builder = new StringBuilder().append("<fluid:").append(BuiltInRegistries.FLUID.getKey((Object)fluid)).append(">");
        DataComponentPatch.SplitResult split = this.getComponents().asPatch().split();
        split.added().filter(Predicate.not(DataComponentType::isTransient)).forEach(typedDataComponent -> builder.append(".withJsonComponent(").append(ExpandDataComponentType.getCommandString(typedDataComponent.type())).append(", ").append(((IData)typedDataComponent.encodeValue(IDataOps.INSTANCE.withRegistryAccess()).getOrThrow()).accept(DataToStringVisitor.ESCAPE)).append(")"));
        split.removed().forEach(dataComponentType -> builder.append(".without(").append(ExpandDataComponentType.getCommandString(dataComponentType)).append(")"));
        if (!this.isEmpty() && this.getAmount() != 1L) {
            builder.append(" * ").append(this.getAmount());
        }
        return builder.toString();
    }

    public PatchedDataComponentMap getComponents();

    @ZenCodeType.Method
    public <T> IFluidStack with(DataComponentType<T> var1, @ZenCodeType.Nullable T var2);

    @ZenCodeType.Method
    default public <T> IFluidStack without(DataComponentType<T> type) {
        return this.remove(type);
    }

    @ZenCodeType.Method
    public IFluidStack withJsonComponent(DataComponentType var1, @ZenCodeType.Nullable IData var2);

    @ZenCodeType.Method
    public IFluidStack withJsonComponents(IData var1);

    @ZenCodeType.Method
    public <T> IFluidStack remove(DataComponentType<T> var1);

    @ZenCodeType.Method
    public <T, U> IFluidStack update(DataComponentType<T> var1, T var2, U var3, BiFunction<T, U, T> var4);

    @ZenCodeType.Method
    public <T> IFluidStack update(DataComponentType<T> var1, T var2, UnaryOperator<T> var3);

    @ZenCodeType.Method
    public IFluidStack applyComponents(DataComponentMap var1);

    @ZenCodeType.Method
    public IFluidStack applyComponents(DataComponentPatch var1);

    public <T> T getInternal();

    public <T> T getImmutableInternal();

    @Override
    default public <U> IFluidStack _without(DataComponentType<U> componentType) {
        return this.without(componentType);
    }

    @Override
    default public <U> IFluidStack _with(DataComponentType<U> componentType, @Nullable U value) {
        return this.with(componentType, value);
    }

    @Override
    default public <U> U _get(DataComponentType<? extends U> componentType) {
        return (U)this.get(componentType);
    }

    @Override
    default public <U> boolean _has(DataComponentType<U> componentType) {
        return this.has(componentType);
    }
}

