/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.component;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.Filterable;
import net.minecraft.util.Unit;
import net.minecraft.world.LockCode;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DebugStickState;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.component.ComponentAccess")
@Document(value="vanilla/api/component/ComponentAccess")
public interface ComponentAccess<T extends ComponentAccess<T>> {
    @ZenCodeType.Getter(value="hasCustomData")
    default public boolean hasCustomData() {
        return this._has(DataComponents.CUSTOM_DATA);
    }

    @ZenCodeType.Getter(value="customData")
    default public CustomData getCustomData() {
        return (CustomData)this._get(DataComponents.CUSTOM_DATA);
    }

    @ZenCodeType.Method
    default public T withCustomData(MapData customData) {
        return this.withCustomData(CustomData.of((CompoundTag)customData.getInternal()));
    }

    @ZenCodeType.Method
    default public T withCustomData(CustomData customData) {
        return this._with(DataComponents.CUSTOM_DATA, customData);
    }

    @ZenCodeType.Method
    default public T withoutCustomData() {
        return this._without(DataComponents.CUSTOM_DATA);
    }

    @ZenCodeType.Getter(value="hasMaxStackSize")
    default public boolean hasMaxStackSize() {
        return this._has(DataComponents.MAX_STACK_SIZE);
    }

    @ZenCodeType.Getter(value="maxStackSize")
    default public int getMaxStackSize() {
        return (Integer)this._get(DataComponents.MAX_STACK_SIZE);
    }

    @ZenCodeType.Method
    default public T withMaxStackSize(int maxStackSize) {
        return this._with(DataComponents.MAX_STACK_SIZE, maxStackSize);
    }

    @ZenCodeType.Method
    default public T withoutMaxStackSize() {
        return this._without(DataComponents.MAX_STACK_SIZE);
    }

    @ZenCodeType.Getter(value="hasMaxDamage")
    default public boolean hasMaxDamage() {
        return this._has(DataComponents.MAX_DAMAGE);
    }

    @ZenCodeType.Getter(value="maxDamage")
    default public int getMaxDamage() {
        return (Integer)this._get(DataComponents.MAX_DAMAGE);
    }

    @ZenCodeType.Method
    default public T withMaxDamage(int maxDamage) {
        return this._with(DataComponents.MAX_DAMAGE, maxDamage);
    }

    @ZenCodeType.Method
    default public T withoutMaxDamage() {
        return this._without(DataComponents.MAX_DAMAGE);
    }

    @ZenCodeType.Getter(value="hasDamage")
    default public boolean hasDamage() {
        return this._has(DataComponents.DAMAGE);
    }

    @ZenCodeType.Getter(value="damage")
    default public int getDamage() {
        return (Integer)this._get(DataComponents.DAMAGE);
    }

    @ZenCodeType.Method
    default public T withDamage(int damage) {
        return this._with(DataComponents.DAMAGE, damage);
    }

    @ZenCodeType.Method
    default public T withoutDamage() {
        return this._without(DataComponents.DAMAGE);
    }

    @ZenCodeType.Getter(value="hasUnbreakable")
    default public boolean hasUnbreakable() {
        return this._has(DataComponents.UNBREAKABLE);
    }

    @ZenCodeType.Getter(value="unbreakable")
    default public Unbreakable getUnbreakable() {
        return (Unbreakable)this._get(DataComponents.UNBREAKABLE);
    }

    @ZenCodeType.Method
    default public T withUnbreakable(@ZenCodeType.OptionalBoolean(value=true) boolean showInTooltip) {
        return this.withUnbreakable(new Unbreakable(showInTooltip));
    }

    @ZenCodeType.Method
    default public T withUnbreakable(Unbreakable unbreakable) {
        return this._with(DataComponents.UNBREAKABLE, unbreakable);
    }

    @ZenCodeType.Method
    default public T withoutUnbreakable() {
        return this._without(DataComponents.UNBREAKABLE);
    }

    @ZenCodeType.Getter(value="hasCustomName")
    default public boolean hasCustomName() {
        return this._has(DataComponents.CUSTOM_NAME);
    }

    @ZenCodeType.Getter(value="customName")
    default public Component getCustomName() {
        return (Component)this._get(DataComponents.CUSTOM_NAME);
    }

    @ZenCodeType.Method
    default public T withCustomName(Component name) {
        return this._with(DataComponents.CUSTOM_NAME, name);
    }

    @ZenCodeType.Method
    default public T withoutCustomName() {
        return this._without(DataComponents.CUSTOM_NAME);
    }

    @ZenCodeType.Getter(value="hasItemName")
    default public boolean hasItemName() {
        return this._has(DataComponents.ITEM_NAME);
    }

    @ZenCodeType.Getter(value="itemName")
    default public Component getItemName() {
        return (Component)this._get(DataComponents.ITEM_NAME);
    }

    @ZenCodeType.Method
    default public T withItemName(Component name) {
        return this._with(DataComponents.ITEM_NAME, name);
    }

    @ZenCodeType.Method
    default public T withoutItemName() {
        return this._without(DataComponents.ITEM_NAME);
    }

    @ZenCodeType.Getter(value="hasLore")
    default public boolean hasLore() {
        return this._has(DataComponents.LORE);
    }

    @ZenCodeType.Getter(value="lore")
    default public ItemLore getLore() {
        return (ItemLore)this._get(DataComponents.LORE);
    }

    @ZenCodeType.Method
    default public T withLore(List<Component> components) {
        return this.withLore(new ItemLore(components));
    }

    @ZenCodeType.Method
    default public T withLore(Component components) {
        return this.withLore(new ItemLore(Collections.singletonList(components)));
    }

    @ZenCodeType.Method
    default public T withLore(ItemLore lore) {
        return this._with(DataComponents.LORE, lore);
    }

    @ZenCodeType.Method
    default public T withoutLore() {
        return this._without(DataComponents.LORE);
    }

    @ZenCodeType.Getter(value="hasRarity")
    default public boolean hasRarity() {
        return this._has(DataComponents.RARITY);
    }

    @ZenCodeType.Getter(value="rarity")
    default public Rarity getRarity() {
        return (Rarity)this._get(DataComponents.RARITY);
    }

    @ZenCodeType.Method
    default public T withRarity(Rarity rarity) {
        return this._with(DataComponents.RARITY, rarity);
    }

    @ZenCodeType.Method
    default public T withoutRarity() {
        return this._without(DataComponents.RARITY);
    }

    @ZenCodeType.Getter(value="hasEnchantments")
    default public boolean hasEnchantments() {
        return this._has(DataComponents.ENCHANTMENTS);
    }

    @ZenCodeType.Getter(value="enchantments")
    default public ItemEnchantments getEnchantments() {
        return (ItemEnchantments)this._get(DataComponents.ENCHANTMENTS);
    }

    @ZenCodeType.Method
    default public T withEnchantments(ItemEnchantments enchantments) {
        return this._with(DataComponents.ENCHANTMENTS, enchantments);
    }

    @ZenCodeType.Method
    default public T withEnchantment(Enchantment enchantment, @ZenCodeType.OptionalInt(value=1) int level) {
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(this.hasEnchantments() ? this.getEnchantments() : ItemEnchantments.EMPTY);
        mutable.set(Services.REGISTRY.holderOrThrow(Registries.ENCHANTMENT, enchantment), level);
        return this.withEnchantments(mutable.toImmutable());
    }

    @ZenCodeType.Method
    default public T withoutEnchantment(Enchantment enchantment) {
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(this.hasEnchantments() ? this.getEnchantments() : ItemEnchantments.EMPTY);
        mutable.removeIf(enchantmentHolder -> enchantmentHolder.value() == enchantment);
        return this.withEnchantments(mutable.toImmutable());
    }

    @ZenCodeType.Method
    default public T withoutEnchantments() {
        return this._without(DataComponents.ENCHANTMENTS);
    }

    @ZenCodeType.Getter(value="hasCanPlaceOn")
    default public boolean hasCanPlaceOn() {
        return this._has(DataComponents.CAN_PLACE_ON);
    }

    @ZenCodeType.Getter(value="canPlaceOn")
    default public AdventureModePredicate getCanPlaceOn() {
        return (AdventureModePredicate)this._get(DataComponents.CAN_PLACE_ON);
    }

    @ZenCodeType.Method
    default public T withCanPlaceOn(List<BlockPredicate> predicates, @ZenCodeType.OptionalBoolean(value=true) boolean showInTooltip) {
        return this.withCanPlaceOn(new AdventureModePredicate(predicates, showInTooltip));
    }

    @ZenCodeType.Method
    default public T withCanPlaceOn(AdventureModePredicate predicate) {
        return this._with(DataComponents.CAN_PLACE_ON, predicate);
    }

    @ZenCodeType.Method
    default public T withoutCanPlaceOn() {
        return this._without(DataComponents.CAN_PLACE_ON);
    }

    @ZenCodeType.Getter(value="hasCanBreak")
    default public boolean hasCanBreak() {
        return this._has(DataComponents.CAN_BREAK);
    }

    @ZenCodeType.Getter(value="canBreak")
    default public AdventureModePredicate getCanBreak() {
        return (AdventureModePredicate)this._get(DataComponents.CAN_BREAK);
    }

    @ZenCodeType.Method
    default public T withCanBreak(List<BlockPredicate> predicates, @ZenCodeType.OptionalBoolean(value=true) boolean showInTooltip) {
        return this.withCanBreak(new AdventureModePredicate(predicates, showInTooltip));
    }

    @ZenCodeType.Method
    default public T withCanBreak(AdventureModePredicate predicate) {
        return this._with(DataComponents.CAN_BREAK, predicate);
    }

    @ZenCodeType.Method
    default public T withoutCanBreak() {
        return this._without(DataComponents.CAN_BREAK);
    }

    @ZenCodeType.Getter(value="hasAttributeModifiers")
    default public boolean hasAttributeModifiers() {
        return this._has(DataComponents.ATTRIBUTE_MODIFIERS);
    }

    @ZenCodeType.Getter(value="attributeModifiers")
    default public ItemAttributeModifiers getAttributeModifiers() {
        return (ItemAttributeModifiers)this._get(DataComponents.ATTRIBUTE_MODIFIERS);
    }

    @ZenCodeType.Method
    default public T withAttributeModifiers(ItemAttributeModifiers modifiers) {
        return this._with(DataComponents.ATTRIBUTE_MODIFIERS, modifiers);
    }

    @ZenCodeType.Method
    default public T withAttributeModifiers(ItemAttributeModifiers.Entry modifier, @ZenCodeType.OptionalBoolean(value=true) boolean showInTooltip) {
        return this._with(DataComponents.ATTRIBUTE_MODIFIERS, new ItemAttributeModifiers(List.of(modifier), showInTooltip));
    }

    @ZenCodeType.Method
    default public T withAttributeModifiers(List<ItemAttributeModifiers.Entry> modifiers, @ZenCodeType.OptionalBoolean(value=true) boolean showInTooltip) {
        return this._with(DataComponents.ATTRIBUTE_MODIFIERS, new ItemAttributeModifiers(modifiers, showInTooltip));
    }

    @ZenCodeType.Method
    default public T withoutAttributeModifiers() {
        return this._without(DataComponents.ATTRIBUTE_MODIFIERS);
    }

    @ZenCodeType.Getter(value="hasCustomModelData")
    default public boolean hasCustomModelData() {
        return this._has(DataComponents.CUSTOM_MODEL_DATA);
    }

    @ZenCodeType.Getter(value="customModelData")
    default public CustomModelData getCustomModelData() {
        return (CustomModelData)this._get(DataComponents.CUSTOM_MODEL_DATA);
    }

    @ZenCodeType.Method
    default public T withCustomModelData(int value) {
        return this.withCustomModelData(new CustomModelData(value));
    }

    @ZenCodeType.Method
    default public T withCustomModelData(CustomModelData data) {
        return this._with(DataComponents.CUSTOM_MODEL_DATA, data);
    }

    @ZenCodeType.Method
    default public T withoutCustomModelData() {
        return this._without(DataComponents.CUSTOM_MODEL_DATA);
    }

    @ZenCodeType.Getter(value="hideAdditionalTooltip")
    default public boolean hideAdditionalTooltip() {
        return this._has(DataComponents.HIDE_ADDITIONAL_TOOLTIP);
    }

    @ZenCodeType.Method
    default public T withHideAdditionalTooltip() {
        return this._with(DataComponents.HIDE_ADDITIONAL_TOOLTIP, Unit.INSTANCE);
    }

    @ZenCodeType.Method
    default public T withoutHideAdditionalTooltip() {
        return this._without(DataComponents.HIDE_ADDITIONAL_TOOLTIP);
    }

    @ZenCodeType.Getter(value="hideTooltip")
    default public boolean hideTooltip() {
        return this._has(DataComponents.HIDE_TOOLTIP);
    }

    @ZenCodeType.Method
    default public T withHideTooltip() {
        return this._with(DataComponents.HIDE_TOOLTIP, Unit.INSTANCE);
    }

    @ZenCodeType.Method
    default public T withoutHideTooltip() {
        return this._without(DataComponents.HIDE_TOOLTIP);
    }

    @ZenCodeType.Getter(value="hasRepairCost")
    default public boolean hasRepairCost() {
        return this._has(DataComponents.REPAIR_COST);
    }

    @ZenCodeType.Getter(value="repairCost")
    default public int repairCost() {
        return (Integer)this._get(DataComponents.REPAIR_COST);
    }

    @ZenCodeType.Method
    default public T withRepairCost(int cost) {
        return this._with(DataComponents.REPAIR_COST, cost);
    }

    @ZenCodeType.Method
    default public T withoutRepairCost() {
        return this._without(DataComponents.REPAIR_COST);
    }

    @ZenCodeType.Getter(value="creativeSlotLock")
    default public boolean creativeSlotLock() {
        return this._has(DataComponents.CREATIVE_SLOT_LOCK);
    }

    @ZenCodeType.Method
    default public T withCreativeSlotLock() {
        return this._with(DataComponents.CREATIVE_SLOT_LOCK, Unit.INSTANCE);
    }

    @ZenCodeType.Method
    default public T withoutCreativeSlotLock() {
        return this._without(DataComponents.CREATIVE_SLOT_LOCK);
    }

    @ZenCodeType.Getter(value="hasEnchantmentGlintOverride")
    default public boolean hasEnchantmentGlintOverride() {
        return this._has(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
    }

    @ZenCodeType.Getter(value="enchantmentGlintOverride")
    default public boolean getEnchantmentGlintOverride() {
        return (Boolean)this._get(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
    }

    @ZenCodeType.Method
    default public T withEnchantmentGlintOverride(boolean value) {
        return this._with(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, value);
    }

    @ZenCodeType.Method
    default public T withoutEnchantmentGlintOverride() {
        return this._without(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
    }

    @ZenCodeType.Getter(value="isIntangibleProjectile")
    default public boolean isIntangibleProjectile() {
        return this._has(DataComponents.INTANGIBLE_PROJECTILE);
    }

    @ZenCodeType.Method
    default public T withIntangibleProjectile() {
        return this._with(DataComponents.INTANGIBLE_PROJECTILE, Unit.INSTANCE);
    }

    @ZenCodeType.Method
    default public T withoutIntangibleProjectile() {
        return this._without(DataComponents.INTANGIBLE_PROJECTILE);
    }

    @ZenCodeType.Getter(value="hasFood")
    default public boolean hasFood() {
        return this._has(DataComponents.FOOD);
    }

    @ZenCodeType.Getter(value="food")
    default public FoodProperties getFood() {
        return (FoodProperties)this._get(DataComponents.FOOD);
    }

    @ZenCodeType.Method
    default public T withFood(FoodProperties food) {
        return this._with(DataComponents.FOOD, food);
    }

    @ZenCodeType.Method
    default public T withoutFood() {
        return this._without(DataComponents.FOOD);
    }

    @ZenCodeType.Getter(value="isFireResistant")
    default public boolean isFireResistant() {
        return this._has(DataComponents.FIRE_RESISTANT);
    }

    @ZenCodeType.Method
    default public T withFireResistant() {
        return this._with(DataComponents.FIRE_RESISTANT, Unit.INSTANCE);
    }

    @ZenCodeType.Method
    default public T withoutFireResistant() {
        return this._without(DataComponents.FIRE_RESISTANT);
    }

    @ZenCodeType.Getter(value="hasTool")
    default public boolean hasTool() {
        return this._has(DataComponents.TOOL);
    }

    @ZenCodeType.Getter(value="tool")
    default public Tool getTool() {
        return (Tool)this._get(DataComponents.TOOL);
    }

    @ZenCodeType.Method
    default public T withTool(List<Tool.Rule> rules, float defaultMiningSpeed, int damagePerBlock) {
        return this.withTool(new Tool(rules, defaultMiningSpeed, damagePerBlock));
    }

    @ZenCodeType.Method
    default public T withTool(Tool tool) {
        return this._with(DataComponents.TOOL, tool);
    }

    @ZenCodeType.Method
    default public T withoutTool() {
        return this._without(DataComponents.TOOL);
    }

    @ZenCodeType.Getter(value="hasStoredEnchantments")
    default public boolean hasStoredEnchantments() {
        return this._has(DataComponents.STORED_ENCHANTMENTS);
    }

    @ZenCodeType.Getter(value="storedEnchantments")
    default public ItemEnchantments getStoredEnchantments() {
        return (ItemEnchantments)this._get(DataComponents.STORED_ENCHANTMENTS);
    }

    @ZenCodeType.Method
    default public T withStoredEnchantments(ItemEnchantments enchantments) {
        return this._with(DataComponents.STORED_ENCHANTMENTS, enchantments);
    }

    @ZenCodeType.Method
    default public T withoutStoredEnchantments() {
        return this._without(DataComponents.STORED_ENCHANTMENTS);
    }

    @ZenCodeType.Getter(value="hasDyedColor")
    default public boolean hasDyedColor() {
        return this._has(DataComponents.DYED_COLOR);
    }

    @ZenCodeType.Getter(value="dyedColor")
    default public DyedItemColor getDyedColor() {
        return (DyedItemColor)this._get(DataComponents.DYED_COLOR);
    }

    @ZenCodeType.Method
    default public T withDyedColor(int rgb, @ZenCodeType.OptionalBoolean(value=true) boolean showInTooltip) {
        return this.withDyedColor(new DyedItemColor(rgb, showInTooltip));
    }

    @ZenCodeType.Method
    default public T withDyedColor(DyedItemColor color) {
        return this._with(DataComponents.DYED_COLOR, color);
    }

    @ZenCodeType.Method
    default public T withoutDyedColor() {
        return this._without(DataComponents.DYED_COLOR);
    }

    @ZenCodeType.Getter(value="hasMapColor")
    default public boolean hasMapColor() {
        return this._has(DataComponents.MAP_COLOR);
    }

    @ZenCodeType.Getter(value="mapColor")
    default public MapItemColor getMapColor() {
        return (MapItemColor)this._get(DataComponents.MAP_COLOR);
    }

    @ZenCodeType.Method
    default public T withMapColor(int rgb) {
        return this.withMapColor(new MapItemColor(rgb));
    }

    @ZenCodeType.Method
    default public T withMapColor(MapItemColor color) {
        return this._with(DataComponents.MAP_COLOR, color);
    }

    @ZenCodeType.Method
    default public T withoutMapColor() {
        return this._without(DataComponents.MAP_COLOR);
    }

    @ZenCodeType.Getter(value="hasMapId")
    default public boolean hasMapId() {
        return this._has(DataComponents.MAP_ID);
    }

    @ZenCodeType.Getter(value="mapId")
    default public MapId getMapId() {
        return (MapId)this._get(DataComponents.MAP_ID);
    }

    @ZenCodeType.Method
    default public T withMapId(int id) {
        return this.withMapId(new MapId(id));
    }

    @ZenCodeType.Method
    default public T withMapId(MapId mapId) {
        return this._with(DataComponents.MAP_ID, mapId);
    }

    @ZenCodeType.Method
    default public T withoutMapId() {
        return this._without(DataComponents.MAP_ID);
    }

    @ZenCodeType.Getter(value="hasMapDecorations")
    default public boolean hasMapDecorations() {
        return this._has(DataComponents.MAP_DECORATIONS);
    }

    @ZenCodeType.Getter(value="mapDecorations")
    default public MapDecorations getMapDecorations() {
        return (MapDecorations)this._get(DataComponents.MAP_DECORATIONS);
    }

    @ZenCodeType.Method
    default public T withMapDecorations(Map<String, MapDecorations.Entry> decorations) {
        return this.withMapDecorations(new MapDecorations(decorations));
    }

    @ZenCodeType.Method
    default public T withMapDecorations(MapDecorations decorations) {
        return this._with(DataComponents.MAP_DECORATIONS, decorations);
    }

    @ZenCodeType.Method
    default public T withoutMapDecorations() {
        return this._without(DataComponents.MAP_DECORATIONS);
    }

    @ZenCodeType.Getter(value="hasMapPostProcessing")
    default public boolean hasMapPostProcessing() {
        return this._has(DataComponents.MAP_POST_PROCESSING);
    }

    @ZenCodeType.Getter(value="mapPostProcessing")
    default public MapPostProcessing getMapPostProcessing() {
        return (MapPostProcessing)this._get(DataComponents.MAP_POST_PROCESSING);
    }

    @ZenCodeType.Method
    default public T withMapPostProcessing(MapPostProcessing value) {
        return this._with(DataComponents.MAP_POST_PROCESSING, value);
    }

    @ZenCodeType.Method
    default public T withoutMapPostProcessing() {
        return this._without(DataComponents.MAP_POST_PROCESSING);
    }

    @ZenCodeType.Getter(value="hasChargedProjectiles")
    default public boolean hasChargedProjectiles() {
        return this._has(DataComponents.CHARGED_PROJECTILES);
    }

    @ZenCodeType.Getter(value="chargedProjectiles")
    default public ChargedProjectiles getChargedProjectiles() {
        return (ChargedProjectiles)this._get(DataComponents.CHARGED_PROJECTILES);
    }

    @ZenCodeType.Method
    default public T withChargedProjectiles(IItemStack item) {
        return this.withChargedProjectiles(ChargedProjectiles.of((ItemStack)item.getInternal()));
    }

    @ZenCodeType.Method
    default public T withChargedProjectiles(List<IItemStack> items) {
        return this.withChargedProjectiles(ChargedProjectiles.of((List)Lists.transform(items, IItemStack::getInternal)));
    }

    @ZenCodeType.Method
    default public T withChargedProjectiles(ChargedProjectiles chargedProjectiles) {
        return this._with(DataComponents.CHARGED_PROJECTILES, chargedProjectiles);
    }

    @ZenCodeType.Method
    default public T withoutChargedProjectiles() {
        return this._without(DataComponents.CHARGED_PROJECTILES);
    }

    @ZenCodeType.Getter(value="hasBundleContents")
    default public boolean hasBundleContents() {
        return this._has(DataComponents.BUNDLE_CONTENTS);
    }

    @ZenCodeType.Getter(value="bundleContents")
    default public BundleContents getBundleContents() {
        return (BundleContents)this._get(DataComponents.BUNDLE_CONTENTS);
    }

    @ZenCodeType.Method
    default public T withBundleContents(List<IItemStack> contents) {
        return this._with(DataComponents.BUNDLE_CONTENTS, new BundleContents(Lists.transform(contents, IItemStack::getInternal)));
    }

    @ZenCodeType.Method
    default public T withBundleContents(BundleContents contents) {
        return this._with(DataComponents.BUNDLE_CONTENTS, contents);
    }

    @ZenCodeType.Method
    default public T withoutBundleContents() {
        return this._without(DataComponents.BUNDLE_CONTENTS);
    }

    @ZenCodeType.Getter(value="hasPotionContents")
    default public boolean hasPotionContents() {
        return this._has(DataComponents.POTION_CONTENTS);
    }

    @ZenCodeType.Getter(value="potionContents")
    default public PotionContents getPotionContents() {
        return (PotionContents)this._get(DataComponents.POTION_CONTENTS);
    }

    @ZenCodeType.Method
    default public T withPotionContents(Potion potion) {
        return this.withPotionContents(new PotionContents(Services.REGISTRY.holderOrThrow(Registries.POTION, potion)));
    }

    @ZenCodeType.Method
    default public T withPotionContents(Potion potion, List<MobEffectInstance> customEffects) {
        return this.withPotionContents(new PotionContents(Optional.of(Services.REGISTRY.holderOrThrow(Registries.POTION, potion)), Optional.empty(), customEffects));
    }

    @ZenCodeType.Method
    default public T withPotionContents(Potion potion, int customColor, List<MobEffectInstance> customEffects) {
        return this.withPotionContents(new PotionContents(Optional.of(Services.REGISTRY.holderOrThrow(Registries.POTION, potion)), Optional.of(customColor), customEffects));
    }

    @ZenCodeType.Method
    default public T withPotionContents(PotionContents contents) {
        return this._with(DataComponents.POTION_CONTENTS, contents);
    }

    @ZenCodeType.Method
    default public T withoutPotionContents() {
        return this._without(DataComponents.POTION_CONTENTS);
    }

    @ZenCodeType.Getter(value="hasSuspiciousStewEffects")
    default public boolean hasSuspiciousStewEffects() {
        return this._has(DataComponents.SUSPICIOUS_STEW_EFFECTS);
    }

    @ZenCodeType.Getter(value="suspiciousStewEffects")
    default public SuspiciousStewEffects getSuspiciousStewEffects() {
        return (SuspiciousStewEffects)this._get(DataComponents.SUSPICIOUS_STEW_EFFECTS);
    }

    @ZenCodeType.Method
    default public T withSuspiciousStewEffects(List<SuspiciousStewEffects.Entry> effects) {
        return this.withSuspiciousStewEffects(new SuspiciousStewEffects(effects));
    }

    @ZenCodeType.Method
    default public T withSuspiciousStewEffects(SuspiciousStewEffects suspiciousStewEffects) {
        return this._with(DataComponents.SUSPICIOUS_STEW_EFFECTS, suspiciousStewEffects);
    }

    @ZenCodeType.Method
    default public T withoutSuspiciousStewEffects() {
        return this._without(DataComponents.SUSPICIOUS_STEW_EFFECTS);
    }

    @ZenCodeType.Getter(value="hasWritableBookContent")
    default public boolean hasWritableBookContent() {
        return this._has(DataComponents.WRITABLE_BOOK_CONTENT);
    }

    @ZenCodeType.Getter(value="writableBookContent")
    default public WritableBookContent getWritableBookContent() {
        return (WritableBookContent)this._get(DataComponents.WRITABLE_BOOK_CONTENT);
    }

    @ZenCodeType.Method
    default public T withWritableBookContent(List<Filterable<String>> pages) {
        return this.withWritableBookContent(new WritableBookContent(pages));
    }

    @ZenCodeType.Method
    default public T withWritableBookContent(WritableBookContent content) {
        return this._with(DataComponents.WRITABLE_BOOK_CONTENT, content);
    }

    @ZenCodeType.Method
    default public T withoutWritableBookContent() {
        return this._without(DataComponents.WRITABLE_BOOK_CONTENT);
    }

    @ZenCodeType.Getter(value="hasWrittenBookContent")
    default public boolean hasWrittenBookContent() {
        return this._has(DataComponents.WRITABLE_BOOK_CONTENT);
    }

    @ZenCodeType.Getter(value="writtenBookContent")
    default public WrittenBookContent getWrittenBookContent() {
        return (WrittenBookContent)this._get(DataComponents.WRITTEN_BOOK_CONTENT);
    }

    @ZenCodeType.Method
    default public T withWrittenBookContent(WrittenBookContent content) {
        return this._with(DataComponents.WRITTEN_BOOK_CONTENT, content);
    }

    @ZenCodeType.Method
    default public T withoutWrittenBookContent() {
        return this._without(DataComponents.WRITTEN_BOOK_CONTENT);
    }

    @ZenCodeType.Getter(value="hasTrim")
    default public boolean hasTrim() {
        return this._has(DataComponents.TRIM);
    }

    @ZenCodeType.Getter(value="trim")
    default public ArmorTrim getTrim() {
        return (ArmorTrim)this._get(DataComponents.TRIM);
    }

    @ZenCodeType.Method
    default public T withTrim(ArmorTrim trim) {
        return this._with(DataComponents.TRIM, trim);
    }

    @ZenCodeType.Method
    default public T withoutTrim() {
        return this._without(DataComponents.TRIM);
    }

    @ZenCodeType.Getter(value="hasDebugStickState")
    default public boolean hasDebugStickState() {
        return this._has(DataComponents.DEBUG_STICK_STATE);
    }

    @ZenCodeType.Getter(value="debugStickState")
    default public DebugStickState getDebugStickState() {
        return (DebugStickState)this._get(DataComponents.DEBUG_STICK_STATE);
    }

    @ZenCodeType.Method
    default public T withDebugStickState(DebugStickState state) {
        return this._with(DataComponents.DEBUG_STICK_STATE, state);
    }

    @ZenCodeType.Method
    default public T withoutDebugStickState() {
        return this._without(DataComponents.DEBUG_STICK_STATE);
    }

    @ZenCodeType.Getter(value="hasEntityData")
    default public boolean hasEntityData() {
        return this._has(DataComponents.ENTITY_DATA);
    }

    @ZenCodeType.Getter(value="entityData")
    default public CustomData getEntityData() {
        return (CustomData)this._get(DataComponents.ENTITY_DATA);
    }

    @ZenCodeType.Method
    default public T withEntityData(MapData data) {
        return this.withEntityData(CustomData.of((CompoundTag)data.getInternal()));
    }

    @ZenCodeType.Method
    default public T withEntityData(CustomData data) {
        return this._with(DataComponents.ENTITY_DATA, data);
    }

    @ZenCodeType.Method
    default public T withoutEntityDate() {
        return this._without(DataComponents.ENTITY_DATA);
    }

    @ZenCodeType.Getter(value="hasBucketEntityData")
    default public boolean hasBucketEntityData() {
        return this._has(DataComponents.BUCKET_ENTITY_DATA);
    }

    @ZenCodeType.Getter(value="bucketEntityData")
    default public CustomData getBucketEntityData() {
        return (CustomData)this._get(DataComponents.BUCKET_ENTITY_DATA);
    }

    @ZenCodeType.Method
    default public T withBucketEntityData(MapData data) {
        return this.withBucketEntityData(CustomData.of((CompoundTag)data.getInternal()));
    }

    @ZenCodeType.Method
    default public T withBucketEntityData(CustomData data) {
        return this._with(DataComponents.BUCKET_ENTITY_DATA, data);
    }

    @ZenCodeType.Method
    default public T withoutBucketEntityData() {
        return this._without(DataComponents.BUCKET_ENTITY_DATA);
    }

    @ZenCodeType.Getter(value="hasBlockEntityData")
    default public boolean hasBlockEntityData() {
        return this._has(DataComponents.BLOCK_ENTITY_DATA);
    }

    @ZenCodeType.Getter(value="blockEntityData")
    default public CustomData getBlockEntityData() {
        return (CustomData)this._get(DataComponents.BLOCK_ENTITY_DATA);
    }

    @ZenCodeType.Method
    default public T withBlockEntityData(MapData data) {
        return this.withBlockEntityData(CustomData.of((CompoundTag)data.getInternal()));
    }

    @ZenCodeType.Method
    default public T withBlockEntityData(CustomData data) {
        return this._with(DataComponents.BLOCK_ENTITY_DATA, data);
    }

    @ZenCodeType.Method
    default public T withoutBlockEntityData() {
        return this._without(DataComponents.BLOCK_ENTITY_DATA);
    }

    @ZenCodeType.Getter(value="hasInstrument")
    default public boolean hasInstrument() {
        return this._has(DataComponents.INSTRUMENT);
    }

    @ZenCodeType.Getter(value="instrument")
    default public Instrument getInstrument() {
        return (Instrument)((Holder)this._get(DataComponents.INSTRUMENT)).value();
    }

    @ZenCodeType.Method
    default public T withInstrument(Instrument instrument) {
        return this._with(DataComponents.INSTRUMENT, Services.REGISTRY.holderOrThrow(Registries.INSTRUMENT, instrument));
    }

    @ZenCodeType.Method
    default public T withoutInstrument() {
        return this._without(DataComponents.INSTRUMENT);
    }

    @ZenCodeType.Getter(value="hasOminousBottleAmplifier")
    default public boolean hasOminousBottleAmplifier() {
        return this._has(DataComponents.OMINOUS_BOTTLE_AMPLIFIER);
    }

    @ZenCodeType.Getter(value="ominousBottleAmplifier")
    default public int getOminousBottleAmplifier() {
        return (Integer)this._get(DataComponents.OMINOUS_BOTTLE_AMPLIFIER);
    }

    @ZenCodeType.Method
    default public T withOminousBottleAmplifier(int amplifier) {
        return this._with(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, amplifier);
    }

    @ZenCodeType.Method
    default public T withoutOminousBottleAmplifier() {
        return this._without(DataComponents.OMINOUS_BOTTLE_AMPLIFIER);
    }

    @ZenCodeType.Getter(value="hasRecipes")
    default public boolean hasRecipes() {
        return this._has(DataComponents.RECIPES);
    }

    @ZenCodeType.Getter(value="recipes")
    default public List<ResourceLocation> getRecipes() {
        return (List)this._get(DataComponents.RECIPES);
    }

    @ZenCodeType.Method
    default public T withRecipes(List<ResourceLocation> recipes) {
        return this._with(DataComponents.RECIPES, recipes);
    }

    @ZenCodeType.Method
    default public T withoutRecipes() {
        return this._without(DataComponents.RECIPES);
    }

    @ZenCodeType.Getter(value="hasLodestoneTracker")
    default public boolean hasLodestoneTracker() {
        return this._has(DataComponents.LODESTONE_TRACKER);
    }

    @ZenCodeType.Getter(value="lodestoneTracker")
    default public LodestoneTracker getLodestoneTracker() {
        return (LodestoneTracker)this._get(DataComponents.LODESTONE_TRACKER);
    }

    @ZenCodeType.Method
    default public T withLodestoneTracker(LodestoneTracker tracker) {
        return this._with(DataComponents.LODESTONE_TRACKER, tracker);
    }

    @ZenCodeType.Method
    default public T withoutLodestoneTracker() {
        return this._without(DataComponents.LODESTONE_TRACKER);
    }

    @ZenCodeType.Getter(value="hasFireworkExplosion")
    default public boolean hasFireworkExplosion() {
        return this._has(DataComponents.FIREWORK_EXPLOSION);
    }

    @ZenCodeType.Getter(value="fireworkExplosion")
    default public FireworkExplosion getFireworkExplosion() {
        return (FireworkExplosion)this._get(DataComponents.FIREWORK_EXPLOSION);
    }

    @ZenCodeType.Method
    default public T withFireworkExplosion(FireworkExplosion explosion) {
        return this._with(DataComponents.FIREWORK_EXPLOSION, explosion);
    }

    @ZenCodeType.Method
    default public T withoutFireworkExplosion() {
        return this._without(DataComponents.FIREWORK_EXPLOSION);
    }

    @ZenCodeType.Getter(value="hasFireworks")
    default public boolean hasFireworks() {
        return this._has(DataComponents.FIREWORKS);
    }

    @ZenCodeType.Getter(value="fireworks")
    default public Fireworks getFireworks() {
        return (Fireworks)this._get(DataComponents.FIREWORKS);
    }

    @ZenCodeType.Method
    default public T withFireworks(int flightDuration, List<FireworkExplosion> explosions) {
        return this.withFireworks(new Fireworks(flightDuration, explosions));
    }

    @ZenCodeType.Method
    default public T withFireworks(Fireworks fireworks) {
        return this._with(DataComponents.FIREWORKS, fireworks);
    }

    @ZenCodeType.Method
    default public T withoutFireworks() {
        return this._without(DataComponents.FIREWORKS);
    }

    @ZenCodeType.Getter(value="hasProfile")
    default public boolean hasProfile() {
        return this._has(DataComponents.PROFILE);
    }

    @ZenCodeType.Getter(value="profile")
    default public ResolvableProfile getProfile() {
        return (ResolvableProfile)this._get(DataComponents.PROFILE);
    }

    @ZenCodeType.Method
    default public T withProfile(ResolvableProfile profile) {
        return this._with(DataComponents.PROFILE, profile);
    }

    @ZenCodeType.Method
    default public T withoutProfile() {
        return this._without(DataComponents.PROFILE);
    }

    @ZenCodeType.Getter(value="hasNoteBlockSound")
    default public boolean hasNoteBlockSound() {
        return this._has(DataComponents.NOTE_BLOCK_SOUND);
    }

    @ZenCodeType.Getter(value="noteBlockSound")
    default public ResourceLocation getNoteBlockSound() {
        return (ResourceLocation)this._get(DataComponents.NOTE_BLOCK_SOUND);
    }

    @ZenCodeType.Method
    default public T withNoteBlockSound(ResourceLocation sound) {
        return this._with(DataComponents.NOTE_BLOCK_SOUND, sound);
    }

    @ZenCodeType.Method
    default public T withoutNoteBlockSound() {
        return this._without(DataComponents.NOTE_BLOCK_SOUND);
    }

    @ZenCodeType.Getter(value="hasBannerPatterns")
    default public boolean hasBannerPatterns() {
        return this._has(DataComponents.BANNER_PATTERNS);
    }

    @ZenCodeType.Getter(value="bannerPatterns")
    default public BannerPatternLayers getBannerPatterns() {
        return (BannerPatternLayers)this._get(DataComponents.BANNER_PATTERNS);
    }

    @ZenCodeType.Method
    default public T withBannerPatterns(List<BannerPatternLayers.Layer> layers) {
        return this.withBannerPatterns(new BannerPatternLayers(layers));
    }

    @ZenCodeType.Method
    default public T withBannerPatterns(BannerPatternLayers layers) {
        return this._with(DataComponents.BANNER_PATTERNS, layers);
    }

    @ZenCodeType.Method
    default public T withoutBannerPatterns() {
        return this._without(DataComponents.BANNER_PATTERNS);
    }

    @ZenCodeType.Getter(value="hasBaseColor")
    default public boolean hasBaseColor() {
        return this._has(DataComponents.BASE_COLOR);
    }

    @ZenCodeType.Getter(value="baseColor")
    default public DyeColor getBaseColor() {
        return (DyeColor)this._get(DataComponents.BASE_COLOR);
    }

    @ZenCodeType.Method
    default public T withBaseColor(DyeColor color) {
        return this._with(DataComponents.BASE_COLOR, color);
    }

    @ZenCodeType.Method
    default public T withoutBaseColor() {
        return this._without(DataComponents.BASE_COLOR);
    }

    @ZenCodeType.Getter(value="hasPotDecorations")
    default public boolean hasPotDecorations() {
        return this._has(DataComponents.POT_DECORATIONS);
    }

    @ZenCodeType.Getter(value="potDecorations")
    default public PotDecorations getPotDecorations() {
        return (PotDecorations)this._get(DataComponents.POT_DECORATIONS);
    }

    @ZenCodeType.Method
    default public T withPotDecorations(Item back, Item left, Item right, Item front) {
        return this.withPotDecorations(new PotDecorations(back, left, right, front));
    }

    @ZenCodeType.Method
    default public T withPotDecorations(PotDecorations decorations) {
        return this._with(DataComponents.POT_DECORATIONS, decorations);
    }

    @ZenCodeType.Method
    default public T withoutPotDecorations() {
        return this._without(DataComponents.POT_DECORATIONS);
    }

    @ZenCodeType.Getter(value="hasContainer")
    default public boolean hasContainer() {
        return this._has(DataComponents.CONTAINER);
    }

    @ZenCodeType.Getter(value="container")
    default public ItemContainerContents getContainer() {
        return (ItemContainerContents)this._get(DataComponents.CONTAINER);
    }

    @ZenCodeType.Method
    default public T withContainer(List<IItemStack> contents) {
        return this.withContainer(ItemContainerContents.fromItems((List)Lists.transform(contents, IItemStack::getInternal)));
    }

    @ZenCodeType.Method
    default public T withContainer(ItemContainerContents contents) {
        return this._with(DataComponents.CONTAINER, contents);
    }

    @ZenCodeType.Method
    default public T withoutContainer() {
        return this._without(DataComponents.CONTAINER);
    }

    @ZenCodeType.Getter(value="hasBlockState")
    default public boolean hasBlockState() {
        return this._has(DataComponents.BLOCK_STATE);
    }

    @ZenCodeType.Getter(value="blockState")
    default public BlockItemStateProperties getBlockState() {
        return (BlockItemStateProperties)this._get(DataComponents.BLOCK_STATE);
    }

    @ZenCodeType.Method
    default public T withBlockState(BlockItemStateProperties properties) {
        return this._with(DataComponents.BLOCK_STATE, properties);
    }

    @ZenCodeType.Method
    default public T withoutBlockState() {
        return this._without(DataComponents.BLOCK_STATE);
    }

    @ZenCodeType.Getter(value="hasBees")
    default public boolean hasBees() {
        return this._has(DataComponents.BEES);
    }

    @ZenCodeType.Getter(value="bees")
    default public List<BeehiveBlockEntity.Occupant> getBees() {
        return (List)this._get(DataComponents.BEES);
    }

    @ZenCodeType.Method
    default public T withBees(List<BeehiveBlockEntity.Occupant> occupants) {
        return this._with(DataComponents.BEES, occupants);
    }

    @ZenCodeType.Method
    default public T withoutBees() {
        return this._without(DataComponents.BEES);
    }

    @ZenCodeType.Getter(value="hasLock")
    default public boolean hasLock() {
        return this._has(DataComponents.LOCK);
    }

    @ZenCodeType.Getter(value="lockComponent")
    default public LockCode getLock() {
        return (LockCode)this._get(DataComponents.LOCK);
    }

    @ZenCodeType.Method
    default public T withLock(String code) {
        return this.withLock(new LockCode(code));
    }

    @ZenCodeType.Method
    default public T withLock(LockCode lock) {
        return this._with(DataComponents.LOCK, lock);
    }

    @ZenCodeType.Method
    default public T withoutLock() {
        return this._without(DataComponents.LOCK);
    }

    @ZenCodeType.Getter(value="hasContainerLoot")
    default public boolean hasContainerLoot() {
        return this._has(DataComponents.CONTAINER_LOOT);
    }

    @ZenCodeType.Getter(value="containerLoot")
    default public SeededContainerLoot getContainerLoot() {
        return (SeededContainerLoot)this._get(DataComponents.CONTAINER_LOOT);
    }

    @ZenCodeType.Method
    default public T withContainerLoot(ResourceKey<LootTable> lootTable, long seed) {
        return this.withContainerLoot(new SeededContainerLoot(lootTable, seed));
    }

    @ZenCodeType.Method
    default public T withContainerLoot(SeededContainerLoot loot) {
        return this._with(DataComponents.CONTAINER_LOOT, loot);
    }

    @ZenCodeType.Method
    default public T withoutContainerLoot() {
        return this._without(DataComponents.CONTAINER_LOOT);
    }

    public <U> U _get(DataComponentType<? extends U> var1);

    public <U> T _with(DataComponentType<U> var1, @Nullable U var2);

    public <U> T _without(DataComponentType<U> var1);

    public <U> boolean _has(DataComponentType<U> var1);
}

