/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.condition.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.api.ingredient.transformer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.mixin.common.access.registry.AccessMappedRegistry;
import com.blamejared.crafttweaker.platform.Services;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class CraftTweakerRegistries {
    public static Registry<IIngredientTransformerSerializer<?>> TRANSFORMER_SERIALIZER = Services.REGISTRY.makeRegistry(Keys.TRANSFORMER_SERIALIZER);
    public static Registry<IIngredientConditionSerializer<?>> CONDITIONER_SERIALIZER = Services.REGISTRY.makeRegistry(Keys.CONDITIONER_SERIALIZER);

    public static void init() {
        Registry registry = BuiltInRegistries.REGISTRY;
        if (!(registry instanceof AccessMappedRegistry)) {
            throw new IllegalStateException("Unable to create new registries! Expected REGISTRY to be mapped, but was: '" + String.valueOf(BuiltInRegistries.REGISTRY.getClass()) + "'");
        }
        AccessMappedRegistry registry2 = (AccessMappedRegistry)registry;
        boolean wasFrozen = registry2.crafttweaker$isFrozen();
        registry2.crafttweaker$setFrozen(false);
        CraftTweakerRegistries.registerRegistry(TRANSFORMER_SERIALIZER);
        CraftTweakerRegistries.registerRegistry(CONDITIONER_SERIALIZER);
        registry2.crafttweaker$setFrozen(wasFrozen);
    }

    private static <T> Registry<T> registerRegistry(Registry<T> mappedReg) {
        WritableRegistry registry = (WritableRegistry)BuiltInRegistries.REGISTRY;
        registry.register(mappedReg.key(), mappedReg, RegistrationInfo.BUILT_IN);
        return mappedReg;
    }

    public static class Keys {
        public static ResourceKey<Registry<IIngredientTransformerSerializer<?>>> TRANSFORMER_SERIALIZER = ResourceKey.createRegistryKey((ResourceLocation)CraftTweakerConstants.rl("transformer_serializer"));
        public static ResourceKey<Registry<IIngredientConditionSerializer<?>>> CONDITIONER_SERIALIZER = ResourceKey.createRegistryKey((ResourceLocation)CraftTweakerConstants.rl("condition_serializer"));
    }
}

