/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.unusual.blockfactorysbosses.FrozenFistItemRenderer;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModItems;
import net.unusual.blockfactorysbosses.procedures.FrozenFistLivingEntityIsHitWithToolProcedure;
import net.unusual.blockfactorysbosses.procedures.FrozenFistRightclickedOnBlockProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class FrozenFistItem
extends ShieldItem {
    public static final Map<String, AnimationState> IDLE_STATES = new WeakHashMap<String, AnimationState>();
    public static final Map<String, AnimationState> SWING_STATES = new WeakHashMap<String, AnimationState>();
    public static final Map<ItemStack, Integer> IS_MINING = new WeakHashMap<ItemStack, Integer>();

    public FrozenFistItem() {
        super(new Item.Properties().durability(380).rarity(Rarity.UNCOMMON));
    }

    public int getBarColor(ItemStack stack) {
        return 52479;
    }

    public boolean isValidRepairItem(ItemStack itemstack, ItemStack repairitem) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.ICE), new ItemStack((ItemLike)Blocks.PACKED_ICE), new ItemStack((ItemLike)Blocks.BLUE_ICE)}).test(repairitem);
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        FrozenFistLivingEntityIsHitWithToolProcedure.execute((LevelAccessor)entity.level(), (Entity)entity);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.block_factorys_bosses.frozen_fist.description_0"));
        list.add((Component)Component.translatable((String)"item.block_factorys_bosses.frozen_fist.description_1"));
        list.add((Component)Component.translatable((String)"item.block_factorys_bosses.frozen_fist.description_2"));
        list.add((Component)Component.translatable((String)"item.block_factorys_bosses.frozen_fist.description_3"));
        list.add((Component)Component.translatable((String)"item.block_factorys_bosses.frozen_fist.description_4"));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        double swing_animtime;
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("itemKey").isEmpty()) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putString("itemKey", UUID.randomUUID().toString()));
        }
        String key = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("itemKey");
        int is_mining = IS_MINING.computeIfAbsent(itemstack, s -> 0);
        if (is_mining > 0) {
            IS_MINING.put(itemstack, is_mining - 1);
        }
        if ((swing_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime")) > 0.0) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putDouble("swing_animtime", ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime") - 1.0));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState blockstate) {
        IS_MINING.put(itemstack, 5);
        if (((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime") == 0.0) {
            return 1.0f;
        }
        return 0.0f;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        double swing_animtime;
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        int is_mining = IS_MINING.computeIfAbsent(itemstack, s -> 0);
        if (is_mining == 0 && (swing_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime")) == 0.0 && entity instanceof Player) {
            Player plr = (Player)entity;
            this.playSound(plr, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:frozen_fist")));
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putString("itemKey", UUID.randomUUID().toString()));
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putDouble("swing_animtime", 18.0));
        }
        return retval;
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        if (context.getPlayer().isShiftKeyDown()) {
            FrozenFistRightclickedOnBlockProcedure.execute((LevelAccessor)context.getLevel(), context.getClickedPos().getX(), context.getClickedPos().getY(), context.getClickedPos().getZ(), (Entity)context.getPlayer(), context.getItemInHand());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private FrozenFistItemRenderer rendererInstance;

            @OnlyIn(value=Dist.CLIENT)
            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                int is_mining = IS_MINING.computeIfAbsent(player.getMainHandItem(), s -> 0);
                double swing_animtime = ((CustomData)player.getMainHandItem().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime");
                if (is_mining == 0 && swing_animtime > 0.0) {
                    int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                    poseStack.translate((float)i * 0.56f, -0.52f, -0.72f);
                    if (player.getUseItem() == itemInHand) {
                        poseStack.translate(0.05, 0.05, 0.05);
                    }
                    return true;
                }
                return false;
            }

            @OnlyIn(value=Dist.CLIENT)
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.rendererInstance == null) {
                    this.rendererInstance = new FrozenFistItemRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
                }
                return this.rendererInstance;
            }
        }, new Item[]{(Item)BlockFactorysBossesModItems.FROZEN_FIST.get()});
    }

    protected void playSound(Player player, SoundEvent soundEvent) {
        player.playSound(soundEvent, 1.0f, 1.0f);
    }
}

