/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.item;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.unusual.blockfactorysbosses.AnimationTickHolder;
import net.unusual.blockfactorysbosses.client.model.Modelchestplate;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModItems;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class DragonBonesItem
extends ArmorItem {
    public static Holder<ArmorMaterial> ARMOR_MATERIAL = null;

    @SubscribeEvent
    public static void registerArmorMaterial(RegisterEvent event) {
        event.register(Registries.ARMOR_MATERIAL, registerHelper -> {
            ArmorMaterial armorMaterial = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, 3);
                map.put(ArmorItem.Type.LEGGINGS, 6);
                map.put(ArmorItem.Type.CHESTPLATE, 8);
                map.put(ArmorItem.Type.HELMET, 3);
                map.put(ArmorItem.Type.BODY, 8);
            }), 9, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_netherite")), () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlockFactorysBossesModItems.DRAGON_BONE.get())}), List.of(new ArmorMaterial.Layer(ResourceLocation.parse((String)"block_factorys_bosses:dragon_armor"))), 2.0f, 0.0f);
            registerHelper.register(ResourceLocation.parse((String)"block_factorys_bosses:dragon_bones"), (Object)armorMaterial);
            ARMOR_MATERIAL = BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial);
        });
    }

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelchestplate<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelchestplate.LAYER_LOCATION)).body, "left_arm", new Modelchestplate<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelchestplate.LAYER_LOCATION)).leftArm, "right_arm", new Modelchestplate<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelchestplate.LAYER_LOCATION)).rightArm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                armorModel.crouching = living.isShiftKeyDown();
                armorModel.riding = defaultModel.riding;
                armorModel.young = living.isBaby();
                return armorModel;
            }
        }, new Item[]{(Item)BlockFactorysBossesModItems.DRAGON_BONES_CHESTPLATE.get()});
    }

    public DragonBonesItem(ArmorItem.Type type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Boots
    extends DragonBonesItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(35)).fireResistant().rarity(Rarity.UNCOMMON));
        }

        public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
            return ResourceLocation.parse((String)"block_factorys_bosses:textures/entities/dragon_armor_boots.png");
        }
    }

    public static class Leggings
    extends DragonBonesItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties().durability(ArmorItem.Type.LEGGINGS.getDurability(35)).fireResistant().rarity(Rarity.UNCOMMON));
        }

        public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
            int index = Mth.floor((float)((float)(Math.round(AnimationTickHolder.getRenderTime()) % 40) * 0.4f));
            return ResourceLocation.parse((String)("block_factorys_bosses:textures/entities/dragon_leggings/dragon_leggings_" + index + ".png"));
        }
    }

    public static class Chestplate
    extends DragonBonesItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(35)).fireResistant().rarity(Rarity.UNCOMMON));
        }

        public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
            int index = Mth.floor((float)((float)(Math.round(AnimationTickHolder.getRenderTime()) % 40) * 0.4f));
            return ResourceLocation.parse((String)("block_factorys_bosses:textures/entities/dragon_chestplate/dragon_chestplate_" + index + ".png"));
        }
    }
}

