/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static final String SELECT = "\u00a7";
    private static DecimalFormat energyValue = new DecimalFormat("###,###,###,###,###", DecimalFormatSymbols.getInstance(Locale.ROOT));
    private static BiMap<Block, Fluid> fluidBlocks = null;

    @Deprecated
    public static String formatNumber(double value) {
        if (Math.abs(value) < 1000.0) {
            return String.valueOf(value);
        }
        if (Math.abs(value) < 1000000.0) {
            return Utils.addCommas((int)value);
        }
        if (Math.abs(value) < 1.0E9) {
            return String.valueOf((double)Math.round(value / 1000.0) / 1000.0) + "M";
        }
        if (Math.abs(value) < 1.0E12) {
            return String.valueOf((double)Math.round(value / 1000000.0) / 1000.0) + "B";
        }
        return String.valueOf((double)Math.round(value / 1.0E9) / 1000.0) + "T";
    }

    @Deprecated
    public static String formatNumber(long value) {
        if (value == Long.MIN_VALUE) {
            value = Long.MAX_VALUE;
        }
        if (Math.abs(value) < 1000L) {
            return String.valueOf(value);
        }
        if (Math.abs(value) < 1000000L) {
            return Utils.addCommas(value);
        }
        if (Math.abs(value) < 1000000000L) {
            return String.valueOf((double)Math.round(value / 100000L) / 10.0) + "M";
        }
        if (Math.abs(value) < 1000000000000L) {
            return String.valueOf((double)Math.round(value / 100000000L) / 10.0) + "G";
        }
        if (Math.abs(value) < 1000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000L) / 1000.0) + "T";
        }
        if (Math.abs(value) < 1000000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000000L) / 1000.0) + "P";
        }
        if (Math.abs(value) <= Long.MAX_VALUE) {
            return String.valueOf((double)Math.round(value / 1000000000000000L) / 1000.0) + "E";
        }
        return "Something is very broken!!!!";
    }

    public static String addCommas(int value) {
        return energyValue.format(value);
    }

    public static String addCommas(long value) {
        return energyValue.format(value);
    }

    public static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Deprecated
    public static double getDistanceAtoB(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Utils.getDistance(x1, y1, z1, x2, y2, z2);
    }

    @Deprecated
    public static double getDistanceAtoB(Vec3D pos1, Vec3D pos2) {
        return Utils.getDistance(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public static double getDistance(Vec3D pos1, Vec3D pos2) {
        return Utils.getDistance(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public static int getCardinalDistance(BlockPos pos1, BlockPos pos2) {
        int x = Math.abs(pos2.getX() - pos1.getX());
        int y = Math.abs(pos2.getY() - pos1.getY());
        int z = Math.abs(pos2.getZ() - pos1.getZ());
        return Math.max(Math.max(x, y), z);
    }

    public static boolean inRangeSphere(BlockPos posA, BlockPos posB, int range) {
        if (Math.abs(posA.getX() - posB.getX()) > range || Math.abs(posA.getY() - posB.getY()) > range || Math.abs(posA.getZ() - posB.getZ()) > range) {
            return false;
        }
        return Utils.getDistanceSq(posA.getX(), posA.getY(), posA.getZ(), posB.getX(), posB.getY(), posB.getZ()) <= (double)(range * range);
    }

    @Deprecated
    public static double getDistanceAtoB(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double getDistance(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double getDistanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getDistanceSq(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return dx * dx + dz * dz;
    }

    public static int toInt(double d) {
        return (int)d;
    }

    public static int parseInt(String s) {
        return Utils.parseInt(s, true);
    }

    public static int parseInt(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            if (catchException) {
                return 0;
            }
            throw e;
        }
    }

    public static double parseDouble(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            if (catchException) {
                return 0.0;
            }
            throw e;
        }
    }

    public static double parseDouble(String s) {
        return Utils.parseDouble(s, true);
    }

    public static int parseHex(String s) {
        return Utils.parseHex(s, true);
    }

    public static int parseHex(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        if (catchException) {
            try {
                return (int)Long.parseLong(s, 16);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return (int)Long.parseLong(s, 16);
    }

    public static boolean validInteger(String value) {
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean validDouble(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Player getClosestPlayer(Level world, double posX, double posY, double posZ, double distance) {
        return Utils.getClosestPlayer(world, posX, posY, posZ, distance, true);
    }

    @Nullable
    public static Player getClosestPlayer(Level world, double posX, double posY, double posZ, double distance, boolean includeCreative) {
        return Utils.getClosestPlayer(world, posX, posY, posZ, distance, includeCreative, false);
    }

    @Nullable
    @Deprecated
    public static Player getClosestPlayer(Level world, double posX, double posY, double posZ, double distance, boolean includeCreative, boolean includeSpectators) {
        double d0 = -1.0;
        Player closestPlayer = null;
        for (int i = 0; i < world.players().size(); ++i) {
            Player player = (Player)world.players().get(i);
            if (player.isCreative() && !includeCreative || player.isSpectator() && !includeSpectators) continue;
            double d1 = player.distanceToSqr(posX, posY, posZ);
            if (!(distance < 0.0) && !(d1 < distance * distance) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            closestPlayer = player;
        }
        return closestPlayer;
    }

    public static boolean checkClassInstanceOf(Class clazz, Class instanceOfThis) {
        if (clazz == null || instanceOfThis == null) {
            return clazz == null && instanceOfThis == null;
        }
        return instanceOfThis.isAssignableFrom(clazz);
    }

    public static String trimString(String input, int length, String trimExtension) {
        if (input.length() <= length) {
            return input;
        }
        return input.substring(0, length) + trimExtension;
    }

    public static String getClipboardString() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static void setClipboardString(String copyText) {
        if (!StringUtils.isEmpty((CharSequence)copyText)) {
            try {
                StringSelection stringselection = new StringSelection(copyText);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringselection, null);
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
        }
    }

    public static void openWebLink(URI url) {
        Util.getPlatform().openUri(url);
    }

    public static int parseColourRGB(String value) {
        if (value.startsWith("0x") || value.startsWith("#")) {
            value = value.replace("0x", "").replace("#", "");
            return Utils.parseHex(value, false);
        }
        if (value.contains(",")) {
            String[] vals = value.split(",");
            if (vals.length != 3) {
                throw new NumberFormatException("Number must be a hex using the format 0xRRGGBB or #RRGGBB");
            }
            int r = vals[0].contains(".") ? (int)(Double.parseDouble(vals[0]) * 255.0) : Integer.parseInt(vals[0]);
            int g = vals[1].contains(".") ? (int)(Double.parseDouble(vals[1]) * 255.0) : Integer.parseInt(vals[1]);
            int b = vals[2].contains(".") ? (int)(Double.parseDouble(vals[2]) * 255.0) : Integer.parseInt(vals[2]);
            return r << 16 | g << 8 | b;
        }
        throw new NumberFormatException("Number must be a hex using the format 0xRRGGBB or #RRGGBB");
    }

    public static int parseColourARGB(String value) {
        if (value.startsWith("0x") || value.startsWith("#")) {
            value = value.replace("0x", "").replace("#", "");
            return Utils.parseHex(value, false);
        }
        if (value.contains(",")) {
            int b;
            String[] vals = value.split(",");
            if (vals.length < 3 || vals.length > 4) {
                throw new NumberFormatException("Number must be a hex using the format 0xAARRGGBB or #AARRGGBB");
            }
            int r = vals[0].contains(".") ? (int)(Double.parseDouble(vals[0]) * 255.0) : Integer.parseInt(vals[0]);
            int g = vals[1].contains(".") ? (int)(Double.parseDouble(vals[1]) * 255.0) : Integer.parseInt(vals[1]);
            int n = b = vals[2].contains(".") ? (int)(Double.parseDouble(vals[2]) * 255.0) : Integer.parseInt(vals[2]);
            int a = vals.length == 4 ? (vals[3].contains(".") ? (int)(Double.parseDouble(vals[3]) * 255.0) : Integer.parseInt(vals[3])) : 255;
            return a << 24 | r << 16 | g << 8 | b;
        }
        throw new NumberFormatException("Number must be a hex using the format 0xRRGGBB or #RRGGBB");
    }

    public static Fluid lookupFluidForBlock(Block block) {
        if (fluidBlocks == null) {
            HashBiMap tmp = HashBiMap.create();
            for (Fluid fluid : BuiltInRegistries.FLUID) {
                Block fluidBlock = fluid.defaultFluidState().createLegacyBlock().getBlock();
                if (fluidBlock == Blocks.AIR) continue;
                tmp.put((Object)fluidBlock, (Object)fluid);
            }
            fluidBlocks = tmp;
        }
        return (Fluid)fluidBlocks.get((Object)block);
    }

    public static String getTextFormatString(String stringIn) {
        StringBuilder stringbuilder = new StringBuilder();
        int i = -1;
        int j = stringIn.length();
        while ((i = stringIn.indexOf(167, i + 1)) != -1) {
            ChatFormatting textformatting;
            if (i >= j - 1 || (textformatting = ChatFormatting.getByCode((char)stringIn.charAt(i + 1))) == null) continue;
            if (!textformatting.isFormat()) {
                stringbuilder.setLength(0);
            }
            if (textformatting == ChatFormatting.RESET) continue;
            stringbuilder.append(textformatting);
        }
        return stringbuilder.toString();
    }

    public static long safeAdd(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            return Long.MAX_VALUE;
        }
        return r;
    }

    public static int scaleToTPS(Level world, int min, int max) {
        if (!(world instanceof ServerLevel)) {
            return max;
        }
        long[] times = world.getServer().getTickTime(world.dimension());
        if (times == null) {
            return max;
        }
        double worldTickTime = (double)Utils.mean(times) * 1.0E-6;
        double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
        return MathHelper.clip((int)((int)MathUtils.map(worldTPS, 5.0, 20.0, min, max)), (int)min, (int)max);
    }

    public static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    public static void hollowCube(BlockPos min, BlockPos max, Consumer<BlockPos> callback) {
        Utils.hollowCube(min.getX(), min.getY(), min.getZ(), max.getX(), max.getY(), max.getZ(), callback);
    }

    public static void hollowCube(int xmin, int ymin, int zmin, int xmax, int ymax, int zmax, Consumer<BlockPos> callback) {
        int y;
        if (xmax - xmin < 2 || ymax - ymin < 2 || zmax - zmin < 2) {
            Utils.betweenClosed(xmin, ymin, zmin, xmax, ymax, zmax, callback);
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int x = xmin; x <= xmax; ++x) {
            for (y = ymin + 1; y <= ymax - 1; ++y) {
                for (int z = zmin; z <= zmax; z += zmax - zmin) {
                    callback.accept((BlockPos)cursor.set(x, y, z));
                }
            }
            for (int z = zmin; z <= zmax; ++z) {
                for (int y2 = ymin; y2 <= ymax; y2 += ymax - ymin) {
                    callback.accept((BlockPos)cursor.set(x, y2, z));
                }
            }
        }
        for (int z = zmin + 1; z <= zmax - 1; ++z) {
            for (y = ymin + 1; y <= ymax - 1; ++y) {
                for (int x = xmin; x <= xmax; x += xmax - xmin) {
                    callback.accept((BlockPos)cursor.set(x, y, z));
                }
            }
        }
    }

    public static void betweenClosed(BlockPos min, BlockPos max, Consumer<BlockPos> callback) {
        Utils.betweenClosed(Math.min(min.getX(), max.getX()), Math.min(min.getY(), max.getY()), Math.min(min.getZ(), max.getZ()), Math.max(min.getX(), max.getX()), Math.max(min.getY(), max.getY()), Math.max(min.getZ(), max.getZ()), callback);
    }

    public static void betweenClosed(int xmin, int ymin, int zmin, int xmax, int ymax, int zmax, Consumer<BlockPos> callback) {
        int width = xmax - xmin + 1;
        int height = ymax - ymin + 1;
        int depth = zmax - zmin + 1;
        int total = width * height * depth;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int index = 0; index < total; ++index) {
            int x = index % width;
            int j1 = index / width;
            int y = j1 % height;
            int z = j1 / height;
            callback.accept((BlockPos)cursor.set(xmin + x, ymin + y, zmin + z));
        }
    }

    public static boolean isInRect(double x, double y, double xSize, double ySize, double mouseX, double mouseY) {
        return mouseX >= x && mouseX < x + xSize && mouseY >= y && mouseY < y + ySize;
    }

    public static double distToRect(double x, double y, double xSize, double ySize, double mouseX, double mouseY) {
        if (Utils.isInRect(x, y, xSize, ySize, mouseX, mouseY)) {
            return 0.0;
        }
        if (mouseY >= y && mouseY < y + ySize) {
            return mouseX >= x + xSize ? mouseX - (x + xSize) : x - mouseX;
        }
        if (mouseX >= x && mouseX < x + xSize) {
            return mouseY < y ? y - mouseY : mouseY - (y + ySize);
        }
        double cx = mouseX < x ? x : x + xSize;
        double cy = mouseY < y ? y : y + ySize;
        return Utils.getDistance(cx, cy, mouseX, mouseY);
    }

    public static MessageSignature uuidToSig(UUID uuid) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(256);
        byteBuffer.position(32);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return new MessageSignature(byteBuffer.array());
    }

    @Deprecated
    public static <T> T unsafeRunForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        switch (FMLEnvironment.dist) {
            case CLIENT: {
                return clientTarget.get().get();
            }
            case DEDICATED_SERVER: {
                return serverTarget.get().get();
            }
        }
        throw new IllegalArgumentException("UNSIDED?");
    }

    @Deprecated
    public static void unsafeRunWhenOn(Dist dist, Supplier<Runnable> toRun) {
        if (dist == FMLEnvironment.dist) {
            toRun.get().run();
        }
    }

    @Deprecated
    public static <T> T unsafeCallWhenOn(Dist dist, Supplier<Callable<T>> toRun) {
        if (dist == FMLEnvironment.dist) {
            try {
                return toRun.get().call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Deprecated
    public static CompoundTag writeBlockPos(BlockPos p_129225_) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putInt("X", p_129225_.getX());
        compoundtag.putInt("Y", p_129225_.getY());
        compoundtag.putInt("Z", p_129225_.getZ());
        return compoundtag;
    }

    @Deprecated
    public static BlockPos readBlockPos(CompoundTag p_129240_) {
        return new BlockPos(p_129240_.getInt("X"), p_129240_.getInt("Y"), p_129240_.getInt("Z"));
    }

    public static void loadOptionalMod(String modid, Supplier<Runnable> runnable) {
        if (ModList.get().isLoaded(modid)) {
            runnable.get().run();
        }
    }
}

