/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.handlers.BCEventHandler;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.brandonscore.lib.datamanager.IDataManagerProvider;
import com.brandon3055.brandonscore.multiblock.MultiBlockManager;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ClientPacketHandler
implements ICustomPacketHandler.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, Minecraft mc) {
        switch (packet.getType()) {
            case 1: {
                BlockPos pos = packet.readPos();
                BlockEntity blockEntity = mc.level.getBlockEntity(pos);
                if (!(blockEntity instanceof IDataManagerProvider)) break;
                IDataManagerProvider tile = (IDataManagerProvider)blockEntity;
                tile.getDataManager().receiveSyncData((MCDataInput)packet);
                break;
            }
            case 2: {
                BlockPos pos = packet.readPos();
                BlockEntity blockEntity = mc.level.getBlockEntity(pos);
                if (!(blockEntity instanceof TileBCore)) break;
                TileBCore tile = (TileBCore)blockEntity;
                int id = packet.readByte() & 0xFF;
                tile.receivePacketFromServer((MCDataInput)packet, id);
                break;
            }
            case 4: {
                boolean enable = packet.readBoolean();
                if (enable) {
                    BCEventHandler.noClipPlayers.add(mc.player.getUUID());
                    break;
                }
                BCEventHandler.noClipPlayers.remove(mc.player.getUUID());
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                BrandonsCore.proxy.sendIndexedMessage((Player)mc.player, (Component)packet.readTextComponent(), new MessageSignature(packet.readBytes()));
                break;
            }
            case 8: {
                BlockPos pos = packet.readPos();
                BlockEntity blockEntity = mc.level.getBlockEntity(pos);
                if (!(blockEntity instanceof TileBCore)) break;
                TileBCore tile = (TileBCore)blockEntity;
                tile.getCapManager().receiveCapSyncData((MCDataInput)packet);
                break;
            }
            case 9: {
                ClientPacketHandler.handlePlaySound(packet, mc);
                break;
            }
            case 10: {
                ClientPacketHandler.handleEntitySpawn(packet, mc);
                break;
            }
            case 11: {
                ClientPacketHandler.handleParticleSpawn(packet, mc);
                break;
            }
            case 12: {
                ClientPacketHandler.handleEntityVelocity(packet, mc);
                break;
            }
            case 14: {
                MultiBlockManager.receiveDefinitionsFromServer(packet);
                break;
            }
            case 15: {
                ContributorHandler.handleSettingsFromServer(packet);
            }
        }
    }

    private static void handlePlaySound(PacketCustom packet, Minecraft mc) {
        if (mc.level == null) {
            return;
        }
        BlockPos pos = packet.readPos();
        SoundEvent sound = (SoundEvent)packet.readRegistryId();
        SoundSource category = SoundSource.values()[packet.readVarInt()];
        float volume = packet.readFloat();
        float pitch = packet.readFloat();
        boolean distanceDelay = packet.readBoolean();
        mc.level.playLocalSound(pos, sound, category, volume, pitch, distanceDelay);
    }

    private static void handleEntitySpawn(PacketCustom packet, Minecraft mc) {
        if (mc.level == null) {
            return;
        }
        int entityID = packet.readInt();
        UUID uuid = packet.readUUID();
        double posX = packet.readDouble();
        double posY = packet.readDouble();
        double posZ = packet.readDouble();
        byte xRot = packet.readByte();
        byte yRot = packet.readByte();
        byte headYRot = packet.readByte();
        EntityType type = (EntityType)packet.readRegistryId();
        int ownerId = packet.readVarInt();
        Vec3 velocity = new Vec3((double)packet.readFloat(), (double)packet.readFloat(), (double)packet.readFloat());
        Entity entity = type.create((Level)mc.level);
        if (entity == null) {
            return;
        }
        if (entity instanceof Projectile) {
            Entity e;
            Projectile projectile = (Projectile)entity;
            if (ownerId != 0 && (e = mc.level.getEntity(ownerId)) != null) {
                projectile.setOwner(entity);
            }
        }
        entity.setDeltaMovement(velocity);
        entity.syncPacketPositionCodec(posX, posY, posZ);
        entity.moveTo(posX, posY, posZ);
        entity.setXRot((float)xRot);
        entity.setYRot((float)yRot);
        entity.setId(entityID);
        entity.setUUID(uuid);
        mc.level.addEntity(entity);
    }

    private static void handleEntityVelocity(PacketCustom packet, Minecraft mc) {
        if (mc.level == null) {
            return;
        }
        int entityID = packet.readInt();
        Entity entity = mc.level.getEntity(entityID);
        if (entity != null) {
            Vector3f motion = packet.readVec3f();
            entity.lerpMotion((double)motion.x(), (double)motion.y(), (double)motion.z());
            if (packet.readBoolean()) {
                entity.setXRot(packet.readFloat());
                entity.setYRot(packet.readFloat());
                entity.setOnGround(packet.readBoolean());
            }
        }
    }

    private static void handleParticleSpawn(PacketCustom packet, Minecraft mc) {
        if (mc.level == null) {
            return;
        }
        ParticleOptions data = (ParticleOptions)ParticleTypes.STREAM_CODEC.decode((Object)packet.toRegistryFriendlyByteBuf());
        Vector3 pos = packet.readVector();
        Vector3 motion = packet.readVector();
        boolean distanceOverride = packet.readBoolean();
        mc.level.addParticle(data, distanceOverride, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
    }
}

