/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class ManagedStack
extends AbstractManagedData<ItemStack> {
    private ItemStack value;
    private ItemStack lastValue;
    protected Function<ItemStack, ItemStack> validator = null;

    public ManagedStack(String name, ItemStack defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.lastValue = defaultValue.copy();
    }

    public ManagedStack(String name, DataFlags ... flags) {
        this(name, ItemStack.EMPTY, flags);
    }

    public ItemStack set(ItemStack value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            ItemStack prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.lastValue = prev.copy();
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public ItemStack get() {
        return this.value;
    }

    public ManagedStack setValidator(Function<ItemStack, ItemStack> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public boolean isDirty(boolean reset) {
        if (this.lastValue != null && !this.lastValue.equals(this.value)) {
            if (reset) {
                this.lastValue = this.value.copy();
            }
            return true;
        }
        return super.isDirty(reset);
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeItemStack(this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readItemStack();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(HolderLookup.Provider provider, CompoundTag compound) {
        compound.put(this.name, this.value.saveOptional(provider));
    }

    @Override
    public void fromNBT(HolderLookup.Provider provider, CompoundTag compound) {
        this.value = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound(this.name));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + String.valueOf(this.value) + "]";
    }
}

