/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.hud;

import codechicken.lib.gui.modular.lib.GuiRender;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public interface IHudDisplay {
    @OnlyIn(value=Dist.CLIENT)
    default public double computeHudWidth(Minecraft mc, List<Component> displayList) {
        double maxWidth = 0.0;
        for (Component text : displayList) {
            maxWidth = Math.max(maxWidth, (double)mc.font.width((FormattedText)text));
        }
        return maxWidth + 8.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public double computeHudHeight(Minecraft mc, List<Component> displayList) {
        return displayList.size() * 10 + 6;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderHudBackground(GuiRender render, double width, double height, List<Component> displayList) {
        render.toolTipBackground(0.0, 0.0, width, height);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderHudContent(GuiRender render, double width, double height, List<Component> displayList) {
        render.pose().translate(4.0f, 4.0f, 0.0f);
        for (Component text : displayList) {
            render.drawString(text, 0.0, 0.0, 0xFFFFFF, true);
            render.pose().translate(0.0f, 10.0f, 0.0f);
        }
    }
}

