/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.configuration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yanny.ali.configuration.LootCategory;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;

public class TradeLootCategory
extends LootCategory<ResourceLocation> {
    private final List<Pattern> patterns;

    public TradeLootCategory(ResourceLocation key, Item icon, boolean hide, List<Pattern> patterns) {
        super(key, icon, LootCategory.Type.TRADE, hide);
        this.patterns = patterns;
    }

    public TradeLootCategory(JsonObject object) {
        super(LootCategory.Type.TRADE, object);
        this.patterns = GsonHelper.getAsJsonArray((JsonObject)object, (String)"pattern").asList().stream().map(JsonElement::getAsString).map(Pattern::compile).toList();
    }

    @Override
    protected void toJson(JsonObject object) {
        JsonArray array = new JsonArray();
        this.patterns.forEach(p -> array.add(p.pattern()));
        object.add("pattern", (JsonElement)array);
    }

    @Override
    public boolean validate(ResourceLocation path) {
        return this.patterns.stream().anyMatch(p -> p.matcher(path.toString()).find());
    }
}

