/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.emi;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.NodeUtils;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.SlotWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class EmiLootSlotWidget
extends SlotWidget {
    @Nullable
    private Component count;
    private boolean isRange = false;

    public EmiLootSlotWidget(IDataNode entry, EmiIngredient ingredient, int x, int y, RangeValue count) {
        super(ingredient, x, y);
        NodeUtils.toComponents(entry.getTooltip(), 0, Minecraft.getInstance().options.advancedItemTooltips).forEach(arg_0 -> ((EmiLootSlotWidget)this).appendTooltip(arg_0));
        this.setCount(count);
    }

    public void drawOverlay(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        if (this.count != null) {
            Font font = Minecraft.getInstance().font;
            PoseStack stack = draw.pose();
            stack.pushPose();
            if (this.isRange) {
                stack.translate((float)(this.x + 17), (float)(this.y + 13), 200.0f);
                stack.pushPose();
                stack.scale(0.5f, 0.5f, 0.5f);
                draw.drawString(font, this.count, -font.width((FormattedText)this.count), 0, 0xFFFFFF, false);
                stack.popPose();
            } else {
                stack.translate((float)(this.x + 18), (float)(this.y + 10), 200.0f);
                draw.drawString(font, this.count, -font.width((FormattedText)this.count), 0, 0xFFFFFF, true);
            }
            stack.popPose();
        }
        super.drawOverlay(draw, mouseX, mouseY, delta);
    }

    private void setCount(RangeValue count) {
        if (count.isRange() || count.min() > 1.0f) {
            this.count = Component.literal((String)count.toIntString());
            this.isRange = count.isRange();
        }
    }
}

