/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.cms.jcajce;

import amp_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import amp_libs.org.bouncycastle.cms.CMSException;
import amp_libs.org.bouncycastle.cms.KEKRecipient;
import amp_libs.org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import amp_libs.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import amp_libs.org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import amp_libs.org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import amp_libs.org.bouncycastle.operator.OperatorException;
import amp_libs.org.bouncycastle.operator.SymmetricKeyUnwrapper;
import java.security.Key;
import java.security.Provider;
import javax.crypto.SecretKey;

public abstract class JceKEKRecipient
implements KEKRecipient {
    private SecretKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;
    protected boolean validateKeySize;

    public JceKEKRecipient(SecretKey secretKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
        this.validateKeySize = false;
        this.recipientKey = secretKey;
    }

    public JceKEKRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKEKRecipient setProvider(String string) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(string));
        return this;
    }

    public JceKEKRecipient setContentProvider(Provider provider) {
        this.contentHelper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKEKRecipient setContentProvider(String string) {
        this.contentHelper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(string));
        return this;
    }

    public JceKEKRecipient setKeySizeValidation(boolean bl) {
        this.validateKeySize = bl;
        return this;
    }

    protected Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        SymmetricKeyUnwrapper symmetricKeyUnwrapper = this.helper.createSymmetricUnwrapper(algorithmIdentifier, this.recipientKey);
        try {
            Key key = this.helper.getJceKey(algorithmIdentifier2, symmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
            if (this.validateKeySize) {
                this.helper.keySizeCheck(algorithmIdentifier2, key);
            }
            return key;
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }
}

