/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.client5.http.impl.async;

import amp_libs.org.apache.hc.client5.http.DnsResolver;
import amp_libs.org.apache.hc.client5.http.SchemePortResolver;
import amp_libs.org.apache.hc.client5.http.SystemDefaultDnsResolver;
import amp_libs.org.apache.hc.client5.http.config.TlsConfig;
import amp_libs.org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import amp_libs.org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import amp_libs.org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import amp_libs.org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import amp_libs.org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder;
import amp_libs.org.apache.hc.client5.http.impl.async.H2AsyncClientProtocolStarter;
import amp_libs.org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import amp_libs.org.apache.hc.client5.http.impl.async.HttpAsyncClientProtocolNegotiationStarter;
import amp_libs.org.apache.hc.client5.http.impl.async.LoggingExceptionCallback;
import amp_libs.org.apache.hc.client5.http.impl.async.MinimalH2AsyncClient;
import amp_libs.org.apache.hc.client5.http.impl.async.MinimalHttpAsyncClient;
import amp_libs.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import amp_libs.org.apache.hc.client5.http.impl.compat.ClassicToAsyncAdaptor;
import amp_libs.org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import amp_libs.org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import amp_libs.org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import amp_libs.org.apache.hc.core5.annotation.Experimental;
import amp_libs.org.apache.hc.core5.concurrent.DefaultThreadFactory;
import amp_libs.org.apache.hc.core5.function.Supplier;
import amp_libs.org.apache.hc.core5.http.config.CharCodingConfig;
import amp_libs.org.apache.hc.core5.http.config.Http1Config;
import amp_libs.org.apache.hc.core5.http.impl.routing.RequestRouter;
import amp_libs.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import amp_libs.org.apache.hc.core5.http.nio.HandlerFactory;
import amp_libs.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import amp_libs.org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import amp_libs.org.apache.hc.core5.http.protocol.HttpProcessor;
import amp_libs.org.apache.hc.core5.http.protocol.RequestUserAgent;
import amp_libs.org.apache.hc.core5.http2.HttpVersionPolicy;
import amp_libs.org.apache.hc.core5.http2.config.H2Config;
import amp_libs.org.apache.hc.core5.http2.protocol.H2RequestConnControl;
import amp_libs.org.apache.hc.core5.http2.protocol.H2RequestContent;
import amp_libs.org.apache.hc.core5.http2.protocol.H2RequestTargetHost;
import amp_libs.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import amp_libs.org.apache.hc.core5.reactor.IOReactorConfig;
import amp_libs.org.apache.hc.core5.util.Timeout;
import amp_libs.org.apache.hc.core5.util.VersionInfo;

public final class HttpAsyncClients {
    private HttpAsyncClients() {
    }

    public static HttpAsyncClientBuilder custom() {
        return HttpAsyncClientBuilder.create();
    }

    public static CloseableHttpAsyncClient createDefault() {
        return HttpAsyncClientBuilder.create().build();
    }

    public static CloseableHttpAsyncClient createSystem() {
        return HttpAsyncClientBuilder.create().useSystemProperties().build();
    }

    public static H2AsyncClientBuilder customHttp2() {
        return H2AsyncClientBuilder.create();
    }

    public static CloseableHttpAsyncClient createHttp2Default() {
        return H2AsyncClientBuilder.create().build();
    }

    public static CloseableHttpAsyncClient createHttp2System() {
        return H2AsyncClientBuilder.create().useSystemProperties().build();
    }

    private static HttpProcessor createMinimalProtocolProcessor() {
        return new DefaultHttpProcessor(new H2RequestTargetHost(), new H2RequestContent(), new H2RequestConnControl(), new RequestUserAgent(VersionInfo.getSoftwareInfo("Apache-HttpAsyncClient", "amp_libs.org.apache.hc.client5", HttpAsyncClients.class)));
    }

    private static MinimalHttpAsyncClient createMinimalHttpAsyncClientImpl(IOEventHandlerFactory eventHandlerFactory, AsyncPushConsumerRegistry pushConsumerRegistry, IOReactorConfig ioReactorConfig, AsyncClientConnectionManager connmgr, SchemePortResolver schemePortResolver, TlsConfig tlsConfig) {
        return new MinimalHttpAsyncClient(eventHandlerFactory, pushConsumerRegistry, ioReactorConfig, new DefaultThreadFactory("httpclient-main", true), new DefaultThreadFactory("httpclient-dispatch", true), connmgr, schemePortResolver, tlsConfig);
    }

    @Deprecated
    public static MinimalHttpAsyncClient createMinimal(HttpVersionPolicy versionPolicy, H2Config h2Config, Http1Config h1Config, IOReactorConfig ioReactorConfig, AsyncClientConnectionManager connmgr) {
        AsyncPushConsumerRegistry pushConsumerRegistry = new AsyncPushConsumerRegistry();
        return HttpAsyncClients.createMinimalHttpAsyncClientImpl(new HttpAsyncClientProtocolNegotiationStarter(HttpAsyncClients.createMinimalProtocolProcessor(), (request, context) -> pushConsumerRegistry.get(request), h2Config, h1Config, CharCodingConfig.DEFAULT, DefaultClientConnectionReuseStrategy.INSTANCE, LoggingExceptionCallback.INSTANCE), pushConsumerRegistry, ioReactorConfig, connmgr, DefaultSchemePortResolver.INSTANCE, versionPolicy != null ? TlsConfig.custom().setVersionPolicy(versionPolicy).build() : null);
    }

    public static MinimalHttpAsyncClient createMinimal(H2Config h2Config, Http1Config h1Config, IOReactorConfig ioReactorConfig, AsyncClientConnectionManager connmgr) {
        AsyncPushConsumerRegistry pushConsumerRegistry = new AsyncPushConsumerRegistry();
        return HttpAsyncClients.createMinimalHttpAsyncClientImpl(new HttpAsyncClientProtocolNegotiationStarter(HttpAsyncClients.createMinimalProtocolProcessor(), (request, context) -> pushConsumerRegistry.get(request), h2Config, h1Config, CharCodingConfig.DEFAULT, DefaultClientConnectionReuseStrategy.INSTANCE, LoggingExceptionCallback.INSTANCE), pushConsumerRegistry, ioReactorConfig, connmgr, DefaultSchemePortResolver.INSTANCE, null);
    }

    @Deprecated
    public static MinimalHttpAsyncClient createMinimal(HttpVersionPolicy versionPolicy, H2Config h2Config, Http1Config h1Config, IOReactorConfig ioReactorConfig) {
        return HttpAsyncClients.createMinimal(versionPolicy, h2Config, h1Config, ioReactorConfig, PoolingAsyncClientConnectionManagerBuilder.create().build());
    }

    public static MinimalHttpAsyncClient createMinimal(H2Config h2Config, Http1Config h1Config, IOReactorConfig ioReactorConfig) {
        return HttpAsyncClients.createMinimal(h2Config, h1Config, ioReactorConfig, PoolingAsyncClientConnectionManagerBuilder.create().build());
    }

    public static MinimalHttpAsyncClient createMinimal(H2Config h2Config, Http1Config h1Config) {
        return HttpAsyncClients.createMinimal(HttpVersionPolicy.NEGOTIATE, h2Config, h1Config, IOReactorConfig.DEFAULT);
    }

    public static MinimalHttpAsyncClient createMinimal() {
        return HttpAsyncClients.createMinimal(H2Config.DEFAULT, Http1Config.DEFAULT);
    }

    public static MinimalHttpAsyncClient createMinimal(AsyncClientConnectionManager connManager) {
        return HttpAsyncClients.createMinimal(HttpVersionPolicy.NEGOTIATE, H2Config.DEFAULT, Http1Config.DEFAULT, IOReactorConfig.DEFAULT, connManager);
    }

    private static MinimalH2AsyncClient createMinimalHttp2AsyncClientImpl(IOEventHandlerFactory eventHandlerFactory, AsyncPushConsumerRegistry pushConsumerRegistry, IOReactorConfig ioReactorConfig, DnsResolver dnsResolver, TlsStrategy tlsStrategy) {
        return new MinimalH2AsyncClient(eventHandlerFactory, pushConsumerRegistry, ioReactorConfig, new DefaultThreadFactory("httpclient-main", true), new DefaultThreadFactory("httpclient-dispatch", true), dnsResolver, tlsStrategy);
    }

    public static MinimalH2AsyncClient createHttp2Minimal(H2Config h2Config, IOReactorConfig ioReactorConfig, DnsResolver dnsResolver, TlsStrategy tlsStrategy) {
        AsyncPushConsumerRegistry pushConsumerRegistry = new AsyncPushConsumerRegistry();
        return HttpAsyncClients.createMinimalHttp2AsyncClientImpl(new H2AsyncClientProtocolStarter(HttpAsyncClients.createMinimalProtocolProcessor(), (request, context) -> pushConsumerRegistry.get(request), h2Config, CharCodingConfig.DEFAULT, LoggingExceptionCallback.INSTANCE), pushConsumerRegistry, ioReactorConfig, dnsResolver, tlsStrategy);
    }

    public static MinimalH2AsyncClient createHttp2Minimal(H2Config h2Config, IOReactorConfig ioReactorConfig, TlsStrategy tlsStrategy) {
        return HttpAsyncClients.createHttp2Minimal(h2Config, ioReactorConfig, SystemDefaultDnsResolver.INSTANCE, tlsStrategy);
    }

    public static MinimalH2AsyncClient createHttp2Minimal(H2Config h2Config, IOReactorConfig ioReactorConfig) {
        return HttpAsyncClients.createHttp2Minimal(h2Config, ioReactorConfig, DefaultClientTlsStrategy.createDefault());
    }

    public static MinimalH2AsyncClient createHttp2Minimal(H2Config h2Config) {
        return HttpAsyncClients.createHttp2Minimal(h2Config, IOReactorConfig.DEFAULT);
    }

    public static MinimalH2AsyncClient createHttp2Minimal() {
        return HttpAsyncClients.createHttp2Minimal(H2Config.DEFAULT);
    }

    public static HandlerFactory<AsyncPushConsumer> pushRouter(RequestRouter<Supplier<AsyncPushConsumer>> requestRouter) {
        return (request, context) -> {
            Supplier supplier = (Supplier)requestRouter.resolve(request, context);
            return supplier != null ? (AsyncPushConsumer)supplier.get() : null;
        };
    }

    @Experimental
    public static CloseableHttpClient classic(CloseableHttpAsyncClient client, Timeout operationTimeout) {
        client.start();
        return new ClassicToAsyncAdaptor(client, operationTimeout);
    }
}

