/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.network.to_server;

import com.jerry.mekextras.MekanismExtras;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraFactory;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import mekanism.api.functions.TriConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ExtraPacketGuiInteract
implements IMekanismPacket {
    public static final CustomPacketPayload.Type<ExtraPacketGuiInteract> TYPE = new CustomPacketPayload.Type(MekanismExtras.rl("gui_interact"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ExtraPacketGuiInteract> STREAM_CODEC = ExtraInteractionType.STREAM_CODEC.cast().dispatch(packet -> packet.interactionType, type -> switch (type.ordinal()) {
        default -> throw new MatchException(null, null);
        case 0, 1 -> null;
        case 2 -> StreamCodec.composite(ExtraGuiInteraction.STREAM_CODEC, packet -> packet.interaction, (StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.tilePosition, (StreamCodec)ByteBufCodecs.VAR_INT, packet -> packet.extra, ExtraPacketGuiInteract::new);
    });
    private final ExtraInteractionType interactionType = ExtraInteractionType.INT;
    private ExtraGuiInteraction interaction;
    private BlockPos tilePosition;
    private ItemStack extraItem;
    private int entityID;
    private int extra;

    public ExtraPacketGuiInteract(ExtraGuiInteraction interaction, BlockEntity tile) {
        this(interaction, tile.getBlockPos());
    }

    public ExtraPacketGuiInteract(ExtraGuiInteraction interaction, BlockEntity tile, int extra) {
        this(interaction, tile.getBlockPos(), extra);
    }

    public ExtraPacketGuiInteract(ExtraGuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0);
    }

    public ExtraPacketGuiInteract(ExtraGuiInteraction interaction, BlockPos tilePosition, int extra) {
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        if (this.interactionType == ExtraInteractionType.ENTITY) {
            Entity entity = player.level().getEntity(this.entityID);
        } else {
            TileEntityMekanism tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.level(), (BlockPos)this.tilePosition);
            if (tile != null && this.interactionType == ExtraInteractionType.INT) {
                this.interaction.consume(tile, player, this.extra);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<ExtraPacketGuiInteract> type() {
        return TYPE;
    }

    public static enum ExtraGuiInteraction {
        AUTO_SORT_BUTTON((TriConsumer<TileEntityMekanism, Player, Integer>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityExtraFactory) {
                TileEntityExtraFactory factory = (TileEntityExtraFactory)((Object)tile);
                factory.toggleSorting();
            }
        }));

        public static final IntFunction<ExtraGuiInteraction> BY_ID;
        public static final StreamCodec<ByteBuf, ExtraGuiInteraction> STREAM_CODEC;
        private final TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile;

        private ExtraGuiInteraction(TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, int extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ExtraGuiInteraction.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    private static enum ExtraInteractionType {
        ENTITY,
        ITEM,
        INT;

        public static final IntFunction<ExtraInteractionType> BY_ID;
        public static final StreamCodec<ByteBuf, ExtraInteractionType> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ExtraInteractionType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

