/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.content.network.transmitter;

import com.jerry.mekextras.api.mixin.IMixinLogisticalTransporterBase;
import com.jerry.mekextras.common.tier.transmitter.TPTier;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityTransmitter;
import com.jerry.mekextras.common.util.IExtraUpgradeableTransmitter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.function.IntFunction;
import mekanism.api.text.EnumColor;
import mekanism.api.tier.ITier;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.transmitter.PacketTransporterBatch;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.LogisticalTransporterUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraLogisticalTransporter
extends LogisticalTransporterBase
implements IExtraUpgradeableTransmitter<LogisticalTransporterUpgradeData> {
    @Nullable
    private EnumColor color;

    public ExtraLogisticalTransporter(Holder<Block> blockProvider, ExtraTileEntityTransmitter tile) {
        super((TileEntityTransmitter)tile, (TransporterTier)Attribute.getTier(blockProvider, TransporterTier.class));
    }

    public void onUpdateClient() {
        for (TransporterStack stack : this.transit.values()) {
            stack.progress = Math.min(100, stack.progress + TPTier.getSpeed(this.tier));
        }
    }

    @Nullable
    public EnumColor getColor() {
        return this.color;
    }

    public void setColor(@Nullable EnumColor c) {
        this.color = c;
    }

    public InteractionResult onConfigure(Player player, Direction side) {
        this.setColor(TransporterUtils.increment((EnumColor)this.getColor()));
        PathfinderCache.onChanged((InventoryNetwork[])new InventoryNetwork[]{(InventoryNetwork)this.getTransmitterNetwork()});
        this.getTransmitterTile().sendUpdatePacket();
        EnumColor color = this.getColor();
        player.displayClientMessage((Component)MekanismLang.TOGGLE_COLOR.translateColored(EnumColor.GRAY, new Object[]{color == null ? MekanismLang.NONE.translateColored(EnumColor.WHITE) : color.getColoredName()}), true);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRightClick(Player player, Direction side) {
        EnumColor color = this.getColor();
        player.displayClientMessage((Component)MekanismLang.CURRENT_COLOR.translateColored(EnumColor.GRAY, new Object[]{color == null ? MekanismLang.NONE.translateColored(EnumColor.WHITE) : color.getColoredName()}), true);
        return super.onRightClick(player, side);
    }

    @Override
    @Nullable
    public LogisticalTransporterUpgradeData getUpgradeData() {
        return new LogisticalTransporterUpgradeData(this.redstoneReactive, this.getConnectionTypesRaw(), this.getColor(), this.transit, this.needsSync, this.nextId, this.delay, this.delayCount);
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return data instanceof LogisticalTransporterUpgradeData;
    }

    @Override
    public void parseUpgradeData(@NotNull LogisticalTransporterUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.setColor(data.color);
        this.transit.putAll((Map)data.transit);
        this.needsSync.putAll((Map)data.needsSync);
        this.nextId = data.nextId;
        this.delay = data.delay;
        this.delayCount = data.delayCount;
    }

    protected void readFromNBT(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.readFromNBT(provider, nbtTags);
        this.setColor((EnumColor)NBTUtils.getEnum((CompoundTag)nbtTags, (String)"color", TransporterUtils::readColor));
    }

    public void writeToNBT(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.writeToNBT(provider, nbtTags);
        if (this.getColor() != null) {
            NBTUtils.writeEnum((CompoundTag)nbtTags, (String)"color", (Enum)this.getColor());
        }
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider, CompoundTag updateTag) {
        updateTag = super.getReducedUpdateTag(provider, updateTag);
        if (this.getColor() != null) {
            NBTUtils.writeEnum((CompoundTag)updateTag, (String)"color", (Enum)this.getColor());
        }
        return updateTag;
    }

    public boolean handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        boolean refreshModelData = super.handleUpdateTag(tag, provider);
        EnumColor color = (EnumColor)NBTUtils.getEnum((CompoundTag)tag, (String)"color", (IntFunction)EnumColor.BY_ID);
        if (this.color != color) {
            this.setColor(color);
            refreshModelData = true;
        }
        return refreshModelData;
    }

    @Override
    public ITier getTier() {
        return this.tier;
    }

    public void onUpdateServer() {
        if (this.getTransmitterNetwork() != null) {
            if (this.delay > 0) {
                --this.delay;
            } else {
                this.delay = 3;
                BlockPos.MutableBlockPos inventoryPos = new BlockPos.MutableBlockPos();
                BlockPos pos = this.getBlockPos();
                for (Direction side : EnumUtils.DIRECTIONS) {
                    TransitRequest request;
                    if (!this.isConnectionType(side, ConnectionType.PULL)) continue;
                    inventoryPos.setWithOffset((Vec3i)pos, side);
                    IItemHandler inventory = (IItemHandler)Capabilities.ITEM.getCapabilityIfLoaded(this.getLevel(), (BlockPos)inventoryPos, side.getOpposite());
                    if (inventory == null || (request = TransitRequest.anyItem((IItemHandler)inventory, (int)TPTier.getPullAmount(this.tier))).isEmpty()) continue;
                    TransitRequest.TransitResponse response = this.insert(null, (BlockPos)inventoryPos, request, this.getColor(), true, 0);
                    if (response.isEmpty()) {
                        ++this.delayCount;
                        this.delay = Math.min(40, (int)Math.exp(this.delayCount));
                        continue;
                    }
                    response.useAll();
                    this.delay = 10;
                }
            }
            if (!this.transit.isEmpty()) {
                long pos = this.getWorldPositionLong();
                InventoryNetwork network = (InventoryNetwork)this.getTransmitterNetwork();
                IntOpenHashSet deletes = new IntOpenHashSet();
                for (Int2ObjectMap.Entry entry : this.transit.int2ObjectEntrySet()) {
                    boolean tryRecalculate;
                    int stackId = entry.getIntKey();
                    TransporterStack stack = (TransporterStack)entry.getValue();
                    if (!(stack.initiatedPath || !stack.itemStack.isEmpty() && this.recalculate(stackId, stack, Long.MAX_VALUE))) {
                        deletes.add(stackId);
                        continue;
                    }
                    int prevProgress = stack.progress;
                    stack.progress += TPTier.getSpeed(this.tier);
                    if (stack.progress >= 100) {
                        long prevSet = Long.MAX_VALUE;
                        if (stack.hasPath()) {
                            int currentIndex = stack.getPath().indexOf(pos);
                            if (currentIndex == 0) {
                                deletes.add(stackId);
                                continue;
                            }
                            long next = stack.getPath().getLong(currentIndex - 1);
                            if (next != Long.MAX_VALUE) {
                                BlockPos nextPos = BlockPos.of((long)next);
                                if (!stack.isFinal((LogisticalTransporterBase)this)) {
                                    LogisticalTransporterBase transmitter = (LogisticalTransporterBase)network.getTransmitter(next);
                                    if (stack.canInsertToTransporter(transmitter, stack.getSide((LogisticalTransporterBase)this), (LogisticalTransporterBase)this)) {
                                        if (transmitter instanceof IMixinLogisticalTransporterBase) {
                                            IMixinLogisticalTransporterBase mixTransmitter = (IMixinLogisticalTransporterBase)transmitter;
                                            mixTransmitter.mekanismExtras$getEntity(stack, stack.progress % 100);
                                        }
                                        deletes.add(stackId);
                                        continue;
                                    }
                                    prevSet = next;
                                } else if (stack.getPathType().hasTarget()) {
                                    TransitRequest.TransitResponse response;
                                    Direction side = stack.getSide((LogisticalTransporterBase)this).getOpposite();
                                    IItemHandler acceptor = (IItemHandler)network.getCachedAcceptor(next, side);
                                    if (acceptor == null && stack.getPathType().isHome()) {
                                        acceptor = (IItemHandler)Capabilities.ITEM.getCapabilityIfLoaded(this.getLevel(), nextPos, side);
                                    }
                                    if (!(response = TransitRequest.simple((ItemStack)stack.itemStack).addToInventory(this.getLevel(), nextPos, acceptor, 0, stack.getPathType().isHome())).isEmpty()) {
                                        ItemStack rejected = response.getRejected();
                                        if (rejected.isEmpty()) {
                                            TransporterManager.remove((Level)this.getLevel(), (TransporterStack)stack);
                                            deletes.add(stackId);
                                            continue;
                                        }
                                        stack.itemStack = rejected;
                                    }
                                    prevSet = next;
                                }
                            }
                        }
                        if (!this.recalculate(stackId, stack, prevSet)) {
                            deletes.add(stackId);
                            continue;
                        }
                        if (prevSet == Long.MAX_VALUE) {
                            stack.progress = 50;
                            continue;
                        }
                        stack.progress = 0;
                        continue;
                    }
                    if (prevProgress >= 50 || stack.progress < 50) continue;
                    if (stack.isFinal((LogisticalTransporterBase)this)) {
                        Direction side;
                        ConnectionType connectionType;
                        TransporterStack.Path pathType = stack.getPathType();
                        tryRecalculate = pathType.hasTarget() ? !(connectionType = this.getConnectionType(side = stack.getSide((LogisticalTransporterBase)this))).canSendTo() || !TransporterUtils.canInsert((Level)this.getLevel(), (BlockPos)BlockPos.of((long)stack.getDest()), (EnumColor)stack.color, (ItemStack)stack.itemStack, (Direction)side, (boolean)pathType.isHome()) : true;
                    } else {
                        long nextPos = stack.getNext((LogisticalTransporterBase)this);
                        if (nextPos == Long.MAX_VALUE) {
                            tryRecalculate = true;
                        } else {
                            Direction nextSide = stack.getSide(this.getWorldPositionLong(), nextPos);
                            LogisticalTransporterBase nextTransmitter = (LogisticalTransporterBase)network.getTransmitter(nextPos);
                            if (nextTransmitter == null && stack.getPathType().noTarget() && stack.getPath().size() == 2) {
                                tryRecalculate = !this.getConnectionType(nextSide).canSendTo();
                            } else {
                                boolean bl = tryRecalculate = !stack.canInsertToTransporter(nextTransmitter, nextSide, (LogisticalTransporterBase)this);
                            }
                        }
                    }
                    if (!tryRecalculate || this.recalculate(stackId, stack, Long.MAX_VALUE)) continue;
                    deletes.add(stackId);
                }
                if (!deletes.isEmpty() || !this.needsSync.isEmpty()) {
                    PacketUtils.sendToAllTracking((CustomPacketPayload)PacketTransporterBatch.create((long)pos, (IntSet)deletes, (Int2ObjectMap)new Int2ObjectOpenHashMap(this.needsSync)), (BlockEntity)this.getTransmitterTile());
                    IntIterator ofInt = deletes.iterator();
                    while (ofInt.hasNext()) {
                        this.deleteStack(ofInt.nextInt());
                    }
                    this.needsSync.clear();
                    this.getTransmitterTile().markForSave();
                }
            }
        }
    }

    private boolean recalculate(int stackId, TransporterStack stack, long from) {
        boolean noPath;
        boolean bl = noPath = stack.getPathType().noTarget() || stack.recalculatePath((TransitRequest)TransitRequest.simple((ItemStack)stack.itemStack), (LogisticalTransporterBase)this, 0).isEmpty();
        if (noPath && !stack.calculateIdle((LogisticalTransporterBase)this)) {
            TransporterUtils.drop((LogisticalTransporterBase)this, (TransporterStack)stack);
            return false;
        }
        this.needsSync.put(stackId, (Object)stack);
        if (from != Long.MAX_VALUE) {
            stack.originalLocation = from;
        }
        return true;
    }
}

