/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.content.matrix;

import com.jerry.mekextras.common.content.matrix.ReinforcedMatrixEnergyContainer;
import com.jerry.mekextras.common.tile.multiblock.ExtraTileEntityInductionCell;
import com.jerry.mekextras.common.tile.multiblock.ExtraTileEntityInductionProvider;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ReinforcedMatrixMultiblockData
extends MultiblockData {
    public static final String STATS_TAB = "stats";
    private final List<MultiblockData.EnergyOutputTarget> energyOutputTargets = new ArrayList<MultiblockData.EnergyOutputTarget>();
    @NotNull
    private final ReinforcedMatrixEnergyContainer energyContainer = new ReinforcedMatrixEnergyContainer(this);
    @ContainerSync(getter="getLastOutput")
    private long clientLastOutput = 0L;
    @ContainerSync(getter="getLastInput")
    private long clientLastInput = 0L;
    @ContainerSync(getter="getEnergy")
    private long clientEnergy = 0L;
    @ContainerSync(tags={"stats"}, getter="getTransferCap")
    private long clientMaxTransfer = 0L;
    @ContainerSync(getter="getStorageCap")
    private long clientMaxEnergy = 0L;
    @ContainerSync(tags={"stats"}, getter="getProviderCount")
    private int clientProviders;
    @ContainerSync(tags={"stats"}, getter="getCellCount")
    private int clientCells;
    @NotNull
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    final EnergyInventorySlot energyInputSlot;
    @NotNull
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    final EnergyInventorySlot energyOutputSlot;

    public ReinforcedMatrixMultiblockData(TileEntityReinforcedInductionCasing tile) {
        super((BlockEntity)tile);
        this.energyContainers.add(this.energyContainer);
        this.energyInputSlot = EnergyInventorySlot.drain((IEnergyContainer)this.energyContainer, (IContentsListener)this, (int)146, (int)21);
        this.inventorySlots.add(this.energyInputSlot);
        this.energyOutputSlot = EnergyInventorySlot.fillOrConvert((IEnergyContainer)this.energyContainer, () -> ((TileEntityReinforcedInductionCasing)tile).getLevel(), (IContentsListener)this, (int)146, (int)51);
        this.inventorySlots.add(this.energyOutputSlot);
        this.energyInputSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.energyOutputSlot.setSlotOverlay(SlotOverlay.MINUS);
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.getEnergy(), (long)this.getStorageCap());
    }

    protected boolean shouldCap(MultiblockCache.CacheSubstance<?, ?> type) {
        return type != MultiblockCache.CacheSubstance.ENERGY;
    }

    public void addCell(ExtraTileEntityInductionCell cell) {
        this.energyContainer.addCell(cell.getBlockPos(), cell);
    }

    public void addProvider(ExtraTileEntityInductionProvider provider) {
        this.energyContainer.addProvider(provider.getBlockPos(), provider);
    }

    @NotNull
    public ReinforcedMatrixEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    public long getEnergy() {
        return this.isRemote() ? this.clientEnergy : this.energyContainer.getEnergy();
    }

    public boolean tick(Level world) {
        boolean ret = super.tick(world);
        this.energyContainer.tick();
        this.energyInputSlot.drainContainer();
        this.energyOutputSlot.fillContainerOrConvert();
        if (!this.energyOutputTargets.isEmpty() && !this.energyContainer.isEmpty()) {
            CableUtils.emit((Collection)this.getActiveOutputs(this.energyOutputTargets), (IEnergyContainer)this.energyContainer, (long)this.energyContainer.getMaxTransfer());
        }
        if (this.getLastInput() != 0L || this.getLastOutput() != 0L) {
            this.markDirtyComparator(world);
        }
        return ret;
    }

    public void remove(Level world, Structure oldStructure) {
        this.energyContainer.invalidate();
        super.remove(world, oldStructure);
    }

    protected void updateEjectors(Level world) {
        this.energyOutputTargets.clear();
        for (IValveHandler.ValveData valve : this.valves) {
            TileEntityReinforcedInductionPort tile = (TileEntityReinforcedInductionPort)WorldUtils.getTileEntity(TileEntityReinforcedInductionPort.class, (BlockGetter)world, (BlockPos)valve.location);
            if (tile == null) continue;
            tile.addEnergyTargetCapability(this.energyOutputTargets, valve.side);
        }
    }

    public long getStorageCap() {
        return this.isRemote() ? this.clientMaxEnergy : this.energyContainer.getMaxEnergy();
    }

    @ComputerMethod
    public long getTransferCap() {
        return this.isRemote() ? this.clientMaxTransfer : this.energyContainer.getMaxTransfer();
    }

    @ComputerMethod
    public long getLastInput() {
        return this.isRemote() ? this.clientLastInput : this.energyContainer.getLastInput();
    }

    @ComputerMethod
    public long getLastOutput() {
        return this.isRemote() ? this.clientLastOutput : this.energyContainer.getLastOutput();
    }

    @ComputerMethod(nameOverride="getInstalledCells")
    public int getCellCount() {
        return this.isRemote() ? this.clientCells : this.energyContainer.getCells();
    }

    @ComputerMethod(nameOverride="getInstalledProviders")
    public int getProviderCount() {
        return this.isRemote() ? this.clientProviders : this.energyContainer.getProviders();
    }
}

