/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras;

import com.jerry.genextras.common.content.naquadah.NaquadahReactorCache;
import com.jerry.genextras.common.content.naquadah.NaquadahReactorMultiblockData;
import com.jerry.genextras.common.content.naquadah.NaquadahReactorValidator;
import com.jerry.genextras.common.registries.GenExtraFluids;
import com.jerry.mekextras.common.ExtraLang;
import com.jerry.mekextras.common.capabilities.ExtraCapabilities;
import com.jerry.mekextras.common.command.builders.ExtraBuilders;
import com.jerry.mekextras.common.config.ExtraConfig;
import com.jerry.mekextras.common.content.matrix.ReinforcedMatrixMultiblockData;
import com.jerry.mekextras.common.content.matrix.ReinforcedMatrixValidator;
import com.jerry.mekextras.common.integration.ExtraHooks;
import com.jerry.mekextras.common.network.ExtraPacketHandler;
import com.jerry.mekextras.common.registries.ExtraBlocks;
import com.jerry.mekextras.common.registries.ExtraChemicals;
import com.jerry.mekextras.common.registries.ExtraContainerTypes;
import com.jerry.mekextras.common.registries.ExtraCreativeTabs;
import com.jerry.mekextras.common.registries.ExtraDataComponents;
import com.jerry.mekextras.common.registries.ExtraFluids;
import com.jerry.mekextras.common.registries.ExtraItems;
import com.jerry.mekextras.common.registries.ExtraRecipeSerializersInternal;
import com.jerry.mekextras.common.registries.ExtraTileEntityTypes;
import com.mojang.logging.LogUtils;
import mekanism.api.text.ILangEntry;
import mekanism.common.base.IModModule;
import mekanism.common.command.CommandMek;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.lib.Version;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;

@Mod(value="mekanism_extras")
public class MekanismExtras
implements IModModule {
    public static final String MOD_ID = "mekanism_extras";
    public static final String MOD_NAME = "MekanismExtras";
    public static final String FOLD_NAME = "Mekanism-Extras";
    private final ExtraPacketHandler extraPacketHandler;
    public static MekanismExtras instance;
    public static ExtraHooks hooks;
    public final Version versionNumber;
    public static final MultiblockManager<ReinforcedMatrixMultiblockData> matrixManager;
    public static final MultiblockManager<NaquadahReactorMultiblockData> naquadahReactorManager;
    public static final Logger LOGGER;

    public MekanismExtras(ModContainer modContainer, IEventBus modEventBus) {
        instance = this;
        this.versionNumber = new Version(modContainer);
        ExtraConfig.registerConfigs(modContainer);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        modEventBus.addListener(ExtraCapabilities::registerCapabilities);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(ExtraConfig::onConfigLoad);
        ExtraItems.register(modEventBus);
        ExtraBlocks.register(modEventBus);
        ExtraFluids.register(modEventBus);
        ExtraDataComponents.register(modEventBus);
        ExtraContainerTypes.register(modEventBus);
        ExtraTileEntityTypes.register(modEventBus);
        ExtraCreativeTabs.register(modEventBus);
        ExtraRecipeSerializersInternal.register(modEventBus);
        ExtraChemicals.register(modEventBus);
        this.extraPacketHandler = new ExtraPacketHandler(modEventBus, this.versionNumber);
        hooks.hookConstructor(modContainer, modEventBus);
    }

    public static ExtraPacketHandler extraPacketHandler() {
        return MekanismExtras.instance.extraPacketHandler;
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ExtraFluids.EXTRA_FLUIDS.registerBucketDispenserBehavior();
            if (MekanismExtras.hooks.mekanismGenerators.isLoaded()) {
                GenExtraFluids.GEN_EXTRA_FLUIDS.registerBucketDispenserBehavior();
            }
        });
    }

    private void registerCommands(RegisterCommandsEvent event) {
        BuildCommand.register((String)"reinforced_matrix", (ILangEntry)ExtraLang.REINFORCED_MATRIX, (StructureBuilder)new ExtraBuilders.ReinforcedMatrixBuilder());
        if (MekanismExtras.hooks.mekanismGenerators.isLoaded()) {
            BuildCommand.register((String)"naquadah", (ILangEntry)ExtraLang.NAQUADAH_REACTOR, (StructureBuilder)new ExtraBuilders.NaquadahReactorBuilder());
        }
        event.getDispatcher().register(CommandMek.register());
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Extras";
    }

    static {
        hooks = new ExtraHooks();
        matrixManager = new MultiblockManager("reinforcedInductionMatrix", MultiblockCache::new, ReinforcedMatrixValidator::new);
        naquadahReactorManager = new MultiblockManager("naquadahReactor", NaquadahReactorCache::new, NaquadahReactorValidator::new);
        LOGGER = LogUtils.getLogger();
    }
}

