/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.data;

import com.mojang.serialization.Codec;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class SlimedData {
    public static final Codec<SlimedData> CODEC = Codec.INT.xmap(SlimedData::new, d -> d.slimedTicks);
    public static final StreamCodec<RegistryFriendlyByteBuf, SlimedData> STREAM_CODEC = ByteBufCodecs.VAR_INT.map(SlimedData::new, d -> d.slimedTicks);
    private int slimedTicks;

    public SlimedData(int slimedTicks) {
        this.slimedTicks = slimedTicks;
    }

    public SlimedData() {
        this(0);
    }

    public void tick(LivingEntity entity) {
        if (this.slimedTicks > 0) {
            if (entity.isUnderWater()) {
                this.slimedTicks = 0;
                ModRegistry.SLIMED_DATA.sync((Object)entity);
            } else {
                --this.slimedTicks;
            }
        }
    }

    public void setSlimedTicks(LivingEntity entity, int newSlimedTicks) {
        int old = this.slimedTicks;
        this.slimedTicks = newSlimedTicks;
        if (!entity.level().isClientSide) {
            ModRegistry.SLIMED_DATA.sync((Object)entity);
            if (newSlimedTicks > old) {
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), ModSounds.SLIME_SPLAT.get(), entity.getSoundSource(), 1.0f, 1.0f);
            }
        }
    }

    public void clear(LivingEntity entity) {
        this.setSlimedTicks(entity, 0);
    }

    public boolean isSlimed() {
        return this.slimedTicks > 0;
    }

    public int getSlimedTicks() {
        return this.slimedTicks;
    }

    public static float getAlpha(LivingEntity le, float partialTicks) {
        if (!ClientConfigs.Tweaks.SLIME_OVERLAY.get().booleanValue()) {
            return 0.0f;
        }
        SlimedData data = (SlimedData)ModRegistry.SLIMED_DATA.getOrCreate((Object)le);
        float slimeTicks = (float)data.slimedTicks - partialTicks;
        float maxFade = 70.0f;
        return slimeTicks > maxFade ? 1.0f : Mth.clamp((float)(slimeTicks / maxFade), (float)0.0f, (float)1.0f);
    }
}

