/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.fire_behaviors;

import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SpawnEggBehavior
implements IFireItemBehavior {
    @Override
    public boolean fire(ItemStack stack, ServerLevel level, Vec3 firePos, Vec3 direction, float power, int inaccuracy, @Nullable Player owner) {
        EntityType type = ((SpawnEggItem)stack.getItem()).getType(stack);
        try {
            Object e = this.spawnMob(type, level, firePos, direction, power, stack, owner);
            if (e != null) {
                level.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, BlockPos.containing((Position)firePos));
                return true;
            }
        }
        catch (Exception exception) {
            Supplementaries.LOGGER.error("Error while dispensing spawn egg from trapped present at {}", (Object)BlockPos.containing((Position)firePos), (Object)exception);
        }
        return false;
    }

    @Nullable
    protected <T extends Entity> T spawnMob(EntityType<T> entityType, ServerLevel serverLevel, Vec3 firePos, Vec3 direction, float power, @Nullable ItemStack stack, @Nullable Player player) {
        Entity entity = entityType.create((Level)serverLevel);
        if (entity != null) {
            if (stack != null) {
                EntityType.createDefaultStackConfig((ServerLevel)serverLevel, (ItemStack)stack, (Player)player).accept(entity);
            }
            entity.setPos(firePos.x(), firePos.y(), firePos.z());
            entity.moveTo(firePos.x(), firePos.y(), firePos.z(), Mth.wrapDegrees((float)(serverLevel.random.nextFloat() * 360.0f)), 0.0f);
            entity.setDeltaMovement(direction.scale((double)power));
            entity.hasImpulse = true;
            entity.hurtMarked = true;
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.yHeadRot = mob.getYRot();
                mob.yBodyRot = mob.getYRot();
                mob.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.DISPENSER, null);
                mob.playAmbientSound();
            }
            serverLevel.addFreshEntity(entity);
        }
        return (T)entity;
    }
}

