/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class PropertyCountLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<PropertyCountLootFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> PropertyCountLootFunction.commonFields((RecordCodecBuilder.Instance)inst).and((App)Codec.STRING.fieldOf("countProperty").forGetter(f -> f.propertyName)).apply((Applicative)inst, PropertyCountLootFunction::new));
    private final String propertyName;

    protected PropertyCountLootFunction(List<LootItemCondition> conditionsIn, String propertyName) {
        super(conditionsIn);
        this.propertyName = propertyName;
    }

    @Nonnull
    protected ItemStack run(@Nonnull ItemStack stack, @Nonnull LootContext context) {
        BlockState blockstate = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (blockstate != null) {
            stack.setCount(this.getPropertyValue(blockstate));
        }
        return stack;
    }

    private int getPropertyValue(BlockState blockState) {
        for (Property prop : blockState.getProperties()) {
            if (!(prop instanceof IntegerProperty) || !prop.getName().equals(this.propertyName)) continue;
            return (Integer)blockState.getValue((Property)((IntegerProperty)prop));
        }
        return 1;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)IELootFunctions.PROPERTY_COUNT.value();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final String propertyName;

        public Builder(String propertyName) {
            this.propertyName = propertyName;
        }

        @Nonnull
        protected Builder getThis() {
            return this;
        }

        @Nonnull
        public LootItemFunction build() {
            return new PropertyCountLootFunction(this.getConditions(), this.propertyName);
        }
    }
}

