/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.mixin.accessors.FurnaceTEAccess;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class VanillaFurnaceHeater
implements ExternalHeaterHandler.IExternalHeatable {
    private static final int FULLY_HEATED_LIT_TIME = 200;
    private final FurnaceBlockEntity furnace;
    private long blockedUntilGameTime = 0L;

    public VanillaFurnaceHeater(FurnaceBlockEntity furnace) {
        this.furnace = furnace;
    }

    boolean canCook() {
        ItemStack input = this.furnace.getItem(0);
        if (input.isEmpty()) {
            return false;
        }
        Optional output = ((FurnaceTEAccess)this.furnace).getQuickCheck().getRecipeFor((RecipeInput)new SingleRecipeInput(this.furnace.getItem(0)), this.furnace.getLevel());
        if (output.isEmpty()) {
            return false;
        }
        ItemStack existingOutput = this.furnace.getItem(2);
        if (existingOutput.isEmpty()) {
            return true;
        }
        ItemStack outStack = ((AbstractCookingRecipe)((RecipeHolder)output.get()).value()).getResultItem((HolderLookup.Provider)this.furnace.getLevel().registryAccess());
        if (!ItemStack.isSameItem((ItemStack)existingOutput, (ItemStack)outStack)) {
            return false;
        }
        int stackSize = existingOutput.getCount() + outStack.getCount();
        return stackSize <= this.furnace.getMaxStackSize() && stackSize <= outStack.getMaxStackSize();
    }

    @Override
    public int doHeatTick(int energyAvailable, boolean redstone) {
        long now = this.furnace.getLevel().getGameTime();
        if (now < this.blockedUntilGameTime) {
            return 0;
        }
        int energyConsumed = 0;
        boolean canCook = this.canCook();
        if (canCook || redstone) {
            int energyToUse;
            ContainerData furnaceData = ((FurnaceTEAccess)this.furnace).getDataAccess();
            int burnTime = furnaceData.get(0);
            if (burnTime < 200) {
                int heatEnergyRatio = Math.max(1, ExternalHeaterHandler.defaultFurnaceEnergyCost);
                if (burnTime == 0 && energyAvailable < heatEnergyRatio) {
                    this.blockedUntilGameTime = now + 20L;
                    return 0;
                }
                int heatAttempt = Math.min(4, 200 - burnTime);
                int energyToUse2 = Math.min(energyAvailable, heatAttempt * heatEnergyRatio);
                int heat = energyToUse2 / heatEnergyRatio;
                if (heat > 0) {
                    furnaceData.set(0, burnTime + heat);
                    energyConsumed += heat * heatEnergyRatio;
                    this.setFurnaceActive();
                }
            }
            if (canCook && furnaceData.get(0) >= 200 && furnaceData.get(2) < furnaceData.get(3) - 1 && energyAvailable - energyConsumed > (energyToUse = ExternalHeaterHandler.defaultFurnaceSpeedupCost)) {
                energyConsumed += energyToUse;
                furnaceData.set(2, furnaceData.get(2) + 1);
            }
        }
        return energyConsumed;
    }

    public void setFurnaceActive() {
        BlockState oldState = this.furnace.getBlockState();
        if (!((Boolean)oldState.getValue((Property)AbstractFurnaceBlock.LIT)).booleanValue()) {
            this.furnace.getLevel().setBlockAndUpdate(this.furnace.getBlockPos(), (BlockState)oldState.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true)));
        }
    }
}

