/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.client.utils.FontUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.components.AttachedItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.ItemGetterList;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class EarmuffsItem
extends IEBaseItem
implements IConfigurableTool,
IEItemInterfaces.IColouredItem {
    public static final float MIN_MULTIPLIER = 0.05f;
    public static final float MAX_REDUCTION = 0.95f;
    public static ItemGetterList EARMUFF_GETTERS = new ItemGetterList(entity -> {
        ItemStack head = entity.getItemBySlot(EquipmentSlot.HEAD);
        if (head.getItem() instanceof EarmuffsItem) {
            return head;
        }
        AttachedItem contained = (AttachedItem)head.get(IEDataComponents.CONTAINED_EARMUFF);
        if (contained != null) {
            return contained.attached();
        }
        return ItemStack.EMPTY;
    });
    public static LinkedHashSet<String> affectedSoundCategories = Sets.newLinkedHashSet();

    public EarmuffsItem() {
        super(new Item.Properties().stacksTo(1).component(IEDataComponents.EARMUFF_DATA, (Object)EarmuffData.DEFAULT).component(IEDataComponents.COLOR, (Object)Color4.fromRGB(4746388)));
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int renderPass) {
        if (renderPass == 1) {
            return 0xFFFFFF;
        }
        return this.getColor(stack);
    }

    public boolean hasCustomColor(ItemStack stack) {
        return true;
    }

    public int getColor(ItemStack stack) {
        return ((Color4)stack.get(IEDataComponents.COLOR)).toInt();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        int color = this.getColourForIEItem(stack, 0);
        MutableComponent mainComponent = Component.translatable((String)"desc.immersiveengineering.info.colour").withStyle(ChatFormatting.GRAY);
        list.add((Component)FontUtils.withAppendColoredColour(mainComponent, color));
    }

    public static float getVolumeMod(ItemStack stack) {
        return ((EarmuffData)stack.getOrDefault(IEDataComponents.EARMUFF_DATA, (Object)EarmuffData.DEFAULT)).volumeMod;
    }

    @Override
    public boolean canConfigure(ItemStack stack) {
        return true;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigBoolean[] getBooleanOptions(ItemStack stack) {
        IConfigurableTool.ToolConfig.ToolConfigBoolean[] array = new IConfigurableTool.ToolConfig.ToolConfigBoolean[affectedSoundCategories.size()];
        int i = -1;
        for (String cat : affectedSoundCategories) {
            array[++i] = new IConfigurableTool.ToolConfig.ToolConfigBoolean(cat, 60 + i / 4 * 55, 32 + 10 * (i % 4), this.isMuted(stack, cat));
        }
        return array;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigFloat[] getFloatOptions(ItemStack stack) {
        return new IConfigurableTool.ToolConfig.ToolConfigFloat[]{new IConfigurableTool.ToolConfig.ToolConfigFloat("reductionValue", 60, 20, 0.95f - EarmuffsItem.getVolumeMod(stack), 0.0f, 0.95f)};
    }

    @Override
    public String fomatConfigName(ItemStack stack, IConfigurableTool.ToolConfig config) {
        if (config instanceof IConfigurableTool.ToolConfig.ToolConfigFloat) {
            return I18n.get((String)"gui.immersiveengineering.config.earmuffs.noisegate", (Object[])new Object[0]);
        }
        return I18n.get((String)("gui.immersiveengineering.config.earmuffs.soundcategory." + config.name), (Object[])new Object[0]);
    }

    @Override
    public String fomatConfigDescription(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return null;
    }

    @Override
    public void applyConfigOption(ItemStack stack, String key, Object value) {
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            EarmuffData oldData = (EarmuffData)stack.getOrDefault(IEDataComponents.EARMUFF_DATA, (Object)EarmuffData.DEFAULT);
            HashSet<String> newCategories = new HashSet<String>(oldData.affectedCategories);
            if (bool.booleanValue()) {
                newCategories.add(key);
            } else {
                newCategories.remove(key);
            }
            stack.set(IEDataComponents.EARMUFF_DATA, (Object)new EarmuffData(oldData.volumeMod, newCategories));
        } else if (value instanceof Float) {
            Float flt = (Float)value;
            EarmuffData oldData = (EarmuffData)stack.getOrDefault(IEDataComponents.EARMUFF_DATA, (Object)EarmuffData.DEFAULT);
            stack.set(IEDataComponents.EARMUFF_DATA, (Object)new EarmuffData(flt.floatValue(), oldData.affectedCategories));
        }
    }

    public boolean isMuted(ItemStack stack, String category) {
        return ((EarmuffData)stack.getOrDefault(IEDataComponents.EARMUFF_DATA, (Object)EarmuffData.DEFAULT)).affectedCategories.contains(category);
    }

    static {
        affectedSoundCategories.add("ambient");
        affectedSoundCategories.add("weather");
        affectedSoundCategories.add("record");
        affectedSoundCategories.add("block");
        affectedSoundCategories.add("neutral");
        affectedSoundCategories.add("hostile");
        affectedSoundCategories.add("player");
    }

    public record EarmuffData(float volumeMod, Set<String> affectedCategories) {
        public static final DualCodec<ByteBuf, EarmuffData> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.FLOAT.fieldOf("volumeMod"), EarmuffData::volumeMod, (DualMapCodec)DualCodecs.STRING.setOf().fieldOf("affectedCategories"), EarmuffData::affectedCategories, EarmuffData::new);
        public static final EarmuffData DEFAULT = new EarmuffData(0.1f, affectedSoundCategories);

        public EarmuffData {
            affectedCategories = Set.copyOf(affectedCategories);
        }
    }
}

