/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl;

import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperDummy;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockBEHelperCommon;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockBEHelperMaster;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockLevel;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MultiblockBEHelperDummy<State extends IMultiblockState>
extends MultiblockBEHelperCommon<State>
implements IMultiblockBEHelperDummy<State> {
    private final MultiblockLevel level;
    private BlockPos positionInMB;

    public MultiblockBEHelperDummy(BlockEntity be, MultiblockRegistration<State> multiblock) {
        super(be, multiblock, be.getBlockState());
        this.level = new MultiblockLevel(() -> ((BlockEntity)be).getLevel(), this.orientation, () -> {
            BlockPos absoluteOffset = this.orientation.getAbsoluteOffset(this.positionInMB);
            return be.getBlockPos().subtract((Vec3i)absoluteOffset);
        });
        this.positionInMB = BlockPos.ZERO;
    }

    @Override
    @Nullable
    public State getState() {
        return (State)this.getOnMaster(IMultiblockBEHelperMaster::getState);
    }

    @Override
    @Nullable
    public IMultiblockContext<State> getContext() {
        return this.getOnMaster(IMultiblockBEHelperMaster::getContext);
    }

    @Override
    @Nullable
    protected IMultiblockBEHelperMaster<State> getMasterHelperWithChunkloads() {
        return this.getMasterHelper(this.level.forciblyGetBlockEntity(this.multiblock.masterPosInMB()));
    }

    @Override
    public void load(CompoundTag tag, HolderLookup.Provider provider) {
        String key = tag.contains("posInMultiblock", 10) ? "posInMultiblock" : "posInMB";
        this.positionInMB = (BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)key).orElseThrow();
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("posInMB", NbtUtils.writeBlockPos((BlockPos)this.positionInMB));
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag result = new CompoundTag();
        this.saveAdditional(result, provider);
        return result;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        this.load(tag, provider);
    }

    @Override
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this.be);
    }

    @Override
    public void onDataPacket(CompoundTag tag, HolderLookup.Provider provider) {
        this.load(tag, provider);
    }

    @Override
    public MultiblockRegistration<State> getMultiblock() {
        return this.multiblock;
    }

    @Nullable
    private <T> T getOnMaster(Function<IMultiblockBEHelperMaster<State>, T> get) {
        IMultiblockBEHelperMaster<State> master = this.getIMasterHelper();
        if (master != null) {
            return get.apply(master);
        }
        return null;
    }

    @Override
    @Nullable
    protected MultiblockBEHelperMaster<State> getMasterHelper() {
        MultiblockBEHelperMaster helper;
        IMultiblockBEHelperMaster<State> iMultiblockBEHelperMaster = this.getIMasterHelper();
        return iMultiblockBEHelperMaster instanceof MultiblockBEHelperMaster ? (helper = (MultiblockBEHelperMaster)iMultiblockBEHelperMaster) : null;
    }

    @Nullable
    protected IMultiblockBEHelperMaster<State> getIMasterHelper() {
        return this.getMasterHelper(this.level.getBlockEntity(this.multiblock.masterPosInMB()));
    }

    private IMultiblockBEHelperMaster<State> getMasterHelper(BlockEntity beAtMasterPos) {
        if (!(beAtMasterPos instanceof MultiblockBlockEntityMaster)) {
            return null;
        }
        MultiblockBlockEntityMaster masterBE = (MultiblockBlockEntityMaster)beAtMasterPos;
        IMultiblockBEHelper masterHelper = masterBE.getHelper();
        if (masterHelper.getMultiblock() == this.multiblock) {
            return masterHelper;
        }
        return null;
    }

    @Override
    public void setPositionInMB(BlockPos pos) {
        Preconditions.checkArgument((!this.multiblock.masterPosInMB().equals((Object)pos) ? 1 : 0) != 0);
        this.positionInMB = pos;
        this.be.setChanged();
    }

    @Override
    public BlockPos getPositionInMB() {
        return this.positionInMB;
    }
}

