/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallback;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.models.mirror.MirroredModelLoader;
import blusunrize.immersiveengineering.client.models.obj.GeneralIEOBJModel;
import blusunrize.immersiveengineering.client.models.obj.GlobalTempData;
import blusunrize.immersiveengineering.client.models.obj.MaterialColorGetter;
import blusunrize.immersiveengineering.client.models.obj.MaterialSpriteGetter;
import blusunrize.immersiveengineering.client.models.obj.TextureCoordinateRemapper;
import blusunrize.immersiveengineering.client.models.split.PolygonUtils;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.modelsplitter.model.Group;
import malte0811.modelsplitter.model.MaterialLibrary;
import malte0811.modelsplitter.model.Polygon;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SpecificIEOBJModel<T>
implements BakedModel {
    private static final Map<Direction, List<BakedQuad>> EMPTY_ALL_SIDES = (Map)Util.make(new EnumMap(Direction.class), map -> {
        for (Direction d : DirectionUtils.VALUES) {
            map.put(d, List.of());
        }
    });
    private final GeneralIEOBJModel<T> baseModel;
    @Nonnull
    private final IEOBJCallback<T> callback;
    private final T key;
    @Nullable
    private final ShaderCase shader;
    private final IEProperties.IEObjState state;
    @Nullable
    private final RenderType layer;
    private final List<BakedQuad> quads;
    private final Supplier<BakedModel> inverted;
    private static final Matrix4f INVERT = new Matrix4f().scale(-1.0f, -1.0f, -1.0f);
    private static final Matrix3f INVERT_NORMAL = new Matrix3f((Matrix4fc)INVERT);

    public SpecificIEOBJModel(GeneralIEOBJModel<T> baseModel, T key, @Nullable ShaderCase shader, @Nullable RenderType layer) {
        this.baseModel = baseModel;
        this.callback = baseModel.getCallback();
        this.key = key;
        this.shader = shader;
        this.state = this.callback.getIEOBJState(key);
        this.layer = layer;
        this.quads = this.buildQuads();
        this.inverted = Suppliers.memoize(() -> new SimpleBakedModel(MirroredModelLoader.reversedQuads(this.quads), EMPTY_ALL_SIDES, baseModel.useAmbientOcclusion(), baseModel.usesBlockLight(), baseModel.isGui3d(), baseModel.getParticleIcon(), ItemTransforms.NO_TRANSFORMS, baseModel.getOverrides()){

            public boolean isCustomRenderer() {
                return SpecificIEOBJModel.this.isCustomRenderer();
            }
        });
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState pState, @Nullable Direction pSide, @Nonnull RandomSource pRand) {
        if (pSide != null) {
            return List.of();
        }
        return this.quads;
    }

    public boolean useAmbientOcclusion() {
        return this.baseModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.baseModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.baseModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        GlobalTempData.setActiveModel(this);
        return this.baseModel.isCustomRenderer();
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon() {
        return this.baseModel.getParticleIcon();
    }

    @Nonnull
    public ItemOverrides getOverrides() {
        return this.baseModel.getOverrides();
    }

    @Nonnull
    public List<RenderType> getRenderTypes(@Nonnull ItemStack itemStack, boolean fabulous) {
        if (this.layer != null) {
            return List.of(this.layer);
        }
        return this.baseModel.getRenderTypes(itemStack, fabulous);
    }

    public ItemTransform getBaseTransforms(@Nonnull ItemDisplayContext transformType) {
        return this.baseModel.getOwner().getTransforms().getTransform(transformType);
    }

    @Nonnull
    public BakedModel applyTransform(@Nonnull ItemDisplayContext transformType, @Nonnull PoseStack transforms, boolean applyLeftHandTransform) {
        SpecificIEOBJModel result = this;
        ItemTransform baseItemTransform = this.getBaseTransforms(transformType);
        Vector3f scale = baseItemTransform.scale;
        if (scale.x() * scale.y() * scale.z() < 0.0f) {
            Vector3f newScale = new Vector3f((Vector3fc)scale);
            newScale.mul(-1.0f);
            new ItemTransform(baseItemTransform.rotation, baseItemTransform.translation, newScale, baseItemTransform.rightRotation).apply(applyLeftHandTransform, transforms);
            transforms.last().pose().mul((Matrix4fc)INVERT);
            transforms.last().normal().mul((Matrix3fc)INVERT_NORMAL);
            if (!this.isCustomRenderer()) {
                result = this.inverted.get();
            }
        } else {
            baseItemTransform.apply(applyLeftHandTransform, transforms);
        }
        ItemCallback.castOrDefault(this.callback).handlePerspective(this.key, GlobalTempData.getActiveHolder(), transformType, transforms);
        return result;
    }

    private List<BakedQuad> buildQuads() {
        List<Object> quads = Lists.newArrayList();
        for (Map.Entry<String, Group<MaterialLibrary.OBJMaterial>> groupName : this.baseModel.getGroups().entrySet()) {
            List<ShadedQuads> temp = this.addQuadsForGroup(groupName.getKey(), groupName.getValue(), true);
            quads.addAll(temp.stream().map(ShadedQuads::quadsInLayer).flatMap(Collection::stream).filter(Objects::nonNull).toList());
        }
        quads = this.callback.modifyQuads(this.key, (List<BakedQuad>)quads);
        return ImmutableList.copyOf((Collection)quads);
    }

    public List<ShadedQuads> addQuadsForGroup(String groupName, Group<MaterialLibrary.OBJMaterial> group, boolean allowCaching) {
        List cached;
        GeneralIEOBJModel.GroupKey<T> cacheKey = new GeneralIEOBJModel.GroupKey<T>(this.key, this.shader, this.layer, groupName);
        if (allowCaching && (cached = (List)this.baseModel.getGroupCache().getIfPresent(cacheKey)) != null) {
            return cached;
        }
        int numPasses = this.shader != null ? this.shader.getLayers().length : 1;
        ArrayList<ShadedQuads> ret = new ArrayList<ShadedQuads>();
        Transformation optionalTransform = this.baseModel.getSprite().getRotation();
        optionalTransform = this.callback.applyTransformations(this.key, groupName, optionalTransform);
        MaterialSpriteGetter<T> spriteGetter = new MaterialSpriteGetter<T>(this.baseModel.getSpriteGetter(), groupName, this.callback, this.key, this.shader);
        MaterialColorGetter<T> colorGetter = new MaterialColorGetter<T>(groupName, this.callback, this.key, this.shader);
        TextureCoordinateRemapper coordinateRemapper = new TextureCoordinateRemapper(this.shader);
        if (this.state.visibility().isVisible(groupName) && this.callback.shouldRenderGroup(this.key, groupName, this.layer)) {
            for (int pass = 0; pass < numPasses; ++pass) {
                if (this.shader != null && !this.shader.shouldRenderGroupForPass(groupName, pass)) continue;
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                spriteGetter.setRenderPass(pass);
                colorGetter.setRenderPass(pass);
                coordinateRemapper.setRenderPass(pass);
                this.addGroupQuads(group, this.baseModel.getOwner(), quads::add, spriteGetter, colorGetter, coordinateRemapper, this.state.transform().compose(optionalTransform.blockCenterToCorner()));
                ShaderLayer layer = this.shader != null ? this.shader.getLayers()[pass] : new ShaderLayer(this, ResourceLocation.withDefaultNamespace((String)"missing/no"), -1){

                    @Override
                    public RenderType getRenderType(RenderType baseType) {
                        return baseType;
                    }
                };
                ret.add(new ShadedQuads(layer, quads));
            }
        }
        if (allowCaching) {
            this.baseModel.getGroupCache().put(cacheKey, ret);
        }
        return ret;
    }

    private void addGroupQuads(Group<MaterialLibrary.OBJMaterial> group, IGeometryBakingContext owner, Consumer<BakedQuad> out, MaterialSpriteGetter<?> spriteGetter, MaterialColorGetter<?> colorGetter, TextureCoordinateRemapper coordinateRemapper, Transformation transform) {
        for (Polygon face : group.getFaces()) {
            MaterialLibrary.OBJMaterial mat = (MaterialLibrary.OBJMaterial)face.getTexture();
            if (mat == null) continue;
            TextureAtlasSprite texture = spriteGetter.apply(mat.name(), UnbakedGeometryHelper.resolveDirtyMaterial((String)mat.map_Kd(), (IGeometryBakingContext)owner));
            Color4 colorTint = colorGetter.apply(mat.name(), Color4.WHITE);
            Polygon<MaterialLibrary.OBJMaterial> remappedFace = coordinateRemapper.remapCoord((Polygon<MaterialLibrary.OBJMaterial>)face);
            if (remappedFace == null) continue;
            out.accept(PolygonUtils.toBakedQuad(remappedFace.getPoints(), new PolygonUtils.ExtraQuadData(texture, colorTint), transform, this.callback.useAbsoluteUV(this.key, mat.name()), this.callback.shadeQuads(this.key, mat.name())));
        }
    }

    public Map<String, Group<MaterialLibrary.OBJMaterial>> getGroups() {
        return this.baseModel.getGroups();
    }

    @Nonnull
    public IEOBJCallback<T> getCallback() {
        return this.callback;
    }

    public T getKey() {
        return this.key;
    }

    public record ShadedQuads(ShaderLayer layer, List<BakedQuad> quadsInLayer) {
    }
}

