/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks.blocks.component;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ComparatorManager<State>
implements IServerTickableComponent<WrappedState<State>>,
IMultiblockComponent.StateWrapper<State, WrappedState<State>> {
    private final ComparatorValue<State> valueGetter;
    private final List<BlockPos> positions;

    public static <State> ComparatorManager<State> makeSimple(SimpleComparatorValue<State> value, BlockPos ... positions) {
        return new ComparatorManager<State>(value, positions);
    }

    public ComparatorManager(ComparatorValue<State> value, BlockPos ... positions) {
        this.valueGetter = value;
        this.positions = Arrays.asList(positions);
    }

    @Override
    public void tickServer(IMultiblockContext<WrappedState<State>> ctx) {
        WrappedState<State> state = ctx.getState();
        int newValue = this.valueGetter.getComparatorValue(state.inner, ctx.getLevel());
        if (newValue != state.lastValue) {
            for (BlockPos position : this.positions) {
                ctx.setComparatorOutputFor(position, newValue);
            }
            state.lastValue = newValue;
        }
    }

    @Override
    public WrappedState<State> wrapState(State outer) {
        return new WrappedState<State>(outer);
    }

    public static interface ComparatorValue<State> {
        public int getComparatorValue(State var1, IMultiblockLevel var2);
    }

    public static class WrappedState<T> {
        private final T inner;
        private int lastValue = -1;

        public WrappedState(T inner) {
            this.inner = inner;
        }
    }

    public static interface SimpleComparatorValue<State>
    extends ComparatorValue<State> {
        public static <State extends IMultiblockState> SimpleComparatorValue<State> inventory(Function<State, IItemHandler> getInv, int minSlot, int numSlots) {
            return state -> {
                int i = 0;
                float f = 0.0f;
                IItemHandler inv = (IItemHandler)getInv.apply(state);
                for (int j = minSlot; j < minSlot + numSlots; ++j) {
                    ItemStack itemstack = inv.getStackInSlot(j);
                    if (itemstack.isEmpty()) continue;
                    f += (float)itemstack.getCount() / (float)Math.min(inv.getSlotLimit(j), itemstack.getMaxStackSize());
                    ++i;
                }
                return Mth.floor((float)((f /= (float)numSlots) * 14.0f)) + (i > 0 ? 1 : 0);
            };
        }

        public int getComparatorValue(State var1);

        @Override
        default public int getComparatorValue(State state, IMultiblockLevel level) {
            return this.getComparatorValue(state);
        }
    }
}

