/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;

public class SqueezerRecipe
extends MultiblockRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<SqueezerRecipe>> SERIALIZER;
    public static final CachedRecipeList<SqueezerRecipe> RECIPES;
    public static final SetRestrictedField<MultiblockRecipe.RecipeMultiplier> MULTIPLIERS;
    public IngredientWithSize input;
    public final FluidStack fluidOutput;
    @Nonnull
    public final TagOutput itemOutput;

    public SqueezerRecipe(FluidStack fluidOutput, @Nonnull TagOutput itemOutput, IngredientWithSize input, int energy) {
        super(itemOutput, IERecipeTypes.SQUEEZER, 80, energy, MULTIPLIERS);
        this.fluidOutput = fluidOutput;
        this.itemOutput = itemOutput;
        this.input = input;
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
        this.outputList = new TagOutputList(this.itemOutput);
    }

    protected IERecipeSerializer<SqueezerRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public SqueezerRecipe setInputSize(int size) {
        this.input = this.input.withSize(size);
        return this;
    }

    public static RecipeHolder<SqueezerRecipe> findRecipe(Level level, ItemStack input) {
        if (input.isEmpty()) {
            return null;
        }
        for (RecipeHolder<SqueezerRecipe> recipe : RECIPES.getRecipes(level)) {
            if (!((SqueezerRecipe)recipe.value()).input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    public static SortedMap<Component, Integer> getFluidValuesSorted(Level level, Fluid f, boolean inverse) {
        TreeMap<Component, Integer> map = new TreeMap<Component, Integer>(Comparator.comparing(Component::getString, inverse ? Comparator.reverseOrder() : Comparator.naturalOrder()));
        for (RecipeHolder<SqueezerRecipe> holder : RECIPES.getRecipes(level)) {
            SqueezerRecipe recipe = (SqueezerRecipe)holder.value();
            if (recipe.fluidOutput == null || recipe.fluidOutput.getFluid() != f || recipe.input.hasNoMatchingItems()) continue;
            ItemStack is = recipe.input.getMatchingStacks()[0];
            map.put(is.getHoverName(), recipe.fluidOutput.getAmount());
        }
        return map;
    }

    static {
        RECIPES = new CachedRecipeList<SqueezerRecipe>(IERecipeTypes.SQUEEZER);
        MULTIPLIERS = SetRestrictedField.common();
    }
}

