/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.util;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.common.data.FluxPlayerData;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.Messages;

public class FluxCommands {
    public static void register(@Nonnull CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"fluxnetworks").then(((LiteralArgumentBuilder)Commands.literal((String)"superadmin").requires(s -> s.hasPermission(1))).then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(s -> FluxCommands.superAdmin((CommandSourceStack)s.getSource(), GameProfileArgument.getGameProfiles((CommandContext)s, (String)"targets"), BoolArgumentType.getBool((CommandContext)s, (String)"enable")))))));
    }

    private static int superAdmin(@Nonnull CommandSourceStack source, @Nonnull Collection<GameProfile> profiles, boolean enable) {
        PlayerList playerList = source.getServer().getPlayerList();
        int success = 0;
        for (GameProfile profile : profiles) {
            FluxPlayerData fp;
            ServerPlayer player = playerList.getPlayer(profile.getId());
            if (player == null || (fp = FluxUtils.getPlayerData(player)) == null || (!fp.isSuperAdmin() && !FluxConfig.enableSuperAdmin || !source.hasPermission(3)) && (player != source.getEntity() || !fp.isSuperAdmin() && !FluxPlayerData.canActivateSuperAdmin(player)) || !fp.setSuperAdmin(enable)) continue;
            Messages.syncCapability(player);
            player.sendSystemMessage((Component)Component.translatable((String)(enable ? "gui.fluxnetworks.superadmin.on" : "gui.fluxnetworks.superadmin.off")));
            ++success;
        }
        return success;
    }
}

